/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.xscript.context;

import com.bea.wlw.netui.pageflow.PageFlowController;
import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.script.xscript.ContextHelper;
import com.bea.wlw.netui.script.xscript.ContextResolver;
import com.bea.wlw.netui.script.xscript.IllegalContextStateException;
import com.bea.wlw.netui.util.Bundle;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import knex.scripting.javascript.Scriptable;

public class PageFlowContextResolver
extends ContextResolver {
    public boolean isRequestWritable() {
        return true;
    }

    public String getContextName() {
        return "pageFlow";
    }

    public void resolve(Scriptable scope, String expression, Map contexts) {
        PageFlowController jpf;
        if (contexts.containsKey("request") && contexts.get("request") != null) {
            jpf = PageFlowUtils.ensureCurrentPageFlow((HttpServletRequest)((HttpServletRequest)contexts.get("request")), (HttpServletResponse)((HttpServletResponse)contexts.get("response")));
            if (jpf == null) {
                IllegalContextStateException ics = new IllegalContextStateException("There is no current PageFlowController for the expression \"" + expression + "\".");
                ics.setLocalizedMessage(Bundle.getErrorString((String)"XScript_PageFlowContextResolver_noPageFlow", (Object[])new Object[]{expression}));
                throw ics;
            }
        } else {
            IllegalContextStateException ics = new IllegalContextStateException("The Request could not be found; can not create the pageFlow binding context for the expression \"" + expression + "\".");
            ics.setLocalizedMessage(Bundle.getErrorString((String)"XScript_PageFlowContextResolver_noRequest", (Object[])new Object[]{expression}));
            throw ics;
        }
        scope.put(this.getContextName(), scope, (Object)ContextHelper.toObject(jpf, scope));
    }

    public void afterUpdate(String expression, Map contexts) {
        PageFlowController jpf;
        HttpServletRequest request;
        if (contexts.containsKey("request") && (request = (HttpServletRequest)contexts.get("request")) != null && (jpf = PageFlowUtils.getCurrentPageFlow((HttpServletRequest)request)) != null) {
            jpf.ensureFailover(request);
        }
        super.afterUpdate(expression, contexts);
    }
}

