/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.xscript;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import knex.scripting.javascript.WrappedException;

class Util {
    Util() {
    }

    static String getAvailableContextNamesString(Map contexts) {
        String[] ary = Util.getAvailableContextNames(contexts);
        StringBuffer buf = new StringBuffer();
        if (ary.length == 0) {
            buf.append("[]");
        } else {
            buf.append("[");
            int i = 0;
            while (i < ary.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(ary[i]);
                ++i;
            }
            buf.append("]");
        }
        return buf.toString();
    }

    static String[] getAvailableContextNames(Map contexts) {
        if (contexts == null) {
            return new String[0];
        }
        Iterator iterator = contexts.keySet().iterator();
        String[] ary = new String[contexts.size()];
        int i = 0;
        while (iterator.hasNext()) {
            ary[i] = iterator.next().toString();
            ++i;
        }
        return ary;
    }

    static Throwable getRootCause(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    static String getLocalizedRootCauseMessage(Throwable t) {
        if ((t = Util.getRootCause(t)).getLocalizedMessage() != null) {
            return t.getLocalizedMessage();
        }
        return t.getMessage();
    }

    static String exceptionToString(Throwable t, boolean stackTrace) {
        if (t instanceof WrappedException) {
            t = (Throwable)((WrappedException)t).unwrap();
        }
        String message = t.toString();
        String LINE_BREAK = "\n";
        StringBuffer buf = new StringBuffer();
        if (message != null) {
            buf.append(message);
            buf.append(LINE_BREAK);
        }
        buf.append(t.getMessage());
        buf.append(LINE_BREAK);
        if (t.getCause() != null) {
            buf.append("Caused by: ");
            buf.append(t.getCause().toString());
        }
        buf.append(LINE_BREAK);
        if (stackTrace) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            pw.close();
            buf.append(sw.toString());
        }
        return buf.toString();
    }
}

