/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.xscript;

import com.bea.wlw.netui.script.xscript.AttributeParser;
import com.bea.wlw.netui.script.xscript.ComplexTypeNativeJavaObject;
import com.bea.wlw.netui.script.xscript.ContextResolver;
import com.bea.wlw.netui.script.xscript.IllegalContextConfigurationException;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.XMLString;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import knex.scripting.javascript.Scriptable;

public final class ContextHelper {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$ContextHelper == null ? (class$com$bea$wlw$netui$script$xscript$ContextHelper = ContextHelper.class$("com.bea.wlw.netui.script.xscript.ContextHelper")) : class$com$bea$wlw$netui$script$xscript$ContextHelper));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$ContextHelper == null ? (class$com$bea$wlw$netui$script$xscript$ContextHelper = ContextHelper.class$("com.bea.wlw.netui.script.xscript.ContextHelper")) : class$com$bea$wlw$netui$script$xscript$ContextHelper));
    private static final String CONTEXT_PROPERTIES_FILE = "com/bea/wlw/netui/script/xscript/context.properties";
    private static final Map contexts = new HashMap();
    private static ContextResolver def;
    static /* synthetic */ Class class$com$bea$wlw$netui$script$xscript$ContextHelper;

    public static final Scriptable toObject(Object javaObject, Scriptable scope) {
        if (ContextHelper.debug.ON) {
            debug.out("create a Scriptable instance from object of type: " + javaObject.getClass().getName());
        }
        if (javaObject instanceof XMLString) {
            return ((XMLString)javaObject).getRuntimeXML();
        }
        if (javaObject instanceof Scriptable) {
            return (Scriptable)javaObject;
        }
        return new ComplexTypeNativeJavaObject(javaObject, scope);
    }

    static ContextResolver lookup(String contextName) {
        if (contexts.keySet().size() == 0) {
            ContextHelper.loadContexts();
        }
        if (ContextHelper.debug.ON) {
            debug.out("contextName: " + contextName);
        }
        ContextResolver cr = (ContextResolver)contexts.get(contextName);
        return cr;
    }

    static final ContextResolver initializeScope(AttributeParser.ExprTerm term) {
        if (ContextHelper.debug.ON) {
            debug.out("term: " + term.getExpression() + " strict: " + term.isStrict());
        }
        if (term.isStrict()) {
            String contextKey = term.getContext();
            ContextResolver contextR = ContextHelper.lookup(contextKey);
            if (ContextHelper.debug.ON) {
                debug.out("expression: \"" + term.getExpression() + "\" context: \"" + (contextR != null ? contextR.getClass().getName() : "null") + "\"");
            }
            return contextR;
        }
        return null;
    }

    private static void loadContexts() {
        if (ContextHelper.debug.ON) {
            debug.out("***** Initialize contexts");
        }
        InputStream is = (class$com$bea$wlw$netui$script$xscript$ContextHelper == null ? (class$com$bea$wlw$netui$script$xscript$ContextHelper = ContextHelper.class$("com.bea.wlw.netui.script.xscript.ContextHelper")) : class$com$bea$wlw$netui$script$xscript$ContextHelper).getClassLoader().getResourceAsStream(CONTEXT_PROPERTIES_FILE);
        Properties config = new Properties();
        try {
            if (is == null) {
                IllegalContextConfigurationException icc = new IllegalContextConfigurationException("Could not load resource as stream \"com/bea/wlw/netui/script/xscript/context.properties\"");
                icc.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ContextHelper_missingContextProperties", (Object[])new Object[]{CONTEXT_PROPERTIES_FILE}));
                throw icc;
            }
            config.load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Iterator<Object> iterator = config.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equals("default")) continue;
            ContextResolver cr = null;
            Class<?> clazz = null;
            try {
                if (ContextHelper.debug.ON) {
                    debug.out("contextName: " + key + " class: " + config.get(key));
                }
                clazz = Class.forName((String)config.get(key));
                cr = (ContextResolver)clazz.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                String msg = null;
                msg = clazz == null ? Bundle.getErrorString((String)"XScript_ContextHelper_nullClassNotFound", (Object[])new Object[]{key}) : Bundle.getErrorString((String)"XScript_ContextHelper_classNotFound", (Object[])new Object[]{key, clazz.getName()});
                System.err.println(msg);
                continue;
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Could not find XScript binding context implementation for key \"" + key + "\" with classname \"" + (clazz != null ? clazz.getName() : "null")));
                }
                String msg = null;
                if (clazz == null) {
                    msg = Bundle.getErrorString((String)"XScript_ContextHelper_nullClassNotFound", (Object[])new Object[]{key});
                    continue;
                }
                msg = Bundle.getErrorString((String)"XScript_ContextHelper_cantCreateClass", (Object[])new Object[]{key, clazz.getName()});
                continue;
            }
            contexts.put(key, cr);
        }
        if (config.get("default") != null) {
            def = (ContextResolver)contexts.get(config.get("default"));
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Available binding contexts:\n");
        iterator = contexts.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ContextResolver cr = (ContextResolver)contexts.get(key);
            buf.append("key: " + key + " type: " + cr.getClass().getName() + "\n");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)buf.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

