/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.xscript;

import com.bea.wlw.netui.script.Expression;
import com.bea.wlw.netui.script.IllegalExpressionException;
import com.bea.wlw.netui.script.xscript.ContextChangeException;
import com.bea.wlw.netui.script.xscript.IllegalContextArgumentException;
import com.bea.wlw.netui.script.xscript.ScriptParser;
import com.bea.wlw.netui.script.xscript.ScriptParsingException;
import com.bea.wlw.netui.script.xscript.StrictParsingException;
import com.bea.wlw.netui.script.xscript.Util;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.cache.ConcurrentReaderHashMap;
import com.bea.wlw.netui.util.debug.Debug;
import java.util.ArrayList;
import java.util.List;

class AttributeParser {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$AttributeParser == null ? (class$com$bea$wlw$netui$script$xscript$AttributeParser = AttributeParser.class$("com.bea.wlw.netui.script.xscript.AttributeParser")) : class$com$bea$wlw$netui$script$xscript$AttributeParser));
    private static final ConcurrentReaderHashMap paCache = new ConcurrentReaderHashMap();
    static /* synthetic */ Class class$com$bea$wlw$netui$script$xscript$AttributeParser;

    AttributeParser() {
    }

    static ExprTerm createExprTermStrict(String expr) {
        return new ExprTerm(expr, true);
    }

    static String createExpression(String text) {
        return "{" + text + "}";
    }

    static String qualify(String contextName, String expr) {
        ParsedAttribute pa = AttributeParser.parse(expr, true);
        return AttributeParser.createExpression(pa.qualify(contextName));
    }

    static ParsedAttribute parse(String expression, boolean strictParsing) {
        if (AttributeParser.debug.ON) {
            debug.out("expression: " + expression);
        }
        if (expression == null) {
            return null;
        }
        if (paCache.containsKey((Object)expression)) {
            return (ParsedAttribute)paCache.get((Object)expression);
        }
        ParsedAttribute pa = new ParsedAttribute(expression);
        try {
            int NONE = 0;
            int SINGLE = 1;
            int DOUBLE = 2;
            String cs = expression;
            int start = 0;
            int end = 0;
            int len = cs.length();
            boolean inExpr = false;
            int quote = NONE;
            int i = 0;
            while (i < len) {
                char curr = cs.charAt(i);
                if (inExpr) {
                    if (curr == '\'' && quote == NONE) {
                        quote = SINGLE;
                    } else if (curr == '\'' && quote == SINGLE && cs.charAt(i - 1) != '\\') {
                        quote = NONE;
                    } else if (curr == '\"' && quote == NONE) {
                        quote = DOUBLE;
                    } else if (curr == '\"' && quote == DOUBLE && cs.charAt(i - 1) != '\\') {
                        quote = NONE;
                    }
                }
                if (quote == NONE && curr == '{' && (i == 0 || i > 0 && cs.charAt(i - 1) != '\\' || i > 1 && cs.charAt(i - 1) == '\\' && cs.charAt(i - 2) == '\\') && i != len - 1) {
                    if (inExpr) {
                        IllegalExpressionException iee = new IllegalExpressionException("Can not have expressions nested within expressions in expression \"" + expression + "\"", expression);
                        iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_nestedExpressions", (Object[])new Object[]{expression}));
                        throw iee;
                    }
                    start = i;
                    inExpr = true;
                    if (i != 0 && start - end > 0) {
                        if (i > 1 && cs.charAt(i - 1) == '\\' && cs.charAt(i - 2) == '\\') {
                            pa.addTerm(new LiteralTerm(cs.subSequence(end, start - 1).toString()));
                        } else {
                            pa.addTerm(new LiteralTerm(cs.subSequence(end, start).toString()));
                        }
                    }
                } else if (quote == NONE && curr == '}' && inExpr && i != 0 && cs.charAt(i - 1) != '\\') {
                    ExprTerm term = new ExprTerm(cs.subSequence(start + 1, i).toString(), strictParsing);
                    pa.addTerm(term);
                    end = start = i + 1;
                    inExpr = false;
                } else if (i == len - 1 && end <= i) {
                    if (inExpr) {
                        throw new IllegalExpressionException("Expression is opened but never closed");
                    }
                    pa.addTerm(new LiteralTerm(cs.subSequence(start, i + 1).toString()));
                }
                ++i;
            }
        }
        catch (ScriptParsingException spe) {
            IllegalExpressionException iee = new IllegalExpressionException("The expression \"" + expression + "\" threw an exception parsing the XScript expression \"" + spe.getExpression() + "\" because: " + Util.getRootCause((Throwable)((Object)spe)).toString(), expression);
            iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_parseException", (Object[])new Object[]{expression, spe.getExpression(), Util.getLocalizedRootCauseMessage((Throwable)((Object)spe))}));
            throw iee;
        }
        catch (IllegalExpressionException iee) {
            throw iee;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        pa.seal();
        paCache.put((Object)expression, (Object)pa);
        return pa;
    }

    static void printParsedExpression(ParsedAttribute pa) {
        StringBuffer buf = new StringBuffer();
        buf.append("\nExpression: " + pa.getExpression() + "\n");
        List list = pa.getTerms();
        if (list == null) {
            buf.append("<empty expression>");
        } else {
            buf.append("size: " + list.size() + "\n");
            int i = 0;
            while (i < list.size()) {
                AttrTerm t = (AttrTerm)list.get(i);
                buf.append("type: " + t.getClass().getName() + "\n");
                buf.append("term: '" + t.toString() + "'\n");
                ++i;
            }
        }
        if (AttributeParser.debug.ON) {
            debug.out("\nexpression:\n" + buf.toString());
        }
    }

    static String changeContext(String expression, String oldContext, String newContext, int lookupIndex) {
        ParsedAttribute pa = AttributeParser.parse(expression, true);
        if (pa.isExpression()) {
            return pa.changeContext(oldContext, newContext, lookupIndex);
        }
        IllegalContextArgumentException ica = new IllegalContextArgumentException("Can not change the context of an expression that is not atomic");
        ica.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_changeContextError"));
        throw ica;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface AttrTerm {
        public static final int UNKNOWN = -1;
        public static final int LITERAL = 0;
        public static final int EXPR = 1;

        public int getType();
    }

    static class ExprTerm
    extends Expression
    implements AttrTerm {
        private String val = null;
        private ScriptParser.ParsedExpression parsed = null;
        private boolean strictParsing = false;
        private String origExpression = null;

        protected ExprTerm(String val, boolean strictParsing) {
            this.val = val;
            if (strictParsing) {
                this.parsed = ScriptParser.parse(val);
                this.strictParsing = true;
            }
            this.origExpression = val;
        }

        public String toString() {
            return this.val;
        }

        String getOriginalExpression() {
            return this.origExpression;
        }

        String getExpression() {
            if (this.strictParsing) {
                return this.parsed.getExpression();
            }
            return this.val;
        }

        public String getContext() {
            if (this.strictParsing) {
                return this.parsed.getContext();
            }
            StrictParsingException sp = new StrictParsingException("Can not request the context of an expression that has not been strictly parsed.");
            sp.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_contextStrictParsingException"));
            throw sp;
        }

        Object getLeafIdentifier() {
            if (!this.strictParsing) {
                return null;
            }
            List ids = this.getParsedIdentifiers();
            ScriptParser.Identifier leaf = (ScriptParser.Identifier)ids.get(ids.size() - 1);
            if (leaf.type == 2) {
                return new Integer(leaf.id);
            }
            return new String(leaf.id);
        }

        ExprTerm getBranchExpression() {
            if (!this.strictParsing) {
                return null;
            }
            String branchExpr = this.parsed.getBranchExpression();
            return AttributeParser.createExprTermStrict(branchExpr);
        }

        List getParsedIdentifiers() {
            if (this.strictParsing) {
                return this.parsed.getIdentifiers();
            }
            StrictParsingException sp = new StrictParsingException("Can not get identifiers from an expression that was not strictly parsed.");
            sp.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_identifierStrictParsingException"));
            throw sp;
        }

        boolean isXMLExpression() {
            if (this.strictParsing) {
                return this.parsed.isXMLExpression();
            }
            StrictParsingException sp = new StrictParsingException("Can not ask about XML expression state from an expression that was not strictly parsed.");
            sp.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_xmlStrictParsingException"));
            throw sp;
        }

        boolean isStrict() {
            return this.strictParsing;
        }

        ExprTerm changeContext(String newContext) {
            if (!this.strictParsing) {
                StrictParsingException sp = new StrictParsingException("Can not change the context of an expression that was not strictly parsed");
                sp.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_changeContextError"));
                throw sp;
            }
            String newExpr = this.parsed.changeContext(newContext);
            return AttributeParser.createExprTermStrict(newExpr);
        }

        public int getType() {
            return 1;
        }
    }

    static class LiteralTerm
    implements AttrTerm {
        private String val = null;

        protected LiteralTerm(String val) {
            this.val = val;
        }

        public String toString() {
            return this.val;
        }

        public int getType() {
            return 0;
        }
    }

    static class ParsedAttribute {
        private String expression = null;
        private List terms = null;
        private boolean isAtomic = false;
        private boolean containsExpression = false;
        private boolean sealed = false;
        private ExprTerm atomic = null;

        public ParsedAttribute(String expression) {
            this.expression = expression;
        }

        public void seal() {
            this.sealed = true;
            if (this.terms == null) {
                return;
            }
            int i = 0;
            while (i < this.terms.size()) {
                String lit;
                AttrTerm t = (AttrTerm)this.terms.get(i);
                if (t.getType() == 1) {
                    if (this.terms.size() == 1) {
                        this.atomic = (ExprTerm)t;
                        this.isAtomic = true;
                    }
                    this.containsExpression = true;
                } else if (t.getType() == 0 && (lit = t.toString()) != null && lit.indexOf("{") > -1) {
                    this.containsExpression = true;
                }
                ++i;
            }
        }

        public String getExpression() {
            return this.expression;
        }

        public void addTerm(AttrTerm term) {
            if (this.sealed) {
                ScriptParsingException spe = new ScriptParsingException("Attempting to add terms to an already parsed and sealed ParsedAttribute.");
                spe.setLocalizedMessage("XScript_AttributeParser_cantAddTerm");
                throw spe;
            }
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.add(term);
        }

        public List getTerms() {
            return this.terms;
        }

        public boolean isExpression() {
            return this.isAtomic;
        }

        public boolean containsExpression() {
            return this.containsExpression;
        }

        public String qualify(String newContext) {
            return newContext + "." + this.expression;
        }

        public ExprTerm getAtomicExpressionTerm() {
            return this.atomic;
        }

        public String getAtomicExpressionString() {
            return this.atomic.toString();
        }

        protected String changeContext(String oldContext, String newContext, int lookupIndex) {
            ParsedAttribute pa = AttributeParser.parse(newContext, true);
            if (pa.isExpression()) {
                newContext = pa.getAtomicExpressionString();
            }
            ExprTerm term = this.getAtomicExpressionTerm();
            String newExpr = term.getOriginalExpression();
            if (debug.ON) {
                debug.out("oldContext: " + oldContext + " newContext: " + newContext + " expr: " + newExpr);
            }
            if (newExpr.startsWith(oldContext)) {
                if (lookupIndex > Short.MAX_VALUE) {
                    ContextChangeException cce = new ContextChangeException("Can not create an indexed expression with an array index greater than the Java limit.  The resulting expression may be used to update the array.  Array index: " + lookupIndex + "\" and expression \"" + this.expression + "\".");
                    cce.setLocalizedMessage(Bundle.getErrorString((String)"XScript_AttributeParser_arrayOutOfBounds", (Object[])new Object[]{new Integer(lookupIndex), this.expression}));
                    throw cce;
                }
                newContext = newContext + "[" + lookupIndex + "]";
                newExpr = newExpr.replaceFirst(oldContext, newContext);
            }
            if (debug.ON) {
                String parsed = AttributeParser.createExpression(newExpr);
                debug.out("parsed: " + parsed);
                debug.out("newExpr: " + newExpr);
            }
            return "{" + newExpr + "}";
        }
    }
}

