/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.debug;

import com.bea.wlw.netui.util.debug.StackTrace;
import com.bea.wlw.netui.util.debug.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public final class DebugUtil {
    private static final Properties debugProps;
    private static final String DEBUG_PROPS_FILE = "debug.properties";
    private static final PrintStream out;

    public static void out(String message) {
        out.print(DebugUtil.formatOut_(message, 1) + "\n");
    }

    public static void out(Object obj) {
        out.print(DebugUtil.formatOut_(StringUtils.toString(obj), 1) + "\n");
    }

    public static void out(String message, Object obj) {
        out.print(DebugUtil.formatOut_(message + " " + StringUtils.toString(obj), 1) + "\n");
    }

    public static void out(Throwable throwable) {
        out.print(DebugUtil.formatOut_(throwable.getMessage() + " ", 2));
        throwable.printStackTrace(out);
        out.print("\n");
    }

    public static void out(String message, Throwable throwable) {
        out.print(DebugUtil.formatOut_(message + " ", 1));
        throwable.printStackTrace(out);
        out.print("\n");
    }

    static String formatOut_(String message, int stackLevel) {
        try {
            return new StackTrace().location(stackLevel).tag() + message;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "[ stack not " + stackLevel + " deep]: " + message;
        }
    }

    public static void here() {
        out.print(DebugUtil.formatHere_(1) + "\n");
    }

    static String formatHere_(int stackLevel) {
        return "*** " + new StackTrace().location(stackLevel).here() + " ***";
    }

    static String getProperty(String name) {
        try {
            return debugProps.getProperty(name);
        }
        catch (SecurityException ignore) {
            return null;
        }
    }

    static boolean getPropertyAsBoolean(String name, boolean def) {
        String prop = DebugUtil.getProperty(name);
        if (prop == null) {
            return def;
        }
        if (prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("yes") || prop.equalsIgnoreCase("on") || prop.equalsIgnoreCase("1")) {
            return true;
        }
        if (prop.equalsIgnoreCase("false") || prop.equalsIgnoreCase("no") || prop.equalsIgnoreCase("off") || prop.equalsIgnoreCase("0")) {
            return false;
        }
        return def;
    }

    private DebugUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static {
        block16: {
            DebugUtil.debugProps = new Properties();
            DebugUtil.out = System.err;
            in = null;
            try {
                in = new FileInputStream("debug.properties");
                DebugUtil.debugProps.load(in);
                var4_1 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var3_10) {
                var4_2 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                throw var3_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (IOException ignore) {
                    try {
                        in = new FileInputStream(System.getProperty("user.home") + File.separatorChar + "debug.properties");
                        DebugUtil.debugProps.load(in);
                    }
                    catch (IOException keepOnIgnoring) {
                    }
                    var4_1 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
        }
        try {
            enum = System.getProperties().propertyNames();
            while (enum.hasMoreElements()) {
                key = (String)enum.nextElement();
                if (!key.startsWith("debug.")) continue;
                DebugUtil.debugProps.put(key.substring(6), System.getProperty(key));
            }
        }
        catch (Exception e) {}
    }
}

