/*
 * Decompiled with CFR 0.152.
 */
package jbarcodebean;

import Acme.jpm.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.border.Border;
import jbarcodebean.BarcodeException;
import jbarcodebean.BarcodeStrategy;
import jbarcodebean.Code39;
import jbarcodebean.EncodedBarcode;

public class JBarcodeBean
extends JComponent
implements Serializable,
Accessible {
    private static final String SHOW_TEXT_CHANGED_PROPERTY = "showText";
    private static final String CODE_CHANGED_PROPERTY = "code";
    private static final String CODE_TYPE_CHANGED_PROPERTY = "codeType";
    private static final String CHECK_DIGIT_CHANGED_PROPERTY = "checkDigit";
    private static final String NARROWEST_BAR_WIDTH_CHANGED_PROPERTY = "narrowestBarWidth";
    private static final String BARCODE_HEIGHT_CHANGED_PROPERTY = "barcodeHeight";
    private static final String BARCODE_BACKGROUND_CHANGED_PROPERTY = "barcodeBackground";
    private static final String ANGLE_DEGREES_CHANGED_PROPERTY = "angleDegrees";
    private String code;
    private BarcodeStrategy codeType;
    private boolean checkDigit = false;
    private EncodedBarcode encoded = null;
    private int narrowestBarWidth = 1;
    private int barcodeHeight = 40;
    private Color barcodeBackground = Color.white;
    private boolean showText;
    private Dimension minimumSize;
    private Dimension preferredSize;
    private double angleDegrees;
    private int labelHeight;
    private int labelWidth;
    private int barcodeWidth;
    private String encodeError = "";

    public JBarcodeBean(String string, BarcodeStrategy barcodeStrategy) {
        this.setForeground(Color.black);
        this.setFont(new Font("Monospaced", 0, 12));
        this.code = string;
        this.codeType = barcodeStrategy;
        if (barcodeStrategy.requiresChecksum() == 1) {
            this.checkDigit = true;
        } else if (barcodeStrategy.requiresChecksum() == 0) {
            this.checkDigit = false;
        }
        this.setDoubleBuffered(false);
        this.encode();
        this.recalculateSizes();
        this.repaint();
    }

    public JBarcodeBean() {
        this("1234", new Code39());
    }

    public double getAngleDegrees() {
        return this.angleDegrees;
    }

    public void setAngleDegrees(double d) {
        double d2 = this.angleDegrees;
        this.angleDegrees = d;
        this.firePropertyChange(ANGLE_DEGREES_CHANGED_PROPERTY, d2, d);
        this.recalculateSizes();
        this.repaint();
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean bl) {
        boolean bl2 = this.showText;
        this.showText = bl;
        this.firePropertyChange(SHOW_TEXT_CHANGED_PROPERTY, bl2, bl);
        this.recalculateSizes();
        this.repaint();
    }

    public boolean isOpaque() {
        return true;
    }

    public Color getForeground() {
        return super.getForeground();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public Color getBarcodeBackground() {
        return this.barcodeBackground;
    }

    public void setBarcodeBackground(Color color) {
        Color color2 = this.barcodeBackground;
        this.barcodeBackground = color;
        this.firePropertyChange(BARCODE_BACKGROUND_CHANGED_PROPERTY, color2, color);
        this.repaint();
    }

    public Border getBorder() {
        return super.getBorder();
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.recalculateSizes();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension;
        this.firePropertyChange("preferredSize", dimension2, dimension);
    }

    public Dimension preferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minimumSize;
        this.minimumSize = dimension;
        this.firePropertyChange("minimumSize", dimension2, dimension);
    }

    public Dimension minimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Font getFont() {
        return super.getFont();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.recalculateSizes();
        this.repaint();
    }

    public int getBarcodeHeight() {
        return this.barcodeHeight;
    }

    public void setBarcodeHeight(int n) {
        int n2 = this.barcodeHeight;
        this.barcodeHeight = n;
        this.firePropertyChange(BARCODE_HEIGHT_CHANGED_PROPERTY, n2, n);
        this.recalculateSizes();
        this.repaint();
    }

    public int getNarrowestBarWidth() {
        return this.narrowestBarWidth;
    }

    public void setNarrowestBarWidth(int n) {
        int n2 = this.narrowestBarWidth;
        this.narrowestBarWidth = n;
        this.firePropertyChange(NARROWEST_BAR_WIDTH_CHANGED_PROPERTY, n2, n);
        this.recalculateSizes();
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected String paramString() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        String string2 = this.code;
        this.code = string;
        this.firePropertyChange(CODE_CHANGED_PROPERTY, string2, string);
        this.encode();
        this.recalculateSizes();
        this.repaint();
    }

    public BarcodeStrategy getCodeType() {
        return this.codeType;
    }

    public void setCodeType(BarcodeStrategy barcodeStrategy) {
        BarcodeStrategy barcodeStrategy2 = this.codeType;
        this.codeType = barcodeStrategy;
        this.firePropertyChange(CODE_TYPE_CHANGED_PROPERTY, barcodeStrategy2, barcodeStrategy);
        if (barcodeStrategy != null && barcodeStrategy.requiresChecksum() == 1 && !this.checkDigit) {
            try {
                this.setCheckDigit(true);
            }
            catch (BarcodeException barcodeException) {}
        } else if (barcodeStrategy != null && barcodeStrategy.requiresChecksum() == 0 && this.checkDigit) {
            try {
                this.setCheckDigit(false);
            }
            catch (BarcodeException barcodeException) {}
        } else {
            this.encode();
            this.recalculateSizes();
            this.repaint();
        }
    }

    public boolean isCheckDigit() {
        return this.checkDigit;
    }

    public void setCheckDigit(boolean bl) throws BarcodeException {
        if (this.codeType != null) {
            if (this.codeType.requiresChecksum() == 1 && !bl) {
                throw new BarcodeException("Checksum mandatory");
            }
            if (this.codeType.requiresChecksum() == 0 && bl) {
                throw new BarcodeException("No checksum");
            }
        }
        boolean bl2 = this.checkDigit;
        this.checkDigit = bl;
        this.firePropertyChange(CHECK_DIGIT_CHANGED_PROPERTY, bl2, bl);
        this.encode();
        this.recalculateSizes();
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        this.doPaint(graphics, this.getSize(), this.getInsets());
    }

    private void doPaint(Graphics graphics, Dimension dimension, Insets insets) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setClip(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        graphics2D.rotate(this.angleDegrees / 180.0 * Math.PI, (double)dimension.width / 2.0, (double)dimension.height / 2.0);
        int n = (dimension.height - (this.barcodeHeight + this.labelHeight)) / 2;
        if (this.encoded != null) {
            int n2 = (dimension.width - this.barcodeWidth) / 2;
            for (int i = 0; i < this.encoded.elements.length; ++i) {
                if (this.encoded.elements[i].bar) {
                    graphics2D.setColor(this.getForeground());
                } else {
                    graphics2D.setColor(this.barcodeBackground);
                }
                int n3 = this.encoded.elements[i].width * this.narrowestBarWidth;
                graphics2D.fillRect(n2, n, n3, this.barcodeHeight);
                n2 += n3;
            }
            if (this.showText) {
                graphics2D.setFont(this.getFont());
                graphics2D.setColor(this.getForeground());
                FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
                graphics2D.drawString(this.encoded.barcodeLabelText, (dimension.width - this.labelWidth) / 2, n + this.barcodeHeight + fontMetrics.getAscent());
            }
        } else if (!this.encodeError.equals("")) {
            graphics2D.setFont(new Font("Monospaced", 0, 10));
            FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
            int n4 = fontMetrics.stringWidth(this.encodeError);
            graphics2D.setColor(this.getBarcodeBackground());
            graphics2D.fillRect((dimension.width - n4) / 2, n, n4, fontMetrics.getHeight());
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(this.encodeError, (dimension.width - n4) / 2, n + fontMetrics.getAscent());
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.setColor(color);
        graphics2D.setFont(font);
    }

    private void recalculateSizes() {
        Serializable serializable;
        if (this.showText) {
            serializable = this.getFontMetrics(this.getFont());
            this.labelHeight = serializable.getAscent() + serializable.getDescent();
        } else {
            this.labelHeight = 0;
        }
        serializable = this.calculateControlSize(this.getRequiredWidth(), this.barcodeHeight + this.labelHeight);
        this.setPreferredSize((Dimension)serializable);
        this.setMinimumSize((Dimension)serializable);
        this.revalidate();
    }

    private Dimension calculateControlSize(int n, int n2) {
        Insets insets = this.getInsets();
        Dimension dimension = new Dimension();
        double d = this.angleDegrees / 180.0 * Math.PI;
        dimension.height = (int)(Math.abs((double)n * Math.sin(d)) + Math.abs((double)n2 * Math.cos(d))) + insets.top + insets.bottom;
        dimension.width = (int)(Math.abs((double)n * Math.cos(d)) + Math.abs((double)n2 * Math.sin(d))) + insets.left + insets.right;
        return dimension;
    }

    private int getRequiredWidth() {
        FontMetrics fontMetrics;
        this.barcodeWidth = 0;
        this.labelWidth = 0;
        if (this.encoded != null) {
            fontMetrics = this.getFontMetrics(this.getFont());
            this.labelWidth = fontMetrics.stringWidth(this.encoded.barcodeLabelText);
            for (int i = 0; i < this.encoded.elements.length; ++i) {
                this.barcodeWidth += this.encoded.elements[i].width * this.narrowestBarWidth;
            }
        } else if (!this.encodeError.equals("")) {
            fontMetrics = this.getFontMetrics(this.getFont());
            this.labelWidth = fontMetrics.stringWidth(this.encodeError);
        }
        int n = this.barcodeWidth > this.labelWidth ? this.barcodeWidth : this.labelWidth;
        return n;
    }

    private void encode() {
        this.encodeError = "";
        if (this.codeType != null && !this.code.equals("")) {
            try {
                this.encoded = this.codeType.encode(this.code, this.checkDigit);
            }
            catch (BarcodeException barcodeException) {
                this.encoded = null;
                this.encodeError = barcodeException.getMessage();
            }
        } else {
            this.encoded = null;
        }
    }

    public AccessibleContext getAccessibleContext() {
        return new JComponent.AccessibleJComponent(){

            public String getAccessibleName() {
                return "barcode " + JBarcodeBean.this.code;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }
        };
    }

    public void gifEncode(OutputStream outputStream) throws IOException {
        this.encode();
        this.recalculateSizes();
        Color color = this.getBackground();
        this.setBackground(this.barcodeBackground);
        BufferedImage bufferedImage = (BufferedImage)this.createImage(this.preferredSize.width, this.preferredSize.height);
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(this.preferredSize.width, this.preferredSize.height, 1);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.doPaint(graphics2D, new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()), new Insets(0, 0, 0, 0));
        this.setBackground(color);
        GifEncoder gifEncoder = new GifEncoder(bufferedImage, outputStream);
        gifEncoder.encode();
    }
}

