/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import com.bea.wlw.netui.tags.html.FormatTag;
import com.bea.wlw.netui.tags.html.Formattable;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import weblogic.utils.UnsyncStringBuffer;

public class FormatString
extends FormatTag {
    protected boolean truncate = false;

    public boolean getTruncate() {
        return this.truncate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public int doStartTag() throws JspException {
        if (this.hasErrors()) {
            this.reportErrors();
            this.localRelease();
            return 6;
        }
        Tag parentTag = this.getParent();
        if (parentTag instanceof Formattable) {
            StringFormatter formatter = new StringFormatter();
            formatter.setPattern(this.patternValue);
            formatter.setTruncate(this.truncate);
            Formattable parent = (Formattable)parentTag;
            parent.addFormatter(formatter);
        }
        this.localRelease();
        return 0;
    }

    protected void localRelease() {
        super.localRelease();
        this.truncate = false;
    }

    public String getTagName() {
        return "FormatString";
    }

    public static class StringFormatter
    extends FormatTag.Formatter {
        private boolean truncate;

        public boolean getTruncate() {
            return this.truncate;
        }

        public void setTruncate(boolean truncate) {
            this.truncate = truncate;
        }

        public String format(Object dataToFormat) throws JspException {
            if (dataToFormat == null) {
                return null;
            }
            UnsyncStringBuffer formattedString = new UnsyncStringBuffer(32);
            int index = 0;
            int patternIndex = 0;
            String unformattedString = dataToFormat.toString();
            int length = unformattedString.length();
            int patternLength = this.getPattern().length();
            int ignoreNumbers = 0;
            index = 0;
            while (index < length) {
                if (patternIndex < patternLength) {
                    boolean loop = true;
                    while (loop) {
                        char thisChar = this.getPattern().charAt(patternIndex);
                        if (thisChar == '#') break;
                        if (thisChar == '*') {
                            ++ignoreNumbers;
                            break;
                        }
                        if (thisChar == '$') {
                            if (patternIndex + 1 < patternLength && this.getPattern().charAt(patternIndex + 1) == '$') {
                                ++patternIndex;
                            } else if (patternIndex + 1 < patternLength && this.getPattern().charAt(patternIndex + 1) == '#') {
                                ++patternIndex;
                            } else if (patternIndex + 1 < patternLength && this.getPattern().charAt(patternIndex + 1) == '*') {
                                ++patternIndex;
                            }
                        }
                        formattedString = formattedString.append(this.getPattern().charAt(patternIndex));
                        if (++patternIndex < patternLength) continue;
                        loop = false;
                    }
                }
                if (patternIndex >= patternLength && this.truncate) break;
                if (ignoreNumbers == 1) {
                    formattedString.append(unformattedString.substring(index));
                    ++ignoreNumbers;
                } else if (ignoreNumbers <= 1) {
                    formattedString.append(unformattedString.charAt(index));
                }
                ++patternIndex;
                ++index;
            }
            if (patternIndex < patternLength) {
                while (patternIndex < patternLength) {
                    char patternChar = this.getPattern().charAt(patternIndex);
                    if (patternChar == '#') {
                        formattedString.append(" ");
                    } else {
                        formattedString.append(patternChar);
                    }
                    ++patternIndex;
                }
            }
            return formattedString.toString();
        }
    }
}

