/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.scoping;

import com.bea.wlw.netui.pageflow.scoping.ScopedRequest;
import com.bea.wlw.netui.pageflow.scoping.ScopedResponse;
import com.bea.wlw.netui.pageflow.scoping.ScopedServletContext;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedRequestImpl;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedResponseImpl;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedServletContextImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ScopedServletUtils {
    public static final String SCOPE_ID_PARAM = "jpfScopeID";
    private static final String OVERRIDE_REQUEST_ATTR;
    private static final String OVERRIDE_RESPONSE_ATTR;
    private static final String OVERRIDE_CONTEXT_ATTR;
    private static final String ORIGINAL_URI_ATTR;
    private static final String DECODED_URI_ATTR;
    private static final Logger logger;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ScopedRequest getScopedRequest(HttpServletRequest realRequest, String overrideURI, ServletContext servletContext, Object scopeKey) {
        if (!$assertionsDisabled && realRequest instanceof ScopedRequest) {
            throw new AssertionError();
        }
        String requestAttr = ScopedServletUtils.getScopedName(OVERRIDE_REQUEST_ATTR, scopeKey);
        ScopedRequest scopedRequest = (ScopedRequest)realRequest.getAttribute(requestAttr);
        if (scopedRequest == null) {
            if (overrideURI != null && !overrideURI.startsWith("/")) {
                overrideURI = "/" + overrideURI;
            }
            scopedRequest = new ScopedRequestImpl(realRequest, overrideURI, scopeKey, servletContext);
            realRequest.setAttribute(requestAttr, (Object)scopedRequest);
        }
        return scopedRequest;
    }

    public static ScopedResponse getScopedResponse(HttpServletResponse realResponse, ScopedRequest scopedRequest) {
        if (!$assertionsDisabled && realResponse instanceof ScopedResponse) {
            throw new AssertionError();
        }
        String responseAttr = ScopedServletUtils.getScopedName(OVERRIDE_RESPONSE_ATTR, scopedRequest.getScopeKey());
        HttpServletRequest outerRequest = scopedRequest.getOuterRequest();
        ScopedResponse scopedResponse = (ScopedResponse)outerRequest.getAttribute(responseAttr);
        if (scopedResponse == null) {
            scopedResponse = new ScopedResponseImpl(realResponse);
            outerRequest.setAttribute(responseAttr, (Object)scopedResponse);
        }
        return scopedResponse;
    }

    public static ScopedServletContext getScopedServletContext(HttpServletRequest realRequest, ServletContext realServletContext, Object scopeKey) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"not using this for now -- will use it with scoped Struts");
        }
        if (!$assertionsDisabled && realServletContext instanceof ScopedServletContext) {
            throw new AssertionError();
        }
        String cxtAttr = ScopedServletUtils.getScopedName(OVERRIDE_CONTEXT_ATTR, scopeKey);
        ScopedServletContext scopedCxt = (ScopedServletContext)realRequest.getAttribute(cxtAttr);
        if (scopedCxt == null) {
            scopedCxt = new ScopedServletContextImpl(realServletContext, scopeKey);
            realRequest.setAttribute(cxtAttr, (Object)scopedCxt);
        }
        return scopedCxt;
    }

    public static void renameScope(Object oldScopeKey, Object newScopeKey, HttpServletRequest request) {
        if (!$assertionsDisabled && request instanceof ScopedRequest) {
            throw new AssertionError();
        }
        String cxtAttr = ScopedServletUtils.getScopedName(OVERRIDE_CONTEXT_ATTR, oldScopeKey);
        String requestAttr = ScopedServletUtils.getScopedName(OVERRIDE_REQUEST_ATTR, oldScopeKey);
        String responseAttr = ScopedServletUtils.getScopedName(OVERRIDE_RESPONSE_ATTR, oldScopeKey);
        ScopedServletContextImpl scopedCxt = (ScopedServletContextImpl)request.getAttribute(cxtAttr);
        ScopedRequest scopedRequest = (ScopedRequest)request.getAttribute(requestAttr);
        ScopedResponse scopedResponse = (ScopedResponse)request.getAttribute(responseAttr);
        if (scopedCxt != null) {
            scopedCxt.renameScope(newScopeKey);
            request.removeAttribute(cxtAttr);
            cxtAttr = ScopedServletUtils.getScopedName(OVERRIDE_CONTEXT_ATTR, newScopeKey);
            request.setAttribute(cxtAttr, (Object)scopedCxt);
        }
        if (scopedRequest != null) {
            scopedRequest.renameScope(newScopeKey);
            request.removeAttribute(requestAttr);
            requestAttr = ScopedServletUtils.getScopedName(OVERRIDE_REQUEST_ATTR, newScopeKey);
            request.setAttribute(requestAttr, (Object)scopedRequest);
        } else {
            ScopedRequestImpl.renameSessionScope(oldScopeKey, newScopeKey, request);
        }
        if (scopedResponse != null) {
            request.removeAttribute(responseAttr);
            responseAttr = ScopedServletUtils.getScopedName(OVERRIDE_RESPONSE_ATTR, newScopeKey);
            request.setAttribute(responseAttr, (Object)scopedResponse);
        }
    }

    public static String getScopedName(String baseName, Object scopeKey) {
        return scopeKey + baseName;
    }

    public static HttpServletRequest getOuterRequest(HttpServletRequest request) {
        ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)request);
        return scopedRequest != null ? scopedRequest.getOuterRequest() : request;
    }

    public static ScopedRequest unwrapRequest(ServletRequest request) {
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof ScopedRequest) {
                return (ScopedRequest)request;
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public static ScopedResponse unwrapResponse(ServletResponse response) {
        while (response instanceof ServletResponseWrapper) {
            if (response instanceof ScopedResponse) {
                return (ScopedResponse)response;
            }
            response = ((ServletResponseWrapper)response).getResponse();
        }
        return null;
    }

    public static String getScopedSessionAttrName(String attrName, HttpServletRequest request) {
        String requestScopeParam = request.getParameter(SCOPE_ID_PARAM);
        if (requestScopeParam != null) {
            return ScopedServletUtils.getScopedName(attrName, requestScopeParam);
        }
        ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)request);
        return scopedRequest != null ? scopedRequest.getScopedName(attrName) : attrName;
    }

    public static Object getScopedSessionAttr(String attrName, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return session.getAttribute(ScopedServletUtils.getScopedSessionAttrName(attrName, request));
        }
        return null;
    }

    public static void setScopedSessionAttr(String attrName, Object val, HttpServletRequest request) {
        request.getSession().setAttribute(ScopedServletUtils.getScopedSessionAttrName(attrName, request), val);
    }

    public static void removeScopedSessionAttr(String attrName, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(ScopedServletUtils.getScopedSessionAttrName(attrName, request));
        }
    }

    public static final String getRelativeURI(HttpServletRequest request) {
        return ScopedServletUtils.getRelativeURI(request, ScopedServletUtils.decodeURI(request));
    }

    public static final String getRelativeURI(HttpServletRequest request, String uri) {
        String requestUrl = uri;
        String contextPath = request.getContextPath();
        int overlap = requestUrl.indexOf(contextPath);
        if (overlap != -1) {
            return requestUrl.substring(overlap + contextPath.length());
        }
        return requestUrl;
    }

    public static String normalizeURI(String uri) {
        block2: {
            if (uri.indexOf("./") == -1) break block2;
            try {
                uri = new URI(uri).normalize().toString();
            }
            catch (URISyntaxException e) {
                logger.error((Object)("Could not parse relative URI " + uri));
            }
        }
        return uri;
    }

    public static String decodeURI(HttpServletRequest request) {
        String decodedURI;
        String requestURI = request.getRequestURI();
        String originalURI = (String)request.getAttribute(ORIGINAL_URI_ATTR);
        if (originalURI != null && originalURI.equals(requestURI) && (decodedURI = (String)request.getAttribute(DECODED_URI_ATTR)) != null) {
            return decodedURI;
        }
        String encoding = request.getCharacterEncoding();
        try {
            if (encoding == null) {
                encoding = "utf-8";
            }
            decodedURI = URLDecoder.decode(requestURI, encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("unsupported encoding " + encoding + " in request " + requestURI), (Throwable)e);
            decodedURI = request.getRequestURI();
        }
        decodedURI = ScopedServletUtils.normalizeURI(decodedURI);
        request.setAttribute(ORIGINAL_URI_ATTR, (Object)requestURI);
        request.setAttribute(DECODED_URI_ATTR, (Object)decodedURI);
        return decodedURI;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils = ScopedServletUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils).desiredAssertionStatus();
        OVERRIDE_REQUEST_ATTR = (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils = ScopedServletUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils).getName() + "_overrideRequest";
        OVERRIDE_RESPONSE_ATTR = (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils = ScopedServletUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils).getName() + "_overrideResponse";
        OVERRIDE_CONTEXT_ATTR = (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils = ScopedServletUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils).getName() + "_overrideContext";
        ORIGINAL_URI_ATTR = (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils = ScopedServletUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils).getName() + "_originalURI";
        DECODED_URI_ATTR = (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils = ScopedServletUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils).getName() + "_decodedURI";
        logger = Logger.getLogger((Class)(class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils = ScopedServletUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedServletUtils));
    }
}

