/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.databinding.grid.datacontext;

import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContext;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.NoSuchDataException;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.exception.LocalizedIllegalArgumentException;
import com.bea.wlw.netui.util.exception.LocalizedIllegalStateException;
import com.bea.wlw.netui.util.iterator.IteratorFactory;
import com.bea.wlw.netui.util.iterator.IteratorFactoryException;
import com.bea.wlw.netui.util.logging.Logger;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.sql.RowSet;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.WLCachedRowSet;

public final class RowSetDataContext
extends DataContext {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$grid$datacontext$RowSetDataContext == null ? (class$com$bea$wlw$netui$tags$databinding$grid$datacontext$RowSetDataContext = RowSetDataContext.class$("com.bea.wlw.netui.tags.databinding.grid.datacontext.RowSetDataContext")) : class$com$bea$wlw$netui$tags$databinding$grid$datacontext$RowSetDataContext));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$grid$datacontext$RowSetDataContext == null ? (class$com$bea$wlw$netui$tags$databinding$grid$datacontext$RowSetDataContext = RowSetDataContext.class$("com.bea.wlw.netui.tags.databinding.grid.datacontext.RowSetDataContext")) : class$com$bea$wlw$netui$tags$databinding$grid$datacontext$RowSetDataContext));
    private WLCachedRowSet rowset = null;
    private ResultSetMetaData rsmd = null;
    private Iterator iterator = null;
    private Object currentItem = null;
    private int currentIndex = -1;
    private int iterationStart = 0;
    private int iterationEnd = 0;
    private boolean useIterationRange = false;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$databinding$grid$datacontext$RowSetDataContext;

    RowSetDataContext(RowSet rowset) {
        if (rowset == null) {
            LocalizedIllegalArgumentException iae = new LocalizedIllegalArgumentException("A RowSetDataContext can not be constructed with a null RowSet.");
            iae.setLocalizedMessage(Bundle.getErrorString((String)"RowSetDataContext_nullRowSet"));
            throw iae;
        }
        this.rowset = (WLCachedRowSet)rowset;
    }

    public int getColumnType(int columnIndex) {
        ResultSetMetaData rsmd = this.initRSMD();
        int ret = -1;
        try {
            ret = rsmd.getColumnType(columnIndex);
        }
        catch (SQLException ignore) {}
        return ret;
    }

    public int getColumnType(String columnName) {
        return this.getColumnType(this.mapNameToIndex(columnName));
    }

    public String getColumnName(int columnIndex) {
        this.rsmd = this.initRSMD();
        String ret = null;
        try {
            ret = this.rsmd.getColumnName(columnIndex);
        }
        catch (SQLException ignore) {}
        return ret;
    }

    public Object getColumnValue(int index) {
        if (RowSetDataContext.debug.ON) {
            debug.here();
            debug.out("currentItem type: " + (this.getCurrentItem() == null ? "null" : this.getCurrentItem().getClass().getName()));
            debug.out("currentItem: " + this.getCurrentItem());
            debug.out("index: " + index);
            debug.out("columnName: " + this.getColumnName(index));
            debug.out("currentIndex: " + this.getCurrentIndex());
            debug.out("containsKey: " + ((Map)this.getCurrentItem()).containsKey(this.getColumnName(index)));
            debug.out("data: " + ((Map)this.getCurrentItem()).get(this.getColumnName(index)));
        }
        String columnName = this.getColumnName(index);
        return this.getColumnValue(columnName);
    }

    public Object getColumnValue(String columnName) {
        Map row = (Map)this.getCurrentItem();
        if (row == null) {
            throw new NoSuchDataException("There is no current row in the RowSet dataset");
        }
        boolean found = false;
        try {
            ResultSetMetaData rsmd = this.initRSMD();
            int count = rsmd.getColumnCount();
            int i = 1;
            while (i <= count) {
                String tmp = rsmd.getColumnName(i);
                if (tmp.equalsIgnoreCase(columnName)) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        if (!found) {
            throw new NoSuchDataException("There is no field named \"" + columnName + "\" in the current row.");
        }
        Object o = row.get(columnName);
        if (o instanceof Clob) {
            Clob c = (Clob)o;
            try {
                o = c.getSubString(0L, (int)c.length());
            }
            catch (SQLException sql) {
                logger.warn((Object)"An exception occurred retrieving the String value from a java.sql.Clob object.", (Throwable)sql);
                o = null;
            }
            if (RowSetDataContext.debug.ON) {
                debug.out("***** CLOB found a clob for the column value; return value " + o);
            }
        }
        return o;
    }

    public Object getCurrentItem() {
        return this.currentItem;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getColumnCount() {
        ResultSetMetaData rsmd = this.initRSMD();
        int ret = -1;
        try {
            ret = rsmd.getColumnCount();
        }
        catch (SQLException ignore) {}
        return ret;
    }

    public Object next() {
        Iterator iterator = this.initIterator();
        this.currentItem = iterator.next();
        this.currentIndex = this.currentIndex == -1 ? 0 : ++this.currentIndex;
        return this.currentItem;
    }

    public boolean hasNext() {
        Iterator iterator = this.initIterator();
        boolean hasNext = false;
        if (this.useIterationRange) {
            if (iterator.hasNext() && this.currentIndex < this.iterationEnd - 1) {
                hasNext = true;
            }
        } else {
            hasNext = iterator.hasNext();
        }
        if (RowSetDataContext.debug.ON) {
            debug.out("hasNext: " + hasNext);
        }
        return hasNext;
    }

    public Object unwrap() {
        return this.rowset;
    }

    public int size() {
        try {
            if (this.rowset != null && this.rowset.getRows() != null) {
                return this.rowset.getRows().length;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setIterationRange(int start, int end) {
        if (start < 0 || end < 1 || start >= end) {
            LocalizedIllegalArgumentException iae = new LocalizedIllegalArgumentException("The iteratiron range [" + start + ", " + end + "] is invalid.");
            iae.setLocalizedMessage(Bundle.getErrorString((String)"RowSetDataContext_illegalIterationRange", (Object[])new Object[]{new Integer(start), new Integer(end)}));
            throw iae;
        }
        this.iterationStart = start;
        this.iterationEnd = end;
        this.useIterationRange = true;
    }

    private final ResultSetMetaData initRSMD() {
        block2: {
            if (this.rsmd != null) break block2;
            try {
                this.rsmd = this.rowset.getMetaData();
            }
            catch (Exception ignore) {}
        }
        return this.rsmd;
    }

    private final Iterator initIterator() {
        if (this.iterator == null) {
            try {
                this.iterator = IteratorFactory.makeIterator((Object)this.rowset);
                if (this.iterator == null) {
                    logger.info((Object)"RowSetDataContext: The data structure from which to create an iterator is null.");
                    this.iterator = IteratorFactory.EMPTY_ITERATOR;
                }
            }
            catch (IteratorFactoryException ife) {
                logger.info((Object)ife.getMessage());
            }
            this.currentIndex = -1;
            if (this.useIterationRange) {
                if (RowSetDataContext.debug.ON) {
                    debug.out("advance to iteration item: " + this.iterationStart);
                }
                while (this.iterator.hasNext() && this.currentIndex < this.iterationStart - 1) {
                    this.next();
                }
            }
        }
        return this.iterator;
    }

    private int mapNameToIndex(String name) {
        int columnIndex = -1;
        try {
            columnIndex = this.rowset.findColumn(name);
        }
        catch (SQLException ignore) {}
        return columnIndex;
    }

    public DataContext.DataContextItemMetadata getCurrentMetadata() {
        return new RowSetItemMetadata();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RowSetItemMetadata
    extends DataContext.DataContextItemMetadata {
        public Iterator getRowIdentifiers() {
            try {
                ArrayList<DataContext.RowIdentifierItem> list = new ArrayList<DataContext.RowIdentifierItem>();
                CachedRowSetMetaData md = (CachedRowSetMetaData)RowSetDataContext.this.rowset.getMetaData();
                if (md == null) {
                    LocalizedIllegalStateException ise = new LocalizedIllegalStateException("Can not find row identifiers from a RowSet whose metadata is null");
                    ise.setLocalizedMessage(Bundle.getErrorString((String)"RowSetDataContext_nullMetadata"));
                    throw ise;
                }
                int i = 1;
                while (i <= md.getColumnCount()) {
                    if (md.isPrimaryKeyColumn(i)) {
                        DataContext.RowIdentifierItem id = new DataContext.RowIdentifierItem(md.getColumnName(i), RowSetDataContext.this.getColumnValue(i));
                        list.add(id);
                    }
                    ++i;
                }
                if (debug.ON) {
                    int i2 = 0;
                    while (i2 < list.size()) {
                        debug.out("rowId[" + i2 + "]: " + list.get(i2));
                        ++i2;
                    }
                }
                return list.iterator();
            }
            catch (Exception e) {
                logger.info((Object)("Could not determine a unique identifier for the current record \"" + RowSetDataContext.this.getCurrentItem() + "\"."), (Throwable)e);
                return null;
            }
        }
    }
}

