/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.util;

import com.bea.wlw.netui.pageflow.util.DOMUtils;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UrlTemplateDescriptor {
    private static final String DESCRIPTOR_PATH = "/WEB-INF/url-template-config.xml";
    private static final Logger logger = new Logger(class$com$bea$wlw$netui$pageflow$util$UrlTemplateDescriptor == null ? (class$com$bea$wlw$netui$pageflow$util$UrlTemplateDescriptor = UrlTemplateDescriptor.class$("com.bea.wlw.netui.pageflow.util.UrlTemplateDescriptor")) : class$com$bea$wlw$netui$pageflow$util$UrlTemplateDescriptor);
    protected static Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$pageflow$util$UrlTemplateDescriptor == null ? (class$com$bea$wlw$netui$pageflow$util$UrlTemplateDescriptor = UrlTemplateDescriptor.class$("com.bea.wlw.netui.pageflow.util.UrlTemplateDescriptor")) : class$com$bea$wlw$netui$pageflow$util$UrlTemplateDescriptor));
    private static UrlTemplateDescriptor instance = new UrlTemplateDescriptor();
    private static final String JPF_URL_TEMPLATES = "jpf-url-templates";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String URL_TEMPLATE = "url-template";
    private static final String URL_TEMPLATE_REF = "url-template-ref";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String SECURE_DEFAULT_TEMPLATE = "secure-default";
    public static final String RENDER_TEMPLATE = "render-template";
    public static final String SECURE_RENDER_TEMPLATE = "secure-render-template";
    public static final String ACTION_TEMPLATE = "action";
    public static final String SECURE_ACTION_TEMPLATE = "secure-action-template";
    public static final String RESOURCE_TEMPLATE = "resource-template";
    public static final String SECURE_RESOURCE_TEMPLATE = "secure-resource-template";
    private HashMap _urlTemplates = new HashMap();
    private HashMap _jpfTemplates = new HashMap();
    private boolean _loaded = false;
    private static String[] TEMPLATE_TOKENS = new String[]{"url:scheme", "url:domain", "url:port", "url:prefix", "url:path", "url:queryString"};
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$util$UrlTemplateDescriptor;

    protected UrlTemplateDescriptor() {
    }

    public String getUrlTemplate(String name) {
        return (String)this._urlTemplates.get(name);
    }

    public String getJPFUrlTemplateRef(String type) {
        String ref = (String)this._jpfTemplates.get(type);
        if (ref == null && (type.equals(SECURE_RENDER_TEMPLATE) || type.equals(SECURE_ACTION_TEMPLATE) || type.equals(SECURE_RESOURCE_TEMPLATE))) {
            ref = (String)this._jpfTemplates.get(SECURE_DEFAULT_TEMPLATE);
        }
        return ref;
    }

    public static UrlTemplateDescriptor getInstance() {
        return instance;
    }

    protected void load(InputStream stream) throws Exception {
        DocumentBuilderFactory dbFactory = null;
        dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        dBuilder = dbFactory.newDocumentBuilder();
        Document document = null;
        document = dBuilder.parse(stream);
        Element root = document.getDocumentElement();
        this.loadTemplates(root);
    }

    private void loadTemplates(Element parent) {
        List templates = DOMUtils.getChildElementsByName(parent, URL_TEMPLATE);
        int i = 0;
        while (i < templates.size()) {
            block7: {
                Element template = (Element)templates.get(i);
                String name = DOMUtils.getAttributeValue(template, NAME);
                String value = DOMUtils.getElementText(template);
                if (UrlTemplateDescriptor.debug.ON) {
                    debug.out("[URLTemplate] " + name + " = " + value);
                }
                try {
                    UrlTemplateDescriptor.verifyTemplate(value);
                }
                catch (IllegalArgumentException ie) {
                    if (UrlTemplateDescriptor.debug.ON) {
                        ie.printStackTrace();
                    }
                    break block7;
                }
                this._urlTemplates.put(name, value);
            }
            ++i;
        }
        Element jpfTemplatesRoot = DOMUtils.getChildElementByName(parent, JPF_URL_TEMPLATES);
        if (jpfTemplatesRoot != null) {
            List refs = DOMUtils.getChildElementsByName(jpfTemplatesRoot, URL_TEMPLATE_REF);
            int i2 = 0;
            while (i2 < refs.size()) {
                Element templateRef = (Element)refs.get(i2);
                String name = DOMUtils.getAttributeValue(templateRef, TYPE);
                String ref = DOMUtils.getAttributeValue(templateRef, NAME);
                this._jpfTemplates.put(name, ref);
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void load(ServletContext servletContext) {
        block15: {
            if (this._loaded) {
                return;
            }
            stream = null;
            try {
                block14: {
                    stream = servletContext.getResourceAsStream("/WEB-INF/url-template-config.xml");
                    if (stream != null) {
                        this.load(stream);
                        break block14;
                    }
                    UrlTemplateDescriptor.logger.warn((Object)"Could not find URL template descriptor at path /WEB-INF/url-template-config.xml");
                }
                var5_3 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var4_10) {
                var5_5 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                throw var4_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    stream.close();
                }
                catch (Exception ignore) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (Exception e) {
                    if (UrlTemplateDescriptor.debug.ON) {
                        e.printStackTrace();
                    }
                    UrlTemplateDescriptor.logger.error((Object)"Bad URL template descriptor in path /WEB-INF/url-template-config.xml");
                    e.printStackTrace();
                    var5_4 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception ignore) {}
                    }
                }
            }
        }
        this._loaded = true;
    }

    private static void verifyTemplate(String template) throws IllegalStateException {
        int i = 0;
        while (i < TEMPLATE_TOKENS.length) {
            int index = template.indexOf(TEMPLATE_TOKENS[i]);
            if (index != -1 && template.charAt(index - 1) != '{' && template.charAt(index + TEMPLATE_TOKENS[i].length()) != '}') {
                throw new IllegalStateException("Token " + TEMPLATE_TOKENS[i] + " not enclosed in {}s");
            }
            ++i;
        }
        if (template.indexOf("{url:path}") == -1) {
            throw new IllegalStateException("Required token {url:path} not present in template " + template);
        }
        if (template.indexOf("{url:queryString}") == -1) {
            throw new IllegalStateException("Required token {url:queryString} not present in template " + template);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

