/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.util;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

abstract class DOMUtils {
    DOMUtils() {
    }

    public static Element getChildElementByName(Element parent, String name) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getTagName().equals(name)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static List getChildElementsByName(Element parent, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getTagName().equals(name)) {
                elements.add(element);
            }
            ++i;
        }
        return elements;
    }

    public static String getChildElementText(Element parent, String name) {
        List list = DOMUtils.getChildElementsByName(parent, name);
        if (list.size() == 1) {
            Element child = (Element)list.get(0);
            StringBuffer buf = new StringBuffer();
            NodeList children = child.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                    Text text = (Text)node;
                    buf.append(text.getData().trim());
                }
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public static String getElementText(Element element) {
        StringBuffer buf = new StringBuffer();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                Text text = (Text)node;
                buf.append(text.getData().trim());
            }
            ++i;
        }
        return buf.toString();
    }

    public static String[] getChildElementTextArr(Element parent, String name) {
        List children = DOMUtils.getChildElementsByName(parent, name);
        String[] str = new String[children.size()];
        int i = 0;
        while (i < children.size()) {
            Node child = (Node)children.get(i);
            StringBuffer buf = new StringBuffer();
            NodeList nodes = child.getChildNodes();
            int j = 0;
            while (j < nodes.getLength()) {
                Node node = nodes.item(j);
                if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                    Text text = (Text)node;
                    buf.append(text.getData().trim());
                }
                ++j;
            }
            str[i] = buf.toString();
            ++i;
        }
        return str;
    }

    public static String getAttributeValue(Element element, String name) {
        Attr attribute = element.getAttributeNode(name);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }
}

