/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow;

import com.bea.wlw.netui.pageflow.ActionResolver;
import com.bea.wlw.netui.pageflow.ActionResult;
import com.bea.wlw.netui.pageflow.AutoRegisterActionServlet;
import com.bea.wlw.netui.pageflow.FlowControllerFactory;
import com.bea.wlw.netui.pageflow.Forward;
import com.bea.wlw.netui.pageflow.GlobalApp;
import com.bea.wlw.netui.pageflow.HttpRedirector;
import com.bea.wlw.netui.pageflow.PageFlowActionServlet;
import com.bea.wlw.netui.pageflow.PageFlowConstants;
import com.bea.wlw.netui.pageflow.PageFlowController;
import com.bea.wlw.netui.pageflow.PageFlowStack;
import com.bea.wlw.netui.pageflow.ServerAdapter;
import com.bea.wlw.netui.pageflow.internal.ActionResultImpl;
import com.bea.wlw.netui.pageflow.internal.BindingUpdateError;
import com.bea.wlw.netui.pageflow.internal.CompileErrorActionResult;
import com.bea.wlw.netui.pageflow.internal.DefaultServerAdapter;
import com.bea.wlw.netui.pageflow.scoping.ScopedRequest;
import com.bea.wlw.netui.pageflow.scoping.ScopedResponse;
import com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedRequestImpl;
import com.bea.wlw.netui.util.cache.ConcurrentReaderHashMap;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.RequestUtils;

public class PageFlowUtils
implements PageFlowConstants {
    private static final Debug debug;
    private static final Logger logger;
    private static final String JPF_STACK_ATTR;
    private static final String CURRENT_JPF_ATTR;
    private static final String GLOBALAPP_ATTR;
    private static final String ACTION_URI_ATTR;
    private static final String FORWARDED_OUTPUT_FORM_ATTR;
    private static final String PAGEINPUT_MAP_ATTR;
    private static final int JPF_EXTENSION_LEN;
    private static final String HTTP_REDIRECTOR_CLASS_PARAM = "jpf-http-redirector";
    private static final String HTTP_REDIRECTOR_ATTR;
    private static final String CATALINA_HOME_PROP = "catalina.home";
    private static final String SERVER_ADAPTER_PROP = "pageflow.serveradapter";
    private static final boolean OS_CASE_SENSITIVE;
    private static final String WL_SERVER_ADAPTER_CLASS = "com.bea.wlw.netui.pageflow.internal.WebLogicServerAdapter";
    private static final String TOMCAT_SERVER_ADAPTER_CLASS = "com.bea.wlw.netui.tomcat.TomcatServerAdapter";
    private static final String[] DEFAULT_AUTORESOLVE_EXTENSIONS;
    private static final String BINDING_UPDATE_ERRORS_ATTR;
    private static final ServerAdapter SERVER_ADAPTER;
    private static final boolean IS_WEBLOGIC_SERVER_ADAPTER;
    private static Map _formNameMaps;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$PageFlowUtils;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$internal$DefaultServerAdapter;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$scoping$ScopedResponse;

    public static String getModulePath(HttpServletRequest request, String requestURI) {
        return PageFlowUtils.getModulePathForRelativeURI(PageFlowUtils.getRelativeURI(request, requestURI, null));
    }

    public static String getModulePath(HttpServletRequest request) {
        String requestURI = PageFlowUtils.decodeURI(request);
        return PageFlowUtils.getModulePathForRelativeURI(PageFlowUtils.getRelativeURI(request, requestURI, null));
    }

    public static String getModulePathForRelativeURI(String uri) {
        if (uri.length() == 0) {
            return "/";
        }
        if (!$assertionsDisabled && uri.charAt(0) != '/') {
            throw new AssertionError((Object)uri);
        }
        int slash = uri.lastIndexOf(47);
        uri = uri.substring(0, slash);
        return uri;
    }

    public static String getPageFlowClassName(String modulePath, ServletRequest request, ServletContext context) {
        ActionConfig beginActionConfig;
        if (modulePath.equals("/-global")) {
            return "global.Global";
        }
        ModuleConfig mc = null;
        try {
            mc = PageFlowUtils.ensureModuleConfig(modulePath, request, context);
        }
        catch (Exception e) {
            logger.error((Object)("Error while registering Struts module " + modulePath), (Throwable)e);
        }
        if (mc != null && (beginActionConfig = mc.findActionConfig("/begin")) != null) {
            return beginActionConfig.getType();
        }
        if (debug.isOn()) {
            debug.out("Could not find pageflow for path " + modulePath);
        }
        logger.info((Object)("Could not find pageflow for path " + modulePath));
        return null;
    }

    public static final String getRelativeURI(HttpServletRequest request, PageFlowController relativeTo) {
        return PageFlowUtils.getRelativeURI(request, PageFlowUtils.decodeURI(request), relativeTo);
    }

    public static final String getRelativeURI(HttpServletRequest request, String uri, PageFlowController relativeTo) {
        String requestUrl;
        int overlap;
        String contextPath = request.getContextPath();
        if (relativeTo != null) {
            contextPath = contextPath + relativeTo.getModulePath();
        }
        if ((overlap = (requestUrl = uri).indexOf(contextPath)) != -1) {
            return requestUrl.substring(overlap + contextPath.length());
        }
        return requestUrl;
    }

    public static String getBeginActionURI(String requestURI) {
        StringBuffer retVal = new StringBuffer();
        int lastSlash = requestURI.lastIndexOf(47);
        if (lastSlash != -1) {
            retVal.append(requestURI.substring(0, lastSlash));
        }
        retVal.append('/').append("begin").append(".do");
        return retVal.toString();
    }

    public static final Stack getPageFlowStack(HttpServletRequest request) {
        return PageFlowUtils.getPageFlowStack(request, true);
    }

    static Stack getPageFlowStack(HttpServletRequest request, boolean createIfNotExist) {
        Stack jpfStack = (Stack)ScopedServletUtils.getScopedSessionAttr((String)JPF_STACK_ATTR, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        if (jpfStack == null && createIfNotExist) {
            jpfStack = new PageFlowStack();
            ScopedServletUtils.setScopedSessionAttr((String)JPF_STACK_ATTR, (Object)jpfStack, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        }
        return jpfStack;
    }

    static void ensurePageFlowStackFailover(HttpServletRequest request, Stack pfStack) {
        if (PageFlowUtils.isWLS()) {
            ScopedServletUtils.setScopedSessionAttr((String)JPF_STACK_ATTR, (Object)pfStack, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        }
    }

    static boolean isWLS() {
        return IS_WEBLOGIC_SERVER_ADAPTER;
    }

    public static PageFlowController getNestingPageFlow(HttpServletRequest request) {
        Stack jpfStack = (Stack)ScopedServletUtils.getScopedSessionAttr((String)JPF_STACK_ATTR, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
        if (jpfStack != null && !jpfStack.isEmpty()) {
            return (PageFlowController)jpfStack.peek();
        }
        return null;
    }

    public static final PageFlowController ensureCurrentPageFlow(HttpServletRequest request, HttpServletResponse response) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && response == null) {
            throw new AssertionError();
        }
        ServletContext servletContext = SERVER_ADAPTER.getServletContext(request);
        if (servletContext == null && debug.isOn()) {
            debug.out("could not get ServletContext from request " + request);
        }
        return PageFlowUtils.ensureCurrentPageFlow(request, response, servletContext);
    }

    public static final PageFlowController ensureCurrentPageFlow(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && response == null) {
            throw new AssertionError();
        }
        PageFlowController cur = PageFlowUtils.getCurrentPageFlow(request);
        if (cur == null || !PageFlowUtils.getModulePathForRelativeURI(cur.getURI()).equals(PageFlowUtils.getModulePath(request))) {
            cur = FlowControllerFactory.getPageFlowForRequest(request, response, context);
        }
        return cur;
    }

    public static final PageFlowController getCurrentPageFlow(HttpServletRequest request) {
        ActionResolver cur = PageFlowUtils.getCurrentActionResolver(request);
        return cur != null && cur.isPageFlow() ? (PageFlowController)cur : null;
    }

    public static ActionResolver getCurrentActionResolver(HttpServletRequest request) {
        return (ActionResolver)ScopedServletUtils.getScopedSessionAttr((String)CURRENT_JPF_ATTR, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
    }

    public static GlobalApp ensureGlobalApp(HttpServletRequest request, HttpServletResponse response) {
        return PageFlowUtils.ensureGlobalApp(request, response, SERVER_ADAPTER.getServletContext(request));
    }

    public static GlobalApp ensureGlobalApp(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && response == null) {
            throw new AssertionError();
        }
        GlobalApp cur = PageFlowUtils.getGlobalApp(request);
        if (cur != null) {
            cur.reInit(servletContext);
            return cur;
        }
        return FlowControllerFactory.getGlobalApp(request, response, servletContext);
    }

    public static GlobalApp getGlobalApp(HttpServletRequest request) {
        GlobalApp current;
        HttpSession session = request.getSession(false);
        if (session != null && (current = (GlobalApp)session.getAttribute(GLOBALAPP_ATTR)) != null) {
            return current;
        }
        return null;
    }

    static void setCurrentPageFlow(PageFlowController jpf, HttpServletRequest request) {
        PageFlowUtils.setCurrentActionResolver(jpf, request);
    }

    public static void setCurrentActionResolver(ActionResolver resolver, HttpServletRequest request) {
        ScopedServletUtils.setScopedSessionAttr((String)CURRENT_JPF_ATTR, (Object)resolver, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
    }

    static void setGlobalApp(GlobalApp ga, HttpServletRequest request) {
        request.getSession().setAttribute(GLOBALAPP_ATTR, (Object)ga);
    }

    public static void destroyPageFlowStack(HttpServletRequest request) {
        ScopedServletUtils.removeScopedSessionAttr((String)JPF_STACK_ATTR, (HttpServletRequest)PageFlowUtils.unwrapMultipart(request));
    }

    public static void dumpRequest(HttpServletRequest request, PrintStream output) {
        if (output == null) {
            output = System.err;
        }
        output.println("*** HttpServletRequest " + request);
        output.println("        uri = " + request.getRequestURI());
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            output.println("            parameter " + name + " = " + request.getParameter(name));
        }
        Enumeration e2 = request.getAttributeNames();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            output.println("            attribute " + name + " = " + request.getAttribute(name));
        }
        Enumeration e3 = request.getSession().getAttributeNames();
        while (e3.hasMoreElements()) {
            String name = (String)e3.nextElement();
            output.println("            session attribute " + name + " = " + request.getSession().getAttribute(name));
        }
    }

    public static void dumpServletContext(ServletContext context, PrintStream output) {
        if (output == null) {
            output = System.err;
        }
        output.println("*** ServletContext " + context);
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            output.println("            attribute " + name + " = " + context.getAttribute(name));
        }
    }

    static void setFormInScope(String formName, ActionForm form, ActionMapping mapping, HttpServletRequest request, boolean overwrite) {
        if (formName != null && form != null) {
            if (PageFlowUtils.isSessionScope(mapping)) {
                HttpSession session = request.getSession();
                if (overwrite || session.getAttribute(formName) == null) {
                    session.setAttribute(formName, (Object)form);
                }
            } else if (overwrite || request.getAttribute(formName) == null) {
                request.setAttribute(formName, (Object)form);
            }
        }
    }

    static boolean isSessionScope(ActionMapping mapping) {
        return mapping.getScope() == null || mapping.getScope().equals("session");
    }

    static ActionForm getFormBean(ActionMapping mapping, HttpServletRequest request) {
        String formBeanName = mapping.getName();
        if (formBeanName != null) {
            if (PageFlowUtils.isSessionScope(mapping)) {
                return (ActionForm)request.getSession().getAttribute(formBeanName);
            }
            return (ActionForm)request.getAttribute(formBeanName);
        }
        return null;
    }

    public static void setOutputForms(ActionMapping mapping, Forward fwd, HttpServletRequest request, boolean overwrite) {
        if (fwd == null || mapping == null) {
            return;
        }
        PageFlowUtils.setOutputForms(mapping, fwd.getOutputForms(), request, overwrite);
        PageFlowUtils.setForwardedForm(fwd.getFirstOutputForm(), (ServletRequest)request);
    }

    public static void setOutputForms(ActionMapping mapping, Forward fwd, HttpServletRequest request) {
        if (fwd == null || mapping == null) {
            return;
        }
        PageFlowUtils.setOutputForms(mapping, fwd.getOutputForms(), request);
        PageFlowUtils.setForwardedForm(fwd.getFirstOutputForm(), (ServletRequest)request);
    }

    public static void setOutputForms(ActionMapping mapping, ActionForm[] outputForms, HttpServletRequest request) {
        PageFlowUtils.setOutputForms(mapping, outputForms, request, true);
    }

    public static void setOutputForms(ActionMapping mapping, ActionForm[] outputForms, HttpServletRequest request, boolean overwrite) {
        try {
            if (!($assertionsDisabled || mapping.getScope() == null || mapping.getScope().equals("request") || mapping.getScope().equals("session"))) {
                throw new AssertionError((Object)mapping.getScope());
            }
            int i = 0;
            while (i < outputForms.length) {
                PageFlowUtils.setOutputForm(mapping, outputForms[i], request, overwrite);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while setting Struts form-beans", (Throwable)e);
        }
    }

    private static String getFormNameFromModuleConfig(ActionForm form, ModuleConfig moduleConfig) {
        String modulePrefix = moduleConfig.getPrefix();
        HashMap<String, String> formNameMap = (HashMap<String, String>)_formNameMaps.get(modulePrefix);
        if (formNameMap == null) {
            formNameMap = new HashMap<String, String>();
            FormBeanConfig[] formBeans = moduleConfig.findFormBeanConfigs();
            int j = 0;
            while (j < formBeans.length) {
                formNameMap.put(formBeans[j].getType(), formBeans[j].getName());
                ++j;
            }
            _formNameMaps.put(modulePrefix, formNameMap);
        }
        return (String)formNameMap.get(form.getClass().getName());
    }

    public static void setOutputForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, boolean overwrite) {
        if (form != null) {
            ModuleConfig moduleConfig = mapping.getModuleConfig();
            String formName = PageFlowUtils.getFormNameFromModuleConfig(form, moduleConfig);
            if (formName == null) {
                formName = PageFlowUtils.getFormBeanName(form, request, false);
            }
            PageFlowUtils.setFormInScope(formName, form, mapping, request, overwrite);
        }
    }

    public static String getFormBeanName(ActionForm formInstance, HttpServletRequest request) {
        return PageFlowUtils.getFormBeanName(formInstance, request, true);
    }

    public static String getFormBeanName(Class formBeanClass, HttpServletRequest request) {
        return PageFlowUtils.getFormBeanName(formBeanClass, request, true);
    }

    private static String getFormBeanName(Class formBeanClass, HttpServletRequest request, boolean doStrutsLookup) {
        String formType;
        int lastQualifier;
        ModuleConfig moduleConfig = RequestUtils.getRequestModuleConfig((HttpServletRequest)request);
        String formBeanClassName = formBeanClass.getName();
        if (doStrutsLookup) {
            FormBeanConfig[] formBeans = moduleConfig.findFormBeanConfigs();
            int j = 0;
            while (j < formBeans.length) {
                if (formBeans[j].getType().equals(formBeanClassName)) {
                    return formBeans[j].getName();
                }
                ++j;
            }
        }
        if ((lastQualifier = (formType = formBeanClassName).lastIndexOf(36)) == -1) {
            lastQualifier = formType.lastIndexOf(46);
        }
        String formName = formType.substring(lastQualifier + 1);
        if (moduleConfig.findFormBeanConfig(formName = Character.toLowerCase(formName.charAt(0)) + formName.substring(1)) != null) {
            formName = formType.replace('.', '_').replace('$', '_');
            if (!$assertionsDisabled && moduleConfig.findFormBeanConfig(formName) != null) {
                throw new AssertionError((Object)formName);
            }
        }
        return formName;
    }

    private static String getFormBeanName(ActionForm formInstance, HttpServletRequest request, boolean doStrutsLookup) {
        return PageFlowUtils.getFormBeanName(formInstance.getClass(), request, doStrutsLookup);
    }

    public static void preventCache(HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache");
    }

    static String getSourceFilePath(String className) {
        if (className.equals("global.Global")) {
            return "/WEB-INF/src/global/Global.app";
        }
        return PageFlowUtils.getPageFlowURI(className);
    }

    public static String getJpfClassName(String uri) {
        if (!$assertionsDisabled && uri == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && uri.length() <= 0) {
            throw new AssertionError();
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!$assertionsDisabled && !PageFlowUtils.osSensitiveEndsWith(uri, ".jpf")) {
            throw new AssertionError((Object)uri);
        }
        if (PageFlowUtils.osSensitiveEndsWith(uri, ".jpf")) {
            uri = uri.substring(0, uri.length() - JPF_EXTENSION_LEN);
        }
        return uri.replace('/', '.');
    }

    public static String getPageFlowURI(String className) {
        return '/' + className.replace('.', '/') + ".jpf";
    }

    public static String getModuleConfPath(String modulePath) {
        return new PageFlowActionServlet.DefaultModuleConfigLocator().getModuleConfigPath(modulePath);
    }

    public static boolean ensureAppDeployment(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        if (ScopedServletUtils.unwrapRequest((ServletRequest)PageFlowUtils.unwrapMultipart(request)) == null) {
            return SERVER_ADAPTER.ensureAppDeployment(request, response, context);
        }
        return false;
    }

    static void setActionURI(HttpServletRequest request) {
        request.setAttribute(ACTION_URI_ATTR, (Object)PageFlowUtils.decodeURI(request));
    }

    static String decodeURI(HttpServletRequest request) {
        return ScopedServletUtils.decodeURI((HttpServletRequest)request);
    }

    public static String getActionURI(ServletRequest request) {
        return (String)request.getAttribute(ACTION_URI_ATTR);
    }

    public static Boolean isSecureResource(String uri, ServletContext context, HttpServletRequest request) {
        return SERVER_ADAPTER.isSecureResource(uri, context, request);
    }

    public static Boolean isSecureResource(String uri, ServletContext context) {
        return SERVER_ADAPTER.isSecureResource(uri, context, null);
    }

    private static Map getPageInputMap(ServletRequest request, boolean createIfNotExist) {
        HashMap map = (HashMap)request.getAttribute(PAGEINPUT_MAP_ATTR);
        if (map == null && createIfNotExist) {
            map = new HashMap();
            request.setAttribute(PAGEINPUT_MAP_ATTR, map);
        }
        return map;
    }

    static void addPageInputs(Map toAdd, ServletRequest request, boolean overwrite) {
        if (toAdd != null) {
            Map map = PageFlowUtils.getPageInputMap(request, true);
            Iterator i = toAdd.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                boolean alreadyExists = map.containsKey(name);
                if (!overwrite && alreadyExists) continue;
                if (alreadyExists) {
                    logger.warn((Object)("Overwriting page input \"" + name + "\"."));
                }
                map.put(name, entry.getValue());
            }
        }
    }

    public static void addPageInput(String name, Object value, ServletRequest request) {
        Map map = PageFlowUtils.getPageInputMap(request, true);
        if (map.containsKey(name)) {
            logger.warn((Object)("Overwriting page input \"" + name + "\"."));
        }
        map.put(name, value);
    }

    public static Object getPageInput(String name, ServletRequest request) {
        Map map = PageFlowUtils.getPageInputMap(request, false);
        return map != null ? map.get(name) : null;
    }

    public static ModuleConfig getGlobalAppConfig(ServletContext context) {
        return PageFlowUtils.getModuleConfig("/-global", context);
    }

    public static ModuleConfig getModuleConfig(String modulePath, ServletContext context) {
        return (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE" + modulePath);
    }

    public static ModuleConfig ensureModuleConfig(String modulePath, ServletRequest request, ServletContext context) throws IOException, ServletException {
        ModuleConfig ret = PageFlowUtils.getModuleConfig(modulePath, context);
        if (ret != null) {
            return ret;
        }
        ActionServlet as = PageFlowUtils.getActionServlet(context);
        if (as instanceof AutoRegisterActionServlet) {
            return ((AutoRegisterActionServlet)as).ensureModuleRegistered(modulePath, request);
        }
        return null;
    }

    public static boolean isAbsoluteURI(String uri) {
        if (uri.startsWith("/")) {
            return false;
        }
        int i = 0;
        int len = uri.length();
        while (i < len) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (c == '/') {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static String getFileExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        return lastDot != -1 ? filename.substring(lastDot + 1) : "";
    }

    static HttpRedirector getHttpRedirector(ServletContext context, HttpRedirector defaultRedirector) {
        HttpRedirector redirector = (HttpRedirector)context.getAttribute(HTTP_REDIRECTOR_ATTR);
        if (redirector != null) {
            return redirector;
        }
        String redirectorClassName = context.getInitParameter(HTTP_REDIRECTOR_CLASS_PARAM);
        if (redirectorClassName != null) {
            try {
                Class<?> redirectorClass = Class.forName(redirectorClassName);
                redirector = (HttpRedirector)redirectorClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Error instantiating HttpRedirector " + redirectorClassName), (Throwable)e);
            }
        }
        if (redirector == null) {
            redirector = defaultRedirector;
        }
        context.setAttribute(HTTP_REDIRECTOR_ATTR, (Object)redirector);
        return redirector;
    }

    static void sendNonCachedOutput(String html, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.getWriter().println(html);
        PageFlowUtils.preventCache(response);
    }

    public static final ServerAdapter getServerAdapter() {
        return SERVER_ADAPTER;
    }

    private static ServerAdapter createServerAdapter() {
        String serverAdapterClassName = System.getProperty(SERVER_ADAPTER_PROP);
        if (serverAdapterClassName == null) {
            serverAdapterClassName = System.getProperty(CATALINA_HOME_PROP) != null ? TOMCAT_SERVER_ADAPTER_CLASS : WL_SERVER_ADAPTER_CLASS;
        }
        try {
            Class<?> serverAdapterClass = Class.forName(serverAdapterClassName);
            ServerAdapter serverAdapter = (ServerAdapter)serverAdapterClass.newInstance();
            if (debug.isOn()) {
                debug.out("Created server adapter of type " + serverAdapterClass);
            }
            return serverAdapter;
        }
        catch (ClassNotFoundException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Could not find ServerAdapter class " + serverAdapterClassName + "; using " + (class$com$bea$wlw$netui$pageflow$internal$DefaultServerAdapter == null ? (class$com$bea$wlw$netui$pageflow$internal$DefaultServerAdapter = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.internal.DefaultServerAdapter")) : class$com$bea$wlw$netui$pageflow$internal$DefaultServerAdapter).getName() + "."));
            }
            return new DefaultServerAdapter();
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Error instantiating ServerAdapter " + serverAdapterClassName + "; using " + (class$com$bea$wlw$netui$pageflow$internal$DefaultServerAdapter == null ? (class$com$bea$wlw$netui$pageflow$internal$DefaultServerAdapter = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.internal.DefaultServerAdapter")) : class$com$bea$wlw$netui$pageflow$internal$DefaultServerAdapter).getName() + "."), (Throwable)e);
            }
            return new DefaultServerAdapter();
        }
    }

    static ActionServlet getActionServlet(ServletContext context) {
        if (context == null) {
            return null;
        }
        return (ActionServlet)context.getAttribute("org.apache.struts.action.ACTION_SERVLET");
    }

    static void setForwardedForm(ActionForm form, ServletRequest request) {
        if (form == null) {
            request.removeAttribute(FORWARDED_OUTPUT_FORM_ATTR);
        } else {
            request.setAttribute(FORWARDED_OUTPUT_FORM_ATTR, (Object)form);
        }
    }

    static ActionForm getForwardedForm(ServletRequest request, boolean removeFromRequest) {
        ActionForm form = (ActionForm)request.getAttribute(FORWARDED_OUTPUT_FORM_ATTR);
        if (removeFromRequest) {
            request.removeAttribute(FORWARDED_OUTPUT_FORM_ATTR);
        }
        return form;
    }

    static final boolean isOSCaseSensitive() {
        return OS_CASE_SENSITIVE;
    }

    static final boolean osSensitiveEquals(String s1, String s2) {
        if (OS_CASE_SENSITIVE) {
            return s1.equals(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    static final boolean osSensitiveEndsWith(String str, String suffix) {
        int suffixLen;
        if (OS_CASE_SENSITIVE) {
            return str.endsWith(suffix);
        }
        int strLen = str.length();
        if (strLen < (suffixLen = suffix.length())) {
            return false;
        }
        return str.substring(strLen - suffixLen).equalsIgnoreCase(suffix);
    }

    public static void addValidationError(String propertyName, String messageKey, Object[] messageArgs, ServletRequest request) {
        PageFlowUtils.addValidationError(propertyName, new ActionError(messageKey, messageArgs), request);
    }

    public static void addValidationError(String propertyName, String messageKey, Object messageArg, ServletRequest request) {
        PageFlowUtils.addValidationError(propertyName, new ActionError(messageKey, messageArg), request);
    }

    public static void addValidationError(String propertyName, String messageKey, ServletRequest request) {
        PageFlowUtils.addValidationError(propertyName, new ActionError(messageKey), request);
    }

    static void addValidationError(String propertyName, ActionError error, ServletRequest request) {
        ActionErrors errors = (ActionErrors)request.getAttribute("org.apache.struts.action.ERROR");
        if (errors == null) {
            errors = new ActionErrors();
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        }
        errors.add(propertyName, error);
    }

    public static ActionResult strutsLookup(ServletContext context, ServletRequest request, HttpServletResponse response, String actionOverride, String[] autoResolveExtensions) throws Exception {
        String returnURI;
        ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)request);
        ScopedResponse scopedResponse = ScopedServletUtils.unwrapResponse((ServletResponse)response);
        if (!$assertionsDisabled && scopedRequest == null) {
            throw new AssertionError((Object)request.getClass().getName());
        }
        if (!$assertionsDisabled && scopedResponse == null) {
            throw new AssertionError((Object)response.getClass().getName());
        }
        if (scopedRequest == null) {
            throw new IllegalStateException("request must be of type " + (class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedRequest")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest).getName());
        }
        if (scopedResponse == null) {
            throw new IllegalStateException("response must be of type " + (class$com$bea$wlw$netui$pageflow$scoping$ScopedResponse == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedResponse = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.scoping.ScopedResponse")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedResponse).getName());
        }
        ActionServlet as = (ActionServlet)context.getAttribute("org.apache.struts.action.ACTION_SERVLET");
        if (as == null) {
            logger.error((Object)"There is no initialized ActionServlet.  The ActionServlet must be set to load-on-startup.");
            return null;
        }
        if (actionOverride != null) {
            if (!$assertionsDisabled && actionOverride.charAt(0) != '/') {
                throw new AssertionError((Object)actionOverride);
            }
            scopedRequest.setRequestURI(actionOverride + ".do");
        }
        if (!$assertionsDisabled && !(request instanceof ScopedRequestImpl)) {
            throw new AssertionError((Object)request.getClass().getName());
        }
        ((ScopedRequestImpl)request).setForwardedURI(null);
        if (PageFlowUtils.getServerAdapter().printCompileErrors((HttpServletRequest)scopedRequest, null, context, null, null)) {
            return new CompileErrorActionResult();
        }
        as.doGet((HttpServletRequest)scopedRequest, (HttpServletResponse)scopedResponse);
        if (!scopedResponse.didRedirect()) {
            returnURI = scopedRequest.getForwardedURI();
            if (autoResolveExtensions == null) {
                autoResolveExtensions = DEFAULT_AUTORESOLVE_EXTENSIONS;
            }
            if (returnURI != null) {
                int i = 0;
                while (i < autoResolveExtensions.length) {
                    if (PageFlowUtils.uriEndsWith(returnURI, autoResolveExtensions[i])) {
                        scopedRequest.doForward();
                        return PageFlowUtils.strutsLookup(context, (ServletRequest)scopedRequest, (HttpServletResponse)scopedResponse, null, autoResolveExtensions);
                    }
                    ++i;
                }
            }
        } else {
            returnURI = scopedResponse.getRedirectURI();
        }
        if (returnURI != null) {
            return new ActionResultImpl(returnURI, scopedResponse.didRedirect(), scopedResponse.getStatusCode(), scopedResponse.getStatusMessage(), scopedResponse.isError());
        }
        return null;
    }

    static boolean uriEndsWith(String uri, String ending) {
        int queryStart = uri.indexOf(63);
        if (queryStart == -1) {
            return uri.endsWith(ending);
        }
        return uri.length() - queryStart >= ending.length() && uri.substring(queryStart - ending.length(), queryStart).equals(ending);
    }

    public static void addBindingUpdateError(ServletRequest request, String expression, String message, Throwable cause) {
        LinkedHashMap<String, BindingUpdateError> errors = (LinkedHashMap<String, BindingUpdateError>)request.getAttribute(BINDING_UPDATE_ERRORS_ATTR);
        if (errors == null) {
            errors = new LinkedHashMap<String, BindingUpdateError>();
            request.setAttribute(BINDING_UPDATE_ERRORS_ATTR, errors);
        }
        errors.put(expression, new BindingUpdateError(expression, message, cause));
    }

    public static Map getBindingUpdateErrors(ServletRequest request) {
        return (Map)request.getAttribute(BINDING_UPDATE_ERRORS_ATTR);
    }

    static HttpServletRequest unwrapMultipart(HttpServletRequest request) {
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        return request;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).desiredAssertionStatus();
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils));
        logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils));
        JPF_STACK_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + ".PageFlow_stack";
        CURRENT_JPF_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_currentPageFlow";
        GLOBALAPP_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_globalApp";
        ACTION_URI_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_actionURI";
        FORWARDED_OUTPUT_FORM_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_forwardedForm";
        PAGEINPUT_MAP_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_pageInputs";
        JPF_EXTENSION_LEN = ".jpf".length();
        HTTP_REDIRECTOR_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_httpRedirector";
        OS_CASE_SENSITIVE = !new File("x").equals(new File("X"));
        DEFAULT_AUTORESOLVE_EXTENSIONS = new String[]{".do", ".jpf"};
        BINDING_UPDATE_ERRORS_ATTR = (class$com$bea$wlw$netui$pageflow$PageFlowUtils == null ? (class$com$bea$wlw$netui$pageflow$PageFlowUtils = PageFlowUtils.class$("com.bea.wlw.netui.pageflow.PageFlowUtils")) : class$com$bea$wlw$netui$pageflow$PageFlowUtils).getName() + "_bindingUpdateErrors";
        SERVER_ADAPTER = PageFlowUtils.createServerAdapter();
        IS_WEBLOGIC_SERVER_ADAPTER = SERVER_ADAPTER.getClass().getName().equals(WL_SERVER_ADAPTER_CLASS);
        _formNameMaps = new ConcurrentReaderHashMap();
    }
}

