/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow;

import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.RequestUtils;

class MultipartRequestUtils {
    private static final Logger log = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$MultipartRequestUtils == null ? (class$com$bea$wlw$netui$pageflow$MultipartRequestUtils = MultipartRequestUtils.class$("com.bea.wlw.netui.pageflow.MultipartRequestUtils")) : class$com$bea$wlw$netui$pageflow$MultipartRequestUtils));
    private static final String PREHANDLED_MULTIPART_REQUEST_ATTR = (class$com$bea$wlw$netui$pageflow$MultipartRequestUtils == null ? (class$com$bea$wlw$netui$pageflow$MultipartRequestUtils = MultipartRequestUtils.class$("com.bea.wlw.netui.pageflow.MultipartRequestUtils")) : class$com$bea$wlw$netui$pageflow$MultipartRequestUtils).getName() + "_prehandledMultipart";
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$MultipartRequestUtils;

    MultipartRequestUtils() {
    }

    static final Map handleMultipartRequest(HttpServletRequest request, ActionForm bean) throws ServletException {
        String contentType = request.getContentType();
        String method = request.getMethod();
        boolean isMultipart = false;
        Map multipartParameters = null;
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST")) {
            ActionServletWrapper servlet;
            if (bean != null) {
                servlet = bean.getServletWrapper();
            } else {
                ServletContext servletContext = PageFlowUtils.getServerAdapter().getServletContext(request);
                servlet = new ActionServletWrapper(PageFlowUtils.getActionServlet(servletContext));
            }
            MultipartRequestHandler multipartHandler = (MultipartRequestHandler)request.getAttribute(PREHANDLED_MULTIPART_REQUEST_ATTR);
            boolean preHandled = false;
            if (multipartHandler == null) {
                multipartHandler = MultipartRequestUtils.getMultipartHandler(request);
            } else {
                preHandled = true;
                request.removeAttribute(PREHANDLED_MULTIPART_REQUEST_ATTR);
            }
            if (bean != null) {
                bean.setMultipartRequestHandler(multipartHandler);
            }
            if (multipartHandler != null) {
                Boolean maxLengthExceeded;
                isMultipart = true;
                servlet.setServletFor(multipartHandler);
                multipartHandler.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
                if (!preHandled) {
                    multipartHandler.handleRequest(request);
                }
                if ((maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxLengthExceeded.booleanValue()) {
                    return null;
                }
                multipartParameters = MultipartRequestUtils.getAllParametersForMultipartRequest(request, multipartHandler);
            }
        }
        if (!isMultipart) {
            return null;
        }
        return multipartParameters;
    }

    static void preHandleMultipartRequest(MultipartRequestWrapper request) throws ServletException {
        MultipartRequestHandler multipartHandler = MultipartRequestUtils.getMultipartHandler((HttpServletRequest)request);
        if (multipartHandler != null) {
            multipartHandler.handleRequest((HttpServletRequest)request);
            request.setAttribute(PREHANDLED_MULTIPART_REQUEST_ATTR, (Object)multipartHandler);
        }
    }

    private static final MultipartRequestHandler getMultipartHandler(HttpServletRequest request) throws ServletException {
        ModuleConfig moduleConfig;
        MultipartRequestHandler multipartHandler = null;
        String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
        request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
        if (multipartClass != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance((String)multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, " + "defaulting to global multipart class"));
            }
            catch (InstantiationException ie) {
                log.error((Object)("InstantiaionException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + ie.getMessage()));
            }
            catch (IllegalAccessException iae) {
                log.error((Object)("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + iae.getMessage()));
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        if ((multipartClass = (moduleConfig = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE")).getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance((String)multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServletException("Cannot find multipart class \"" + multipartClass + "\"" + ", exception: " + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new ServletException("InstantiaionException when instantiating multipart class \"" + multipartClass + "\", exception: " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ServletException("IllegalAccessException when instantiating multipart class \"" + multipartClass + "\", exception: " + iae.getMessage());
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        return multipartHandler;
    }

    private static final Map getAllParametersForMultipartRequest(HttpServletRequest request, MultipartRequestHandler multipartHandler) {
        String key;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Hashtable elements = multipartHandler.getAllElements();
        Enumeration enumeration = elements.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            parameters.put(key, elements.get(key));
        }
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
            enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                parameters.put(key, request.getParameterValues(key));
            }
        } else {
            log.debug((Object)"Gathering multipart parameters for unwrapped request");
        }
        return parameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

