/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow;

import com.bea.wlw.netui.pageflow.ActionNotFoundException;
import com.bea.wlw.netui.pageflow.ActionResolver;
import com.bea.wlw.netui.pageflow.ActionResult;
import com.bea.wlw.netui.pageflow.AutoRegisterActionServlet;
import com.bea.wlw.netui.pageflow.EmptyNestingStackException;
import com.bea.wlw.netui.pageflow.FormData;
import com.bea.wlw.netui.pageflow.Forward;
import com.bea.wlw.netui.pageflow.LoginExpiredException;
import com.bea.wlw.netui.pageflow.NoCurrentPageFlowException;
import com.bea.wlw.netui.pageflow.NoMatchingActionMethodException;
import com.bea.wlw.netui.pageflow.NoPreviousActionException;
import com.bea.wlw.netui.pageflow.NoPreviousPageException;
import com.bea.wlw.netui.pageflow.NotLoggedInException;
import com.bea.wlw.netui.pageflow.PageFlowConstants;
import com.bea.wlw.netui.pageflow.PageFlowController;
import com.bea.wlw.netui.pageflow.PageFlowException;
import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.PreviousActionInfo;
import com.bea.wlw.netui.pageflow.PreviousPageInfo;
import com.bea.wlw.netui.pageflow.UnfulfilledRolesException;
import com.bea.wlw.netui.pageflow.UnresolvableForwardException;
import com.bea.wlw.netui.pageflow.config.PageFlowActionMapping;
import com.bea.wlw.netui.pageflow.config.PageFlowExceptionConfig;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.cache.ConcurrentReaderHashMap;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.exception.LocalizedIllegalStateException;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public abstract class FlowController
extends Action
implements Serializable,
PageFlowConstants,
ActionResolver,
HttpSessionBindingListener {
    private static final Debug debug;
    private static final Logger logger;
    static final String RETURNING_FORM_ATTR_NAME;
    static final String RETURNING_FROM_NESTING_ATTR_NAME;
    private static final String ONCREATE_EXCEPTION_FORWARD;
    private static final int DEFAULT_MAX_CONCURRENT_REQUEST_COUNT = 4;
    private static final String MAX_CONCURRENT_REQUESTS_PARAM = "pageflow-max-concurrent-requests";
    private static final int EXCEEDED_MAX_CONCURRENT_REQUESTS_ERRORCODE = 503;
    private transient HttpServletRequest _request = null;
    private transient HttpServletResponse _response = null;
    private transient ActionMapping _mapping = null;
    private transient HttpSession _session = null;
    private transient ActionServlet _transientActionServlet = null;
    private transient ModuleConfig _moduleConfig = null;
    private transient int _requestCount = 0;
    private static int _maxConcurrentRequestCount;
    private static Map _actionMethodCache;
    private static Map _exceptionHandlerMethodCache;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$FlowController;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$Forward;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$FormData;
    static /* synthetic */ Class class$org$apache$struts$action$ActionForm;

    public void login(String username, String password) throws LoginException {
        PageFlowUtils.getServerAdapter().login(username, password, this.getRequest());
    }

    public void logout(boolean invalidateSessions) {
        PageFlowUtils.getServerAdapter().logout(invalidateSessions, this.getRequest());
    }

    protected void sendError(String errText, HttpServletResponse response) throws IOException {
        String html = Bundle.getString((String)"PageFlow_Custom_Error", (Object[])new Object[]{this.getClass().getName(), errText});
        PageFlowUtils.sendNonCachedOutput(html, response);
    }

    private String getMessage(String messageKey, String bundle, Object[] args, HttpServletRequest request) {
        MessageResources resources = null;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if ((resources = (MessageResources)request.getAttribute(bundle)) == null) {
            resources = (MessageResources)this.getServlet().getServletContext().getAttribute(bundle);
        }
        if (resources == null) {
            logger.error((Object)("Could not find message-resources for bundle " + bundle));
            return null;
        }
        Locale userLocale = FlowController.retrieveUserLocale(request, null);
        if (args == null) {
            return resources.getMessage(userLocale, messageKey);
        }
        return resources.getMessage(userLocale, messageKey, args);
    }

    public static Locale retrieveUserLocale(HttpServletRequest request, String locale) {
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        HttpSession session = request.getSession(false);
        Locale userLocale = null;
        if (session != null) {
            userLocale = (Locale)session.getAttribute(locale);
        }
        if (userLocale == null) {
            userLocale = Action.defaultLocale;
        }
        return userLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ActionForward handleException(Throwable ex, ActionMapping mapping, String actionName, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        while (ex instanceof UndeclaredThrowableException) {
            ex = ((UndeclaredThrowableException)ex).getUndeclaredThrowable();
        }
        if (debug.isOn()) {
            debug.out("in handleException() for " + ex.getClass().getName());
        }
        if (logger.isInfoEnabled()) {
            StringBuffer msg = new StringBuffer("Handling uncaught Throwable ");
            logger.info((Object)msg.append(ex.getClass().getName()).toString());
        }
        request.setAttribute("org.apache.struts.action.EXCEPTION", (Object)ex);
        ModuleConfig altModuleConfig = null;
        try {
            ExceptionConfig ec = null;
            if (mapping != null) {
                ec = mapping.findException(ex.getClass());
            } else {
                ModuleConfig mc = this.getModuleConfig(request);
                if (mc != null) {
                    ec = this.getExceptionConfig(ex.getClass(), mc);
                    altModuleConfig = mc;
                    request.setAttribute("org.apache.struts.action.MODULE", (Object)mc);
                }
            }
            FlowController exceptionController = this;
            ActionMapping actionMapping = mapping;
            if (ec == null) {
                ServletContext cxt = this.getServlet().getServletContext();
                altModuleConfig = PageFlowUtils.getGlobalAppConfig(cxt);
                ec = this.getExceptionConfig(ex.getClass(), altModuleConfig);
                actionMapping = null;
                if (ec != null) {
                    debug.outIfOn("Found exception-config in Global.app");
                    exceptionController = PageFlowUtils.ensureGlobalApp(request, response, cxt);
                    if (!$assertionsDisabled && exceptionController == null) {
                        throw new AssertionError();
                    }
                    request.setAttribute("org.apache.struts.action.MODULE", (Object)altModuleConfig);
                }
            }
            if (ec != null) {
                if (debug.isOn()) {
                    debug.out("Found exception-config for exception " + ex.getClass().getName() + ": handler=" + ec.getHandler() + ", path=" + ec.getPath());
                }
                if (ec instanceof PageFlowExceptionConfig && ((PageFlowExceptionConfig)ec).isHandlerMethod()) {
                    if (!$assertionsDisabled && ec.getPath() != null) {
                        throw new AssertionError((Object)ec.getPath());
                    }
                    String methodName = ec.getHandler();
                    Method method = exceptionController.getExceptionHandlerMethod(methodName, ex, form);
                    if (method != null) {
                        ActionForward actionForward;
                        PageFlowExceptionConfig pfec = (PageFlowExceptionConfig)ec;
                        String message = pfec.getDefaultMessage();
                        String messageKey = ec.getKey();
                        if (messageKey != null && messageKey.length() > 0) {
                            message = this.getMessage(messageKey, null, null, request);
                        }
                        FlowController flowController = exceptionController;
                        synchronized (flowController) {
                            exceptionController.setRequestMembers(request, response, mapping);
                            ActionForward result = null;
                            try {
                                result = exceptionController.invokeExceptionHandlerMethod(method, ex, actionName, message, form, actionMapping, request, response, altModuleConfig, this.getServlet().getServletContext(), pfec.isReadonly());
                            }
                            catch (Throwable e) {
                                this.sendUnhandledExceptionError(e, request, response);
                            }
                            exceptionController.nullRequestMembers(request);
                            actionForward = result;
                        }
                        Object var21_25 = null;
                        this.nullRequestMembers(request);
                        return actionForward;
                    }
                    String errText = form != null ? Bundle.getString((String)"PageFlow_MissingExceptionHandlerWithForm", (Object[])new Object[]{methodName, form.getClass().getName()}) : Bundle.getString((String)"PageFlow_MissingExceptionHandler", (Object)methodName);
                    exceptionController.sendError(errText, response);
                    ActionForward actionForward = null;
                    Object var21_26 = null;
                    this.nullRequestMembers(request);
                    return actionForward;
                }
                if (ex instanceof Exception) {
                    ActionForward actionForward;
                    try {
                        PageFlowExceptionConfig pfec;
                        ExceptionHandler handler = (ExceptionHandler)RequestUtils.applicationInstance((String)ec.getHandler());
                        ActionForward result = handler.execute((Exception)ex, ec, mapping, form, request, response);
                        if (ec instanceof PageFlowExceptionConfig && (pfec = (PageFlowExceptionConfig)ec).isPathContextRelative()) {
                            result.setContextRelative(true);
                        }
                        if (debug.isOn()) {
                            debug.out("Exception-handler says: forward to " + result.getPath());
                        }
                        actionForward = result;
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                    Object var21_27 = null;
                    this.nullRequestMembers(request);
                    return actionForward;
                }
            }
            Object var21_28 = null;
            this.nullRequestMembers(request);
        }
        catch (Throwable throwable) {
            Object var21_29 = null;
            this.nullRequestMembers(request);
            throw throwable;
        }
        if (debug.isOn()) {
            debug.out("handleException failed -- " + ex.getClass().getName() + " unhandled.");
        }
        if (logger.isErrorEnabled()) {
            StringBuffer msg = new StringBuffer("Throwable ").append(ex.getClass().getName());
            logger.error((Object)msg.append(" unhandled by current page flow and Global.app.").toString(), ex);
        }
        this.sendUnhandledExceptionError(ex, request, response);
        return null;
    }

    private void sendUnhandledExceptionError(Throwable ex, HttpServletRequest request, HttpServletResponse response) {
        block5: {
            if (ex instanceof InvocationTargetException) {
                this.sendUnhandledExceptionError(((InvocationTargetException)ex).getTargetException(), request, response);
                return;
            }
            logger.error((Object)"Unhandled Page Flow Exception", ex);
            try {
                if (ex instanceof PageFlowException) {
                    ((PageFlowException)ex).sendError(request, response);
                    break block5;
                }
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter(sw);
                ex.printStackTrace(out);
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = " ";
                }
                Object[] args = new Object[4];
                args[0] = ex.getClass().getName();
                args[1] = ex.getMessage();
                args[2] = sw.toString();
                System.err.println("Unhandled Page Flow Exception:");
                ex.printStackTrace();
                String html = Bundle.getString((String)"PageFlow_UnhandledException", (Object[])args);
                PageFlowUtils.sendNonCachedOutput(html, response);
            }
            catch (IOException ioEx) {
                logger.error((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
        }
    }

    private ExceptionConfig getExceptionConfig(Class exceptionType, ModuleConfig moduleConfig) {
        ExceptionConfig config = null;
        if (moduleConfig != null) {
            while (config == null && exceptionType != null) {
                config = moduleConfig.findExceptionConfig(exceptionType.getName());
                exceptionType = exceptionType.getSuperclass();
            }
        }
        return config;
    }

    private String getActionName(ActionMapping mapping) {
        String actionName = mapping.getPath();
        return actionName.charAt(0) == '/' ? actionName.substring(1) : actionName;
    }

    protected String getCurrentActionName() {
        return this.getActionName(this.getMapping());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.incrementRequestCount(request, response, this.getServlet().getServletContext())) {
            return null;
        }
        try {
            ActionForward actionForward;
            FlowController flowController = this;
            synchronized (flowController) {
                actionForward = this.internalExecute(mapping, form, request, response);
            }
            Object var9_7 = null;
            this.decrementRequestCount(request);
            return actionForward;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.decrementRequestCount(request);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionForward internalExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward onCreateFwd = (ActionForward)request.getAttribute(ONCREATE_EXCEPTION_FORWARD);
        if (onCreateFwd != null) {
            return onCreateFwd;
        }
        PageFlowUtils.setActionURI(request);
        String actionName = this.getActionName(mapping);
        boolean gotPastBeforeAction = false;
        try {
            PageFlowActionMapping jpfMapping;
            String unqualifiedAction;
            Object i;
            this.setRequestMembers(request, response, mapping);
            this.beforeAction();
            gotPastBeforeAction = true;
            boolean isPageFlowActionMapping = mapping instanceof PageFlowActionMapping;
            ActionForm returningForm = (ActionForm)request.getAttribute(RETURNING_FORM_ATTR_NAME);
            if (returningForm != null) {
                if (debug.isOn()) {
                    debug.out("Got return form from nested PageFlow: " + returningForm);
                }
                if (logger.isInfoEnabled()) {
                    StringBuffer msg = new StringBuffer("Nested page flow returned form ");
                    logger.info((Object)msg.append(returningForm).append('.').toString());
                }
                form = returningForm;
                request.removeAttribute(RETURNING_FORM_ATTR_NAME);
            }
            if (form != null && isPageFlowActionMapping && ((PageFlowActionMapping)mapping).isOverloaded()) {
                String mappingPath = mapping.getPath();
                i = form.getClass();
                while (i != null) {
                    String formQualifiedActionPath = this.getFormQualifiedActionPath((Class)i, mappingPath);
                    ActionConfig cf = mapping.getModuleConfig().findActionConfig(formQualifiedActionPath);
                    if (cf != null) {
                        if (!$assertionsDisabled && !(cf instanceof PageFlowActionMapping)) {
                            throw new AssertionError((Object)cf.getClass().getName());
                        }
                        if (debug.isOn()) {
                            debug.out("Found form-specific mapping " + cf.getPath() + " -- choosing this one over current mapping " + mappingPath);
                        }
                        mapping = (PageFlowActionMapping)cf;
                        break;
                    }
                    i = i.getSuperclass();
                }
            }
            if (isPageFlowActionMapping && (unqualifiedAction = ((PageFlowActionMapping)mapping).getUnqualifiedActionName()) != null) {
                actionName = unqualifiedAction;
                if (debug.isOn()) {
                    debug.out("Using path /" + unqualifiedAction + " instead of " + mapping.getPath());
                }
            }
            if (isPageFlowActionMapping && (jpfMapping = (PageFlowActionMapping)mapping).isLoginRequired() && request.getUserPrincipal() == null) {
                throw this.createNotLoggedInException(actionName, request);
            }
            if (request.getAttribute(PageFlowConstants.PROCESS_ROLES_FAILED_ATTR) != null) {
                request.removeAttribute(PageFlowConstants.PROCESS_ROLES_FAILED_ATTR);
                PageFlowException ex = request.getUserPrincipal() == null ? this.createNotLoggedInException(actionName, request) : new UnfulfilledRolesException(mapping.getRoleNames(), mapping.getRoles(), actionName, this);
                i = this.handleException(ex, mapping, actionName, form, request, response);
                return i;
            }
            ActionForward retVal = this.getActionMethodForward(actionName, form, request, response, mapping);
            i = this.forwardTo(retVal, mapping, request, response, actionName, null, form, this.getServlet().getServletContext());
            return i;
        }
        catch (Exception e) {
            ActionForward actionForward = this.handleException(e, mapping, actionName, form, request, response);
            return actionForward;
        }
        finally {
            ActionForward overrideReturn = null;
            if (gotPastBeforeAction) {
                try {
                    this.setRequestMembers(request, response, mapping);
                    this.afterAction();
                }
                catch (Throwable th) {
                    overrideReturn = this.handleException(th, mapping, actionName, form, request, response);
                }
            }
            this.nullRequestMembers(request);
            this.savePreviousActionInfo(form, request, mapping, this.getServlet().getServletContext());
            if (overrideReturn != null) {
                return overrideReturn;
            }
        }
    }

    private NotLoggedInException createNotLoggedInException(String actionName, HttpServletRequest request) {
        HttpSession session;
        String requestedSessionID = request.getRequestedSessionId();
        if (!(requestedSessionID == null || (session = request.getSession(false)) != null && requestedSessionID.equals(session.getId()))) {
            return new LoginExpiredException(actionName, this);
        }
        return new NotLoggedInException(actionName, this);
    }

    public abstract String getModulePath();

    protected synchronized void beforeAction() throws Exception {
    }

    protected synchronized void afterAction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void create(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        PageFlowUtils.getServerAdapter().initBusinessControls(request, this);
        this.setServlet(PageFlowUtils.getActionServlet(servletContext));
        this.setRequestMembers(request, response, null);
        try {
            try {
                this.onCreate();
            }
            catch (Throwable th) {
                try {
                    logger.info((Object)("Handling exception in onCreate(), page flow " + this), th);
                    ActionForward fwd = this.handleException(th, null, "[onCreate]", null, request, response);
                    request.setAttribute(ONCREATE_EXCEPTION_FORWARD, (Object)fwd);
                }
                catch (Exception e) {
                    logger.error((Object)"Exception thrown while handling exception in onCreate()", (Throwable)e);
                }
            }
            Object var7_7 = null;
            this.nullRequestMembers(request);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.nullRequestMembers(request);
            throw throwable;
        }
    }

    protected void onCreate() throws Exception {
    }

    void destroy(HttpSession session) {
        this.onDestroy();
        this.onDestroy(session);
        PageFlowUtils.getServerAdapter().uninitBusinessControls(this);
    }

    protected void onDestroy() {
    }

    protected void onDestroy(HttpSession session) {
    }

    ActionForward processForward(Forward fwd, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ActionForm form, ServletContext servletContext) throws IOException {
        return this.forwardTo(fwd, mapping, request, response, this.getActionName(mapping), null, form, servletContext);
    }

    ActionForward forwardTo(ActionForward fwd, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String actionName, ModuleConfig altModuleConfig, ActionForm form, ServletContext servletContext) throws IOException {
        boolean isSpecialForward = false;
        boolean isReturnToCurrentPage = false;
        if (fwd != null && fwd instanceof Forward) {
            Forward pageFlowFwd = (Forward)fwd;
            pageFlowFwd.initialize(mapping, this);
            pageFlowFwd.setAltModuleConfig(altModuleConfig);
            if (!pageFlowFwd.doesResolve()) {
                throw new UnresolvableForwardException(pageFlowFwd.getName(), actionName, this);
            }
            if (pageFlowFwd.isReturnToPage()) {
                PreviousPageInfo prevPageInfo;
                isSpecialForward = true;
                PageFlowController curJpf = PageFlowUtils.getCurrentPageFlow(request);
                if (curJpf == null) {
                    throw new NoCurrentPageFlowException(actionName, pageFlowFwd);
                }
                switch (pageFlowFwd.getReturnToType()) {
                    case 1: {
                        isReturnToCurrentPage = true;
                        prevPageInfo = curJpf.getCurrentPageInfo();
                        break;
                    }
                    case 2: {
                        prevPageInfo = curJpf.getPreviousPageInfo();
                        break;
                    }
                    case -1: {
                        prevPageInfo = this.getPreviousPageInfoLegacy(curJpf, request);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(pageFlowFwd.getReturnToType());
                        }
                        prevPageInfo = curJpf.getCurrentPageInfo();
                    }
                }
                fwd = this.doReturnToPage(request, prevPageInfo, curJpf, form, actionName, pageFlowFwd);
                if (fwd != null) {
                    if (pageFlowFwd.hasExplicitRedirectValue()) {
                        fwd.setRedirect(pageFlowFwd.getRedirect());
                    }
                    String fwdPath = fwd.getPath();
                    String newQueryString = pageFlowFwd.getQueryString();
                    if (newQueryString != null) {
                        int existingQuery = fwdPath.indexOf(63);
                        if (existingQuery != -1) {
                            fwd.setPath(fwdPath.substring(0, existingQuery) + newQueryString);
                        } else {
                            fwd.setPath(fwdPath + newQueryString);
                        }
                    }
                }
                if (prevPageInfo != null) {
                    mapping = prevPageInfo.getMapping();
                    if (form == null) {
                        form = prevPageInfo.getForm();
                    }
                }
                if (debug.isOn()) {
                    debug.out("return-to-page: " + (fwd != null ? fwd.getPath() : "[null]"));
                }
            } else if (pageFlowFwd.isReturnToAction()) {
                isSpecialForward = true;
                fwd = this.doReturnToAction(request, actionName, pageFlowFwd);
            }
            if (pageFlowFwd.shouldPopPageFlow()) {
                isSpecialForward = true;
                Stack pfStack = PageFlowUtils.getPageFlowStack(request);
                String exitAction = pageFlowFwd.getPath();
                if (pfStack.isEmpty()) {
                    PageFlowController curJpf = PageFlowUtils.getCurrentPageFlow(request);
                    if (debug.isOn()) {
                        debug.out("Tried to pop from empty PageFlow stack.  Current = " + curJpf.getClass().getName());
                    }
                    if (logger.isWarnEnabled()) {
                        StringBuffer msg = new StringBuffer("Tried to pop from empty PageFlow stack.");
                        msg.append("  Current page flow is ").append(curJpf.getClass().getName());
                        logger.warn((Object)msg.append('.').toString());
                    }
                    throw new EmptyNestingStackException(exitAction, curJpf);
                }
                PageFlowController poppedPageFlow = (PageFlowController)pfStack.pop();
                poppedPageFlow.setIsOnNestingStack(false);
                PageFlowUtils.ensurePageFlowStackFailover(request, pfStack);
                if (debug.isOn()) {
                    debug.out("Popped PageFlowController " + poppedPageFlow + " from the nesting stack");
                }
                PageFlowUtils.setCurrentPageFlow(poppedPageFlow, request);
                StringBuffer exitActionPath = new StringBuffer();
                if (!$assertionsDisabled && exitAction.charAt(0) == '/') {
                    throw new AssertionError((Object)exitAction);
                }
                if (debug.isOn()) {
                    debug.out("Action on popped PageFlowController is " + exitAction);
                }
                exitActionPath.append(poppedPageFlow.getModulePath());
                if (exitAction.charAt(0) != '/') {
                    exitActionPath.append('/');
                }
                exitActionPath.append(exitAction).append(".do");
                fwd = new ActionForward(exitActionPath.toString(), false);
                fwd.setContextRelative(true);
                ActionForm retForm = pageFlowFwd.getFirstOutputForm();
                if (retForm != null) {
                    request.setAttribute(RETURNING_FORM_ATTR_NAME, (Object)retForm);
                }
                request.setAttribute(RETURNING_FROM_NESTING_ATTR_NAME, (Object)Boolean.TRUE);
            }
            PageFlowUtils.setOutputForms(mapping, pageFlowFwd, request);
            PageFlowUtils.addPageInputs(pageFlowFwd.getPageInputs(), (ServletRequest)request, true);
        }
        if (debug.isOn()) {
            if (fwd != null) {
                if (fwd.getRedirect()) {
                    debug.out("Redirecting to " + fwd.getPath());
                } else {
                    debug.out("Forwarding to " + fwd.getPath());
                }
            } else {
                debug.out("null ActionForward -- not doing any forward or redirect.");
            }
        }
        if (!isReturnToCurrentPage) {
            this.savePreviousPageInfo(fwd, form, mapping, request, servletContext, isSpecialForward);
        }
        return fwd;
    }

    abstract PreviousPageInfo getPreviousPageInfoLegacy(PageFlowController var1, HttpServletRequest var2);

    private ActionForward doReturnToAction(HttpServletRequest request, String actionName, Forward pageFlowFwd) {
        PageFlowController curJpf = PageFlowUtils.getCurrentPageFlow(request);
        if (curJpf == null) {
            throw new NoCurrentPageFlowException(actionName, pageFlowFwd);
        }
        PreviousActionInfo prevActionInfo = curJpf.getPreviousActionInfo();
        if (prevActionInfo != null) {
            String actionURI = prevActionInfo.getActionURI();
            if (debug.isOn()) {
                debug.out("return-to-action: " + actionURI);
            }
            if (prevActionInfo.getForm() != null && pageFlowFwd.getFirstOutputForm() == null) {
                pageFlowFwd.addOutputForm(prevActionInfo.getForm());
            }
            String query = pageFlowFwd.getQueryString() != null ? pageFlowFwd.getQueryString() : "";
            ActionForward fwd = new ActionForward(actionURI + query, pageFlowFwd.getRedirect());
            fwd.setContextRelative(true);
            return fwd;
        }
        if (debug.isOn()) {
            debug.out("Attempted return-to-action, but previous action info was missing.");
        }
        throw new NoPreviousActionException(actionName, pageFlowFwd, curJpf);
    }

    private ActionForward doReturnToPage(HttpServletRequest request, PreviousPageInfo prevPageInfo, PageFlowController currentPageFlow, ActionForm currentForm, String actionName, Forward pageFlowFwd) {
        if (prevPageInfo != null) {
            ActionForward retFwd = prevPageInfo.getForward();
            if (retFwd instanceof Forward) {
                PageFlowUtils.setOutputForms(prevPageInfo.getMapping(), (Forward)retFwd, request, false);
                PageFlowUtils.addPageInputs(((Forward)retFwd).getPageInputs(), (ServletRequest)request, false);
            }
            if (currentForm != null) {
                PageFlowUtils.setOutputForm(prevPageInfo.getMapping(), currentForm, request, false);
            }
            if (prevPageInfo.getMapping() != null) {
                PageFlowUtils.setFormInScope(prevPageInfo.getMapping().getName(), prevPageInfo.getForm(), prevPageInfo.getMapping(), request, false);
            }
            if (!retFwd.getContextRelative() && this != currentPageFlow) {
                retFwd = new ActionForward(retFwd.getName(), currentPageFlow.getModulePath() + retFwd.getPath(), retFwd.getRedirect(), true);
            }
            if (debug.isOn()) {
                debug.out("Return-to-page in PageFlowController " + this.getClass().getName() + ": original URI " + retFwd.getPath());
            }
            return retFwd;
        }
        if (debug.isOn()) {
            debug.out("Attempted return-to-page, but previous page info was missing.");
        }
        throw new NoPreviousPageException(actionName, pageFlowFwd, currentPageFlow);
    }

    private Map getCache(Map staticCache) {
        String className = this.getClass().getName();
        Map cache = (Map)staticCache.get(className);
        if (cache == null) {
            cache = new ConcurrentReaderHashMap();
            staticCache.put(className, cache);
        }
        return cache;
    }

    /*
     * Unable to fully structure code
     */
    protected Method getActionMethod(String methodName, Class argType) {
        block3: {
            cacheKey = argType != null ? methodName + '/' + argType.getName() : methodName;
            cache = this.getCache(FlowController._actionMethodCache);
            actionMethod = (Method)cache.get(cacheKey);
            if (actionMethod != null) {
                return actionMethod;
            }
            if (argType != null) ** GOTO lbl11
            actionMethod = this.lookupMethod(methodName, null);
            break block3;
            while ((actionMethod = this.lookupMethod(methodName, new Class[]{argType})) == null) {
                argType = argType.getSuperclass();
lbl11:
                // 2 sources

                if (argType != null) continue;
            }
        }
        if (actionMethod != null && actionMethod.getReturnType().equals(FlowController.class$com$bea$wlw$netui$pageflow$Forward == null ? (FlowController.class$com$bea$wlw$netui$pageflow$Forward = FlowController.class$("com.bea.wlw.netui.pageflow.Forward")) : FlowController.class$com$bea$wlw$netui$pageflow$Forward)) {
            actionMethod.setAccessible(true);
            cache.put(cacheKey, actionMethod);
            return actionMethod;
        }
        return null;
    }

    ActionForward getActionMethodForward(String actionName, ActionForm inputForm, HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws Exception {
        Method actionMethod = this.getActionMethod(actionName, inputForm != null ? inputForm.getClass() : null);
        if (actionMethod != null) {
            return this.invokeActionMethod(actionMethod, inputForm, request, mapping);
        }
        if (debug.isOn()) {
            debug.out("Could not find matching action method for action=" + actionName + ", form=" + (inputForm != null ? inputForm.getClass().getName() : "null"));
        }
        if (logger.isWarnEnabled()) {
            StringBuffer msg = new StringBuffer("Could not find matching action method for action=");
            msg.append(actionName).append(", form=");
            msg.append(inputForm != null ? inputForm.getClass().getName() : "[none]");
            logger.warn((Object)msg.toString());
        }
        throw new NoMatchingActionMethodException(actionName, inputForm, this);
    }

    private String getFormQualifiedActionPath(Class formClass, String actionPath) {
        StringBuffer ret = new StringBuffer(actionPath);
        ret.append('_');
        ret.append(formClass.getName().replace('.', '_').replace('$', '_'));
        return ret.toString();
    }

    protected ActionForward invokeActionMethod(Method method, ActionForm arg) throws Exception {
        return this.invokeActionMethod(method, arg, this.getRequest(), this.getMapping());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionForward invokeActionMethod(Method method, ActionForm arg, HttpServletRequest request, ActionMapping mapping) throws Exception {
        Class<?>[] paramTypes = method.getParameterTypes();
        try {
            if (paramTypes.length > 0 && paramTypes[0].isInstance(arg)) {
                if (debug.isOn()) {
                    debug.out("Invoking action method " + method.getName() + "(" + paramTypes[0].getName() + ")");
                }
                ActionForward actionForward = (ActionForward)method.invoke((Object)this, arg);
                return actionForward;
            }
            if (paramTypes.length == 0) {
                if (debug.isOn()) {
                    debug.out("Invoking action method " + method.getName() + "()");
                }
                ActionForward actionForward = (ActionForward)method.invoke((Object)this, null);
                return actionForward;
            }
        }
        finally {
            boolean readonly = false;
            if (mapping instanceof PageFlowActionMapping) {
                PageFlowActionMapping pfam = (PageFlowActionMapping)mapping;
                readonly = pfam.isReadonly();
            }
            if (!readonly) {
                this.ensureFailover(this.getRequest());
            }
        }
        if (debug.isOn()) {
            debug.out("Could not find action method " + method.getName() + " with appropriate signature.");
        }
        if (logger.isWarnEnabled()) {
            StringBuffer msg = new StringBuffer("Could not find action method ");
            msg.append(method.getName()).append(" with appropriate signature.");
            logger.warn((Object)msg.toString());
        }
        return null;
    }

    private Method lookupMethod(String methodName, Class[] signature) {
        try {
            return this.getClass().getDeclaredMethod(methodName, signature);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected Method getExceptionHandlerMethod(String methodName, Throwable ex, ActionForm form) {
        String cacheKey = methodName + '/' + ex.getClass().getName();
        Map cache = this.getCache(_exceptionHandlerMethodCache);
        Method method = (Method)cache.get(cacheKey);
        if (method != null) {
            return method;
        }
        Class<?> exClass = ex.getClass();
        while (exClass != null) {
            Class[] args;
            Method foundMethod = null;
            if (form == null || form instanceof FormData) {
                args = new Class[]{exClass, class$java$lang$String == null ? FlowController.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? FlowController.class$("java.lang.String") : class$java$lang$String, class$com$bea$wlw$netui$pageflow$FormData == null ? FlowController.class$("com.bea.wlw.netui.pageflow.FormData") : class$com$bea$wlw$netui$pageflow$FormData};
                foundMethod = this.lookupMethod(methodName, args);
            }
            if (foundMethod == null) {
                args = new Class[]{exClass, class$java$lang$String == null ? FlowController.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? FlowController.class$("java.lang.String") : class$java$lang$String, class$org$apache$struts$action$ActionForm == null ? FlowController.class$("org.apache.struts.action.ActionForm") : class$org$apache$struts$action$ActionForm};
                foundMethod = this.lookupMethod(methodName, args);
            }
            if (foundMethod != null) {
                if (debug.isOn()) {
                    debug.out("Found exception handler for " + exClass.getName());
                }
                foundMethod.setAccessible(true);
                cache.put(cacheKey, foundMethod);
                return foundMethod;
            }
            if (debug.isOn()) {
                debug.out("Could not find exception handler method " + methodName + " for " + exClass.getName());
            }
            if (logger.isWarnEnabled()) {
                StringBuffer msg = new StringBuffer("Could not find exception handler method ");
                msg.append(methodName).append(" for ").append(exClass.getName()).append('.');
                logger.warn((Object)msg.toString());
            }
            exClass = exClass.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionForward invokeExceptionHandlerMethod(Method method, Throwable ex, String actionName, String message, ActionForm form, ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, ModuleConfig altModuleConfig, ServletContext servletContext, boolean readonly) throws Exception {
        if (debug.isOn()) {
            debug.out("Invoking exception handler method " + method.getName() + "(" + method.getParameterTypes()[0].getName() + ", ...)");
        }
        try {
            ActionForward retVal = null;
            try {
                retVal = (ActionForward)method.invoke((Object)this, ex, actionName, message, form);
                Object var14_14 = null;
                if (!readonly) {
                    this.ensureFailover(request);
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (!readonly) {
                    this.ensureFailover(request);
                }
                throw throwable;
            }
            return this.forwardTo(retVal, mapping, request, response, actionName, altModuleConfig, form, servletContext);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            throw e;
        }
    }

    protected final HttpServletRequest getRequest() {
        if (this._request == null) {
            String message = "getRequest was called outside of a valid context.";
            LocalizedIllegalStateException ex = new LocalizedIllegalStateException(message);
            ex.setLocalizedMessage(Bundle.getString((String)"PageFlow_IllegalStateGet", (Object)"getRequest"));
            throw ex;
        }
        return this._request;
    }

    protected final HttpServletResponse getResponse() {
        if (this._response == null) {
            String message = "getResponse was called outside of a valid context.";
            LocalizedIllegalStateException ex = new LocalizedIllegalStateException(message);
            ex.setLocalizedMessage(Bundle.getString((String)"PageFlow_IllegalStateGet", (Object)"getResponse"));
            throw ex;
        }
        return this._response;
    }

    protected final ActionMapping getMapping() {
        if (this._mapping == null) {
            String message = "getMapping was called outside of a valid context.";
            LocalizedIllegalStateException ex = new LocalizedIllegalStateException(message);
            ex.setLocalizedMessage(Bundle.getString((String)"PageFlow_IllegalStateGet", (Object)"getMapping"));
            throw ex;
        }
        return this._mapping;
    }

    protected final HttpSession getSession() {
        if (this._request == null) {
            if (this._session != null) {
                return this._session;
            }
            String message = "getSession was called outside of a valid context.";
            LocalizedIllegalStateException ex = new LocalizedIllegalStateException(message);
            ex.setLocalizedMessage(Bundle.getString((String)"PageFlow_IllegalStateGet", (Object)"getSession"));
            throw ex;
        }
        return this._request.getSession(true);
    }

    void setRequestMembers(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && response == null) {
            throw new AssertionError();
        }
        this._request = request;
        this._response = response;
        this._mapping = mapping;
    }

    void nullRequestMembers(HttpServletRequest request) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (request == this._request) {
            this._request = null;
            this._response = null;
            this._mapping = null;
        }
    }

    private final ModuleConfig getModuleConfig(HttpServletRequest request) {
        if (this._moduleConfig != null) {
            return this._moduleConfig;
        }
        return this.getModuleConfig(this.getServlet().getServletContext(), request);
    }

    public ModuleConfig getModuleConfig(ServletContext context, HttpServletRequest request) {
        if (this._moduleConfig == null) {
            ActionServlet actionServlet;
            this._moduleConfig = PageFlowUtils.getModuleConfig(this.getModulePath(), context);
            if (this._moduleConfig == null && !PageFlowUtils.isOSCaseSensitive() && request != null) {
                this._moduleConfig = PageFlowUtils.getModuleConfig(PageFlowUtils.getModulePath(request), context);
            }
            if (this._moduleConfig == null && (actionServlet = PageFlowUtils.getActionServlet(context)) instanceof AutoRegisterActionServlet) {
                try {
                    AutoRegisterActionServlet servlet = (AutoRegisterActionServlet)actionServlet;
                    this._moduleConfig = servlet.ensureModuleRegistered(this.getModulePath(), (ServletRequest)request);
                }
                catch (Exception e) {
                    logger.error((Object)("Error while registering module " + this.getModulePath()), (Throwable)e);
                }
            }
            if (!$assertionsDisabled && this._moduleConfig == null) {
                throw new AssertionError((Object)(this.getModulePath() + "; " + this.getClass().getName()));
            }
        }
        return this._moduleConfig;
    }

    public ActionResult lookup(String actionName, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return PageFlowUtils.strutsLookup(context, (ServletRequest)request, response, actionName, null);
    }

    public ActionResult lookup(String actionName, ServletContext context, HttpServletRequest request, HttpServletResponse response, String actionServletClassName) throws Exception {
        return this.lookup(actionName, context, request, response);
    }

    public String resolveAction(String actionName, ActionForm form) throws Exception {
        ActionMapping mapping = (ActionMapping)this.getModuleConfig(this.getRequest()).findActionConfig("/" + actionName);
        if (mapping == null) {
            throw new ActionNotFoundException(actionName, this, form);
        }
        ActionForward fwd = this.getActionMethodForward(actionName, form, this.getRequest(), this.getResponse(), mapping);
        if (fwd instanceof Forward) {
            ((Forward)fwd).initialize(mapping, this);
        }
        String path = fwd.getPath();
        if (fwd.getContextRelative() || PageFlowUtils.isAbsoluteURI(path)) {
            return path;
        }
        return this.getModulePath() + path;
    }

    public String[] getActions() {
        ActionConfig[] actionConfigs = this.getModuleConfig(this._request).findActionConfigs();
        ArrayList<String> actionNames = new ArrayList<String>();
        int i = 0;
        while (i < actionConfigs.length) {
            ActionConfig ac = actionConfigs[i];
            actionNames.add(ac.getPath().substring(1));
            ++i;
        }
        return actionNames.toArray(new String[0]);
    }

    public boolean isAction(String name) {
        return this.getModuleConfig(this._request).findActionConfig('/' + name) != null;
    }

    public boolean isPageFlow() {
        return false;
    }

    abstract void persistInSession(HttpServletRequest var1, HttpServletResponse var2, ServletContext var3);

    public abstract void ensureFailover(HttpServletRequest var1);

    public ActionServlet getServlet() {
        return this._transientActionServlet;
    }

    public void setServlet(ActionServlet servlet) {
        this._transientActionServlet = servlet;
    }

    public final synchronized void refresh(HttpServletRequest request, HttpServletResponse response) {
        this.setRequestMembers(request, response, null);
        this.onRefresh();
        this.nullRequestMembers(request);
    }

    protected void onRefresh() {
    }

    public abstract String getDisplayName();

    void savePreviousActionInfo(ActionForm form, HttpServletRequest request, ActionMapping mapping, ServletContext servletContext) {
    }

    void savePreviousPageInfo(ActionForward forward, ActionForm form, ActionMapping mapping, HttpServletRequest request, ServletContext servletContext, boolean isSpecialForward) {
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.destroy(event.getSession());
    }

    protected boolean isNestable() {
        return false;
    }

    protected boolean alwaysTrackPreviousAction() {
        return false;
    }

    protected boolean alwaysTrackPreviousPage() {
        return false;
    }

    boolean incrementRequestCount(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException {
        if (_maxConcurrentRequestCount == -1) {
            _maxConcurrentRequestCount = 4;
            String countStr = servletContext.getInitParameter(MAX_CONCURRENT_REQUESTS_PARAM);
            if (countStr != null) {
                try {
                    _maxConcurrentRequestCount = Integer.parseInt(countStr);
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("Invalid value for servlet context parameterpageflow-max-concurrent-requests: " + countStr), (Throwable)e);
                }
                if (_maxConcurrentRequestCount < 1) {
                    _maxConcurrentRequestCount = 4;
                    logger.error((Object)("Invalid value for servlet context parameterpageflow-max-concurrent-requests: " + countStr));
                }
            }
        }
        if (this._requestCount >= _maxConcurrentRequestCount) {
            if (debug.isOn()) {
                debug.out("Too many requests to page flow " + this.getClass().getName() + " (" + (this._requestCount + 1) + ">" + _maxConcurrentRequestCount + "); returning error code " + 503);
            }
            response.sendError(503);
            return false;
        }
        ++this._requestCount;
        return true;
    }

    void decrementRequestCount(HttpServletRequest request) {
        if (!$assertionsDisabled && this._requestCount <= 0) {
            throw new AssertionError((Object)request.getRequestURI());
        }
        --this._requestCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$pageflow$FlowController == null ? (class$com$bea$wlw$netui$pageflow$FlowController = FlowController.class$("com.bea.wlw.netui.pageflow.FlowController")) : class$com$bea$wlw$netui$pageflow$FlowController).desiredAssertionStatus();
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$pageflow$FlowController == null ? (class$com$bea$wlw$netui$pageflow$FlowController = FlowController.class$("com.bea.wlw.netui.pageflow.FlowController")) : class$com$bea$wlw$netui$pageflow$FlowController));
        logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$FlowController == null ? (class$com$bea$wlw$netui$pageflow$FlowController = FlowController.class$("com.bea.wlw.netui.pageflow.FlowController")) : class$com$bea$wlw$netui$pageflow$FlowController));
        RETURNING_FORM_ATTR_NAME = (class$com$bea$wlw$netui$pageflow$FlowController == null ? (class$com$bea$wlw$netui$pageflow$FlowController = FlowController.class$("com.bea.wlw.netui.pageflow.FlowController")) : class$com$bea$wlw$netui$pageflow$FlowController).getName() + "_returningForm";
        RETURNING_FROM_NESTING_ATTR_NAME = (class$com$bea$wlw$netui$pageflow$FlowController == null ? (class$com$bea$wlw$netui$pageflow$FlowController = FlowController.class$("com.bea.wlw.netui.pageflow.FlowController")) : class$com$bea$wlw$netui$pageflow$FlowController).getName() + "_nestedReturning";
        ONCREATE_EXCEPTION_FORWARD = (class$com$bea$wlw$netui$pageflow$FlowController == null ? (class$com$bea$wlw$netui$pageflow$FlowController = FlowController.class$("com.bea.wlw.netui.pageflow.FlowController")) : class$com$bea$wlw$netui$pageflow$FlowController).getName() + "_onCreateException";
        _maxConcurrentRequestCount = -1;
        _actionMethodCache = new ConcurrentReaderHashMap();
        _exceptionHandlerMethodCache = new ConcurrentReaderHashMap();
    }
}

