/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.misc.barcode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.controlhaus.misc.barcode.Contract;

public class BarcodeStrategy {
    private static final Map all = new HashMap();
    public static final BarcodeStrategy CODE_39 = new BarcodeStrategy("code39");
    public static final BarcodeStrategy EXTENDED_CODE_39 = new BarcodeStrategy("extendedcode39");
    public static final BarcodeStrategy CODABAR = new BarcodeStrategy("codabar");
    public static final BarcodeStrategy CODE_128 = new BarcodeStrategy("code128");
    public static final BarcodeStrategy INTERLEAVED_25 = new BarcodeStrategy("interleaved25");
    public static final BarcodeStrategy MSI = new BarcodeStrategy("msi");
    private final String code;

    private BarcodeStrategy(String code) {
        this.code = code.toUpperCase();
        all.put(this.code, this);
    }

    public static final BarcodeStrategy forCode(String code) {
        Contract.enforce(code != null && code.length() > 0, "code");
        return (BarcodeStrategy)all.get(code.toUpperCase());
    }

    public static final Collection getStrategyIds() {
        return all.keySet();
    }
}

