/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.xscript;

import XMLRuntime.XML;
import com.bea.wlw.netui.script.Expression;
import com.bea.wlw.netui.script.ExpressionEngineFactory;
import com.bea.wlw.netui.script.ExpressionEvaluationException;
import com.bea.wlw.netui.script.ExpressionEvaluator;
import com.bea.wlw.netui.script.ExpressionUpdateException;
import com.bea.wlw.netui.script.IllegalExpressionException;
import com.bea.wlw.netui.script.xscript.AttributeParser;
import com.bea.wlw.netui.script.xscript.ContextHelper;
import com.bea.wlw.netui.script.xscript.ContextResolver;
import com.bea.wlw.netui.script.xscript.ExpressionUpdateHelper;
import com.bea.wlw.netui.script.xscript.IllegalContextStateException;
import com.bea.wlw.netui.script.xscript.Util;
import com.bea.wlw.netui.script.xscript.context.WebScriptableObject;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import knex.scripting.javascript.Context;
import knex.scripting.javascript.NativeJavaObject;
import knex.scripting.javascript.Scriptable;
import knex.scripting.javascript.Undefined;

public class XScriptEvaluator
implements ExpressionEvaluator {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$XScriptEvaluator == null ? (class$com$bea$wlw$netui$script$xscript$XScriptEvaluator = XScriptEvaluator.class$("com.bea.wlw.netui.script.xscript.XScriptEvaluator")) : class$com$bea$wlw$netui$script$xscript$XScriptEvaluator));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$XScriptEvaluator == null ? (class$com$bea$wlw$netui$script$xscript$XScriptEvaluator = XScriptEvaluator.class$("com.bea.wlw.netui.script.xscript.XScriptEvaluator")) : class$com$bea$wlw$netui$script$xscript$XScriptEvaluator));
    private static final String NETUI_SCOPE_KEY = "netui_script_scope_key";
    private static final int OPTIMIZATION_LEVEL = -1;
    static /* synthetic */ Class class$com$bea$wlw$netui$script$xscript$XScriptEvaluator;
    static /* synthetic */ Class class$java$lang$String;

    public String changeContext(String expression, String oldToken, String newToken, int lookupIndex) throws ExpressionEvaluationException {
        try {
            return AttributeParser.changeContext(expression, oldToken, newToken, lookupIndex);
        }
        catch (Exception e) {
            String msg = "Error when trying to replace old token '" + oldToken + "' with new token '" + newToken + "' and index '" + lookupIndex + "': " + Util.getRootCause(e).toString();
            logger.info((Object)msg, (Throwable)e);
            ExpressionEvaluationException eee = new ExpressionEvaluationException(msg, expression, (Throwable)e);
            eee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_changeContextError", (Object[])new Object[]{oldToken, newToken, new Integer(lookupIndex), Util.getLocalizedRootCauseMessage(e)}));
            throw eee;
        }
    }

    public String qualify(String contextName, String expr) throws ExpressionEvaluationException {
        try {
            String newExpr = AttributeParser.qualify(contextName, expr);
            if (!this.isExpression(newExpr)) {
                IllegalExpressionException iee = new IllegalExpressionException("The expression \"" + expr + "\" can not be qualified with the context \"" + contextName + "\" because it would create an invalid expression.", expr);
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_illegalQualifiedExpression"));
                throw iee;
            }
            return newExpr;
        }
        catch (Exception e) {
            String msg = "Error when trying to create an expression in the namespace '" + contextName + "' with the text '" + expr + "'.  Root exception cause: " + Util.getRootCause(e).toString();
            logger.info((Object)msg, (Throwable)e);
            ExpressionEvaluationException eee = new ExpressionEvaluationException(msg, expr, (Throwable)e);
            eee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_qualifyError", (Object[])new Object[]{contextName, expr, Util.getLocalizedRootCauseMessage(e)}));
            throw eee;
        }
    }

    public boolean isExpression(String expression) {
        try {
            AttributeParser.ParsedAttribute pa = this.parseAttribute(expression, true);
            return pa.isExpression();
        }
        catch (IllegalExpressionException iee) {
            logger.info((Object)("The expression \"" + expression + "\" is illegal because: " + iee.toString()), (Throwable)iee);
            throw iee;
        }
        catch (Exception e) {
            logger.info((Object)("Exception checking for an expression in '" + expression + "'"), (Throwable)e);
            if (XScriptEvaluator.debug.ON) {
                debug.out(Util.exceptionToString(e, true));
            }
            return false;
        }
    }

    public boolean containsExpression(String expression) {
        try {
            AttributeParser.ParsedAttribute pa = this.parseAttribute(expression, true);
            return pa.containsExpression();
        }
        catch (Exception e) {
            logger.info((Object)("Exception checking for expressions in '" + expression + "'"), (Throwable)e);
            if (XScriptEvaluator.debug.ON) {
                debug.out(Util.exceptionToString(e, true));
            }
            return false;
        }
    }

    public Object evaluateStrict(String expression, Map contextMap) throws ExpressionEvaluationException {
        return this.evaluateInternal(expression, contextMap, true);
    }

    public Expression parseExpression(String expression) {
        if (this.isExpression(expression)) {
            AttributeParser.ParsedAttribute pa = AttributeParser.parse(expression, true);
            return pa.getAtomicExpressionTerm();
        }
        throw new IllegalExpressionException("The expression \"" + expression + "\" can not be parsed as it is not an atomic expression.");
    }

    private Object evaluate(String expression, Map contextMap) throws ExpressionEvaluationException {
        return this.evaluateInternal(expression, contextMap, false);
    }

    private Object evaluateInternal(String expression, Map contextMap, boolean strictParsing) throws ExpressionEvaluationException {
        if (XScriptEvaluator.debug.ON) {
            debug.out("expression=\"" + expression + "\" strictParsing: " + strictParsing);
        }
        if (expression == null) {
            return null;
        }
        if (expression.equals("")) {
            return null;
        }
        try {
            AttributeParser.ParsedAttribute pa = this.parseAttribute(expression, strictParsing);
            List terms = pa.getTerms();
            if (XScriptEvaluator.debug.ON) {
                AttributeParser.printParsedExpression(pa);
            }
            if (pa.isExpression()) {
                AttributeParser.ExprTerm term = pa.getAtomicExpressionTerm();
                Object obj = XScriptEvaluator.execRead(term, contextMap);
                obj = XScriptEvaluator.unwrapResult(expression, obj);
                return obj;
            }
            if (terms == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            AttributeParser.AttrTerm t = null;
            int i = 0;
            while (i < terms.size()) {
                t = (AttributeParser.AttrTerm)terms.get(i);
                if (t.getType() == 0) {
                    if (XScriptEvaluator.debug.ON) {
                        debug.out("LITERAL: " + t.toString());
                    }
                    buf.append(t.toString());
                } else if (t.getType() == 1) {
                    if (XScriptEvaluator.debug.ON) {
                        debug.out("EXPR: " + t.toString());
                    }
                    Object obj = XScriptEvaluator.execRead((AttributeParser.ExprTerm)t, contextMap);
                    if ((obj = XScriptEvaluator.unwrapResult(expression, obj)) != null) {
                        buf.append(obj.toString());
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        catch (Exception e) {
            String[] contexts = Util.getAvailableContextNames(contextMap);
            String contextsStr = Util.getAvailableContextNamesString(contextMap);
            String msg = "Caught exception when evaluating expression '" + expression + "' with available binding contexts " + contextsStr + ". Root exception cause: " + Util.getRootCause(e).toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)msg, (Throwable)e);
            }
            if (XScriptEvaluator.debug.ON) {
                debug.out(Util.exceptionToString(e, true));
            }
            ExpressionEvaluationException eee = new ExpressionEvaluationException(msg, expression, (Throwable)e);
            eee.setAvailableContexts(contexts);
            eee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_evaluateError", (Object[])new Object[]{expression, contextsStr, Util.getLocalizedRootCauseMessage(e)}));
            throw eee;
        }
    }

    public void update(String expression, Object value, Map contextMap, boolean requestParameter) throws ExpressionUpdateException {
        AttributeParser.ParsedAttribute pa;
        if (!this.isExpression(expression)) {
            String msg = "The expression \"" + expression + "\" can not be updated because it is not atomic.";
            ExpressionUpdateException eue = new ExpressionUpdateException(msg, expression);
            eue.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_nonAtomicUpdateExpression", (Object[])new Object[]{expression}));
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg);
            }
            throw eue;
        }
        if (XScriptEvaluator.debug.ON) {
            debug.out("======================= Start update");
            debug.here();
            debug.out("\n\texpression: " + expression);
        }
        if (!(pa = this.parseAttribute(expression, true)).isExpression()) {
            return;
        }
        try {
            Object s;
            ContextResolver contextR;
            AttributeParser.ExprTerm expr = pa.getAtomicExpressionTerm();
            if (expr.getExpression() == null || expr.getExpression().equals("")) {
                IllegalExpressionException iee = new IllegalExpressionException("An empty expression can not be used to update a value.");
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_emptyExpression"));
            }
            if (!(contextR = XScriptEvaluator.getContextResolver(expr)).isWritable()) {
                IllegalExpressionException iee = new IllegalExpressionException("Attempt to update a read-only databinding context named \"" + expr.getContext() + "\".");
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_updateReadOnlyContextError", (Object[])new Object[]{expr.getContext()}));
                throw iee;
            }
            if (requestParameter && !contextR.isRequestWritable()) {
                IllegalExpressionException iee = new IllegalExpressionException("Attempt to update a databinding context named \"" + expr.getContext() + "\" that cannot be written by a request paramter.");
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_requestUpdateError", (Object[])new Object[]{expr.getContext()}));
                throw iee;
            }
            if (expr.isXMLExpression()) {
                Class type = class$java$lang$String == null ? (class$java$lang$String = XScriptEvaluator.class$("java.lang.String")) : class$java$lang$String;
                expr = ExpressionUpdateHelper.generateUpdateExpression(expr, value, type);
                XScriptEvaluator.execUpdate(expr, contextMap, contextR);
                return;
            }
            AttributeParser.ExprTerm branch = expr.getBranchExpression();
            Object leaf = expr.getLeafIdentifier();
            if (XScriptEvaluator.debug.ON) {
                debug.out("branch expr: " + branch.getExpression() + " leaf expr: " + leaf + " leaf type: " + leaf.getClass());
            }
            if ((s = XScriptEvaluator.execUpdate(branch, contextMap, contextR)) == Scriptable.NOT_FOUND) {
                IllegalExpressionException iee = new IllegalExpressionException("Could not update the value from the expression \"" + expression + "\"; the " + "object on which to set the value could not be found");
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_objectNotFoundError", (Object[])new Object[]{expression}));
                throw iee;
            }
            if (s instanceof WebScriptableObject) {
                if (leaf instanceof Integer) {
                    ((Scriptable)s).put(((Integer)leaf).intValue(), (Scriptable)s, value);
                } else {
                    ((Scriptable)s).put((String)leaf, (Scriptable)s, value);
                }
                return;
            }
            if (s instanceof XML) {
                ((Scriptable)s).put((String)leaf, (Scriptable)s, value);
            } else {
                Object o = XScriptEvaluator.unwrapResult(expression, s);
                ExpressionUpdateHelper.setProperty(expression, o, leaf, value);
            }
        }
        catch (Exception e) {
            String[] contexts = Util.getAvailableContextNames(contextMap);
            String contextsStr = Util.getAvailableContextNamesString(contextMap);
            String msg = "Exception when attempting to update the expression '" + expression + "' with the available contexts " + contextsStr + ".  Root exception cause: " + Util.getRootCause(e).toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)msg, (Throwable)e);
            }
            if (XScriptEvaluator.debug.ON) {
                debug.out(Util.exceptionToString(e, true));
            }
            ExpressionUpdateException eue = new ExpressionUpdateException(msg, expression, (Throwable)e);
            eue.setAvailableContexts(contexts);
            eue.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_updateError", (Object[])new Object[]{expression, value != null ? value.getClass().getName() : "null", contextsStr, Util.getLocalizedRootCauseMessage(e)}));
            throw eue;
        }
    }

    public final void enter() {
    }

    public final void exit() {
        if (Context.getCurrentContext() != null) {
            Context.exit();
        }
    }

    static final Object execRead(AttributeParser.ExprTerm expr, Map contexts) throws Exception {
        if (expr.getExpression() == null || expr.getExpression().equals("")) {
            return null;
        }
        ContextResolver cr = XScriptEvaluator.getContextResolver(expr);
        Object o = XScriptEvaluator.execScript(expr, contexts, cr);
        cr.afterRead(expr.getExpression(), contexts);
        return o;
    }

    static final Object execUpdate(AttributeParser.ExprTerm expr, Map contexts, ContextResolver contextResolver) throws Exception {
        Object o = XScriptEvaluator.execScript(expr, contexts, contextResolver);
        contextResolver.afterUpdate(expr.getExpression(), contexts);
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final Object execScript(AttributeParser.ExprTerm expr, Map contexts, ContextResolver contextResolver) throws Exception {
        if (XScriptEvaluator.debug.ON) {
            debug.here();
            debug.out("======================= Start evaluation '" + expr.getExpression() + "'");
        }
        Object result = null;
        try {
            try {
                String expression = expr.getExpression();
                Scriptable scope = null;
                ServletRequest request = (ServletRequest)contexts.get("request");
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = Context.enter();
                    cx.setOptimizationLevel(-1);
                    scope = cx.initStandardObjects(null);
                    request.setAttribute(NETUI_SCOPE_KEY, (Object)scope);
                }
                if ((scope = (Scriptable)request.getAttribute(NETUI_SCOPE_KEY)) == null) {
                    scope = cx.initStandardObjects(null);
                }
                contextResolver.resolve(scope, expression, contexts);
                result = cx.evaluateString(scope, expression, "<cmd>", 1, null);
            }
            catch (Exception e) {
                logger.info((Object)("Exception evaluating expression \"" + expr.getExpression() + "\" with contexts: " + Util.getAvailableContextNamesString(contexts)), (Throwable)e);
                throw e;
            }
            Object var9_9 = null;
            if (!XScriptEvaluator.debug.ON) return result;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!XScriptEvaluator.debug.ON) throw throwable;
            debug.out("======================= End evaluation");
            throw throwable;
        }
        debug.out("======================= End evaluation");
        return result;
    }

    static final Object unwrapResult(String expression, Object result) {
        Object o = null;
        if (result instanceof NativeJavaObject) {
            o = ((NativeJavaObject)result).unwrap();
        } else if (result instanceof WebScriptableObject) {
            o = ((WebScriptableObject)result).unwrap();
        } else {
            if (result instanceof Undefined) {
                logger.info((Object)("The expression \"" + expression + "\" returned an undefined result and may not be valid."));
                if (XScriptEvaluator.debug.ON) {
                    debug.out("The expression \"" + expression + "\" returned an undefined result and may not be valid.");
                }
                return null;
            }
            o = result;
        }
        if (XScriptEvaluator.debug.ON) {
            debug.out("returning unwrapped result of type: " + (o == null ? "null" : o.getClass().getName()));
        }
        return o;
    }

    private static final ContextResolver getContextResolver(AttributeParser.ExprTerm exprTerm) {
        ContextResolver cr = ContextHelper.initializeScope(exprTerm);
        if (cr == null) {
            logger.info((Object)("The context \"" + exprTerm.getContext() + "\" could not be found"));
            IllegalContextStateException ice = new IllegalContextStateException("The context \"" + exprTerm.getContext() + "\" could not be found.");
            ice.setLocalizedMessage(Bundle.getErrorString((String)"XScript_XScriptEvaluator_noContextResolver", (Object[])new Object[]{exprTerm.getContext()}));
            throw ice;
        }
        return cr;
    }

    private final AttributeParser.ParsedAttribute parseAttribute(String expression, boolean strictParsing) {
        return AttributeParser.parse(expression, strictParsing);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class XScriptEngineFactory
    extends ExpressionEngineFactory {
        public ExpressionEvaluator getInstance() {
            return new XScriptEvaluator();
        }
    }
}

