/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.xscript;

import com.bea.wlw.netui.script.ExpressionUpdateException;
import com.bea.wlw.netui.script.IllegalExpressionException;
import com.bea.wlw.netui.script.xscript.AttributeParser;
import com.bea.wlw.netui.script.xscript.IllegalXScriptArgumentException;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.cache.PropertyCache;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.exception.LocalizedIllegalArgumentException;
import com.bea.wlw.netui.util.exception.LocalizedIllegalStateException;
import com.bea.wlw.netui.util.logging.Logger;
import com.bea.wlw.netui.util.type.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

final class ExpressionUpdateHelper {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$ExpressionUpdateHelper == null ? (class$com$bea$wlw$netui$script$xscript$ExpressionUpdateHelper = ExpressionUpdateHelper.class$("com.bea.wlw.netui.script.xscript.ExpressionUpdateHelper")) : class$com$bea$wlw$netui$script$xscript$ExpressionUpdateHelper));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$xscript$ExpressionUpdateHelper == null ? (class$com$bea$wlw$netui$script$xscript$ExpressionUpdateHelper = ExpressionUpdateHelper.class$("com.bea.wlw.netui.script.xscript.ExpressionUpdateHelper")) : class$com$bea$wlw$netui$script$xscript$ExpressionUpdateHelper));
    private static final PropertyCache cache = new PropertyCache();
    static /* synthetic */ Class class$com$bea$wlw$netui$script$xscript$ExpressionUpdateHelper;
    static /* synthetic */ Class class$java$util$List;

    ExpressionUpdateHelper() {
    }

    static final AttributeParser.ExprTerm generateUpdateExpression(AttributeParser.ExprTerm term, Object value, Class type) {
        if (ExpressionUpdateHelper.debug.ON) {
            debug.out("expression attribute type: " + (type == null ? "null" : type.getName()) + "\n" + "expression: " + term.getExpression());
        }
        String root = term.getExpression();
        String rvalue = value != null ? value.toString() : "null";
        String updateExpr = root + "=" + rvalue;
        if (ExpressionUpdateHelper.debug.ON) {
            debug.out("updateExpr: " + updateExpr);
        }
        AttributeParser.ExprTerm newTerm = new AttributeParser.ExprTerm(updateExpr, true);
        return newTerm;
    }

    static Object convertType(String expression, Object value, Class type) {
        if (value != null && !(value instanceof String) && !(value instanceof String[])) {
            return value;
        }
        if (type.isArray()) {
            if (value == null) {
                return null;
            }
            Class<?> compType = type.getComponentType();
            String[] strs = null;
            strs = value.getClass().isArray() ? (String[])value : new String[]{(String)value};
            Object tgt = Array.newInstance(compType, strs.length);
            int i = 0;
            while (i < strs.length) {
                Object o = null;
                try {
                    o = TypeUtils.convertToObject((String)strs[i], compType);
                }
                catch (IllegalArgumentException iae) {
                    IllegalExpressionException iee = new IllegalExpressionException("Can not set Object types with XScript expressions that are not primitive type wrappers, java.lang.String, or java.lang.String[].  The current type is \"" + type.getName() + "\" with the expression \"" + expression + "\".", expression);
                    iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_illegalTypeUpdate", (Object[])new Object[]{type.getName(), expression, value != null ? value.getClass().getName() : "null type"}));
                    throw iee;
                }
                Array.set(tgt, i, o);
                ++i;
            }
            return tgt;
        }
        if (ExpressionUpdateHelper.debug.ON) {
            debug.out("convert value type: " + (value != null ? value.getClass().getName() : "null object") + " to type: " + type);
        }
        Object o = null;
        try {
            o = TypeUtils.convertToObject((String)((String)value), (Class)type);
        }
        catch (IllegalArgumentException iea) {
            IllegalExpressionException iee = new IllegalExpressionException("The type \"" + type.getName() + "\" can not be set through XScript.");
            iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_cantSetType", (Object[])new Object[]{type.getName()}));
            throw iee;
        }
        return o;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setProperty(String expression, Object javaObject, Object property, Object value) throws Exception {
        if (ExpressionUpdateHelper.debug.ON) {
            debug.out("expression: " + expression + " javaObject: " + javaObject + " property: " + property);
        }
        if (javaObject == null) {
            IllegalXScriptArgumentException ixa = new IllegalXScriptArgumentException("Can not update a property on an object that is null with expression \"" + expression + "\".");
            ixa.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_cantUpdatePropertyOnNullObject", (Object[])new Object[]{expression}));
            throw ixa;
        }
        if (property == null) {
            LocalizedIllegalArgumentException iae = new LocalizedIllegalArgumentException("Can not update a property with a null name from the expression \"" + expression + "\".");
            iae.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_nullPropertyName", (Object[])new Object[]{expression}));
            throw iae;
        }
        Class<?> javaObjectClass = javaObject.getClass();
        if (javaObjectClass.isArray()) {
            if (!(property instanceof Integer)) {
                LocalizedIllegalArgumentException iae = new LocalizedIllegalArgumentException("Can not put a value into an array with a key of type \"" + property.getClass() + "\"");
                iae.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_arrayKeyNotInteger", (Object[])new Object[]{property.getClass()}));
                throw iae;
            }
            int index = (Integer)property;
            Object converted = null;
            try {
                Class<?> comp = javaObjectClass.getComponentType();
                converted = !comp.isAssignableFrom(value.getClass()) ? ExpressionUpdateHelper.convertType(expression, value, comp) : value;
            }
            catch (Exception e) {
                IllegalExpressionException iee = new IllegalExpressionException("An error occurred evaluating the expression \"" + expression + "\".  " + "Unable to convert a value of type \"" + value.getClass() + "\" to the array element type of \"" + javaObjectClass.getComponentType() + "\".");
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_cantConvertType", (Object[])new Object[]{expression, value.getClass(), javaObjectClass.getComponentType()}));
                throw iee;
            }
            try {
                Array.set(javaObject, index, converted);
                return;
            }
            catch (Exception e) {
                String msg = "An error occurred setting a value at index \"" + index + "\" on an array with component types \"" + javaObjectClass.getComponentType() + "\" for expression \"" + expression + "\".  Cause: " + e.toString();
                logger.warn((Object)msg, (Throwable)e);
                IllegalExpressionException iee = new IllegalExpressionException(msg, (Throwable)e);
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_arrayUpdateException", (Object[])new Object[]{new Integer(index), javaObjectClass.getComponentType(), expression, e.toString()}));
                throw iee;
            }
        }
        if (javaObject instanceof List) {
            if (!(property instanceof Integer)) {
                LocalizedIllegalArgumentException iae = new LocalizedIllegalArgumentException("Can not put a value into a List with a key of type \"" + property.getClass() + "\"");
                iae.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_listKeyNotInteger", (Object[])new Object[]{property.getClass()}));
                throw iae;
            }
            List list = (List)javaObject;
            int index = (Integer)property;
            if (list.size() <= index) {
                String msg = "An error occurred setting a value at index \"" + index + "\" because the list is of size " + list.size() + ". " + "Be sure to allocate enough items in the List to accomodate any updates which may occur against the list.";
                IllegalExpressionException iee = new IllegalExpressionException(msg, expression);
                iee.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_listTooSmall", (Object[])new Object[]{new Integer(index), new Integer(list.size())}));
                if (!logger.isErrorEnabled()) throw iee;
                logger.error((Object)msg);
                throw iee;
            }
            Object o = list.get(index);
            if (o != null) {
                Class<?> targetType = o.getClass();
                value = ExpressionUpdateHelper.convertType(expression, value, targetType);
            }
            list.set(index, value);
            return;
        }
        if (javaObject instanceof Map) {
            Map m = (Map)javaObject;
            Object o = m.get(property);
            if (o != null) {
                Class<?> targetType = o.getClass();
                value = ExpressionUpdateHelper.convertType(expression, value, targetType);
            }
            m.put(property, value);
            return;
        }
        String propertyName = property.toString();
        Field f = ExpressionUpdateHelper.findField(javaObjectClass, propertyName);
        if (f != null) {
            Class<?> targetType;
            if ((class$java$util$List == null ? (class$java$util$List = ExpressionUpdateHelper.class$("java.util.List")) : class$java$util$List).isAssignableFrom(targetType = f.getType())) {
                List list = (List)f.get(javaObject);
                ExpressionUpdateHelper.applyValuesToList(expression, value, list);
                return;
            }
            Object converted = ExpressionUpdateHelper.convertType(expression, value, targetType);
            f.set(javaObject, converted);
            return;
        }
        Class propType = ExpressionUpdateHelper.findPropertyType(javaObjectClass, propertyName);
        if (propType != null) {
            Method m;
            if ((class$java$util$List == null ? (class$java$util$List = ExpressionUpdateHelper.class$("java.util.List")) : class$java$util$List).isAssignableFrom(propType)) {
                m = ExpressionUpdateHelper.findPropertyGetter(javaObjectClass, propertyName);
                if (m != null) {
                    List list = (List)m.invoke(javaObject, null);
                    ExpressionUpdateHelper.applyValuesToList(expression, value, list);
                    return;
                }
            } else {
                m = ExpressionUpdateHelper.findPropertySetter(javaObjectClass, propertyName);
                if (m != null) {
                    if (m.getParameterTypes().length != 1) {
                        String msg = "Error updating expression \"" + expression + "\".  The method \"" + m + "\" is not a JavaBean property setter, which requires a single argument";
                        ExpressionUpdateException eue = new ExpressionUpdateException(msg, null);
                        eue.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_illegalSetterArgCount", (Object[])new Object[]{msg, m}));
                        throw eue;
                    }
                    Class<?> targetType = m.getParameterTypes()[0];
                    Object converted = ExpressionUpdateHelper.convertType(expression, value, targetType);
                    if (ExpressionUpdateHelper.debug.ON) {
                        debug.out("targetType: " + targetType + " convertedType: " + (converted != null ? converted.getClass().getName() : "null object"));
                    }
                    m.invoke(javaObject, converted);
                    return;
                }
            }
        }
        String msg = "Could not update expression '" + expression + "' because a public field named \"" + propertyName + "\" or a setter for the property \"" + propertyName + "\" could not be found.";
        logger.warn((Object)msg);
        ExpressionUpdateException eue = new ExpressionUpdateException(msg, expression);
        eue.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_cantFindPropertySetter", (Object[])new Object[]{expression, value != null ? value.getClass().getName() : "null value", propertyName}));
        throw eue;
    }

    private static final Method findPropertySetter(Class type, String propertyName) {
        return cache.getPropertySetter(type, propertyName);
    }

    private static final Method findPropertyGetter(Class type, String propertyName) {
        return cache.getPropertyGetter(type, propertyName);
    }

    private static final Field findField(Class type, String fieldName) {
        return cache.getField(type, fieldName);
    }

    private static final Class findPropertyType(Class type, String fieldName) {
        return cache.getPropertyType(type, fieldName);
    }

    private static final void applyValuesToList(String expression, Object value, List list) {
        if (list == null) {
            LocalizedIllegalStateException ise = new LocalizedIllegalStateException("Can not add a field onto a null java.util.List");
            ise.setLocalizedMessage(Bundle.getErrorString((String)"XScript_ExpressionUpdateHelper_nullList"));
            throw ise;
        }
        if (value instanceof String[]) {
            String[] ary = (String[])value;
            int i = 0;
            while (i < ary.length) {
                list.add(ary[i]);
                ++i;
            }
        } else if (value instanceof String) {
            list.add(value);
        } else {
            list.add(value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

