/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.misc.barcode;

import com.bea.control.ControlException;
import com.bea.control.ControlSource;
import java.io.IOException;
import java.io.OutputStream;
import jbarcodebean.JBarcodeBean;
import org.controlhaus.misc.barcode.BarCode;
import org.controlhaus.misc.barcode.BarcodeStrategy;
import org.controlhaus.misc.barcode.Contract;
import org.controlhaus.misc.barcode.StrategyAdapter;

public class BarCodeImpl
implements BarCode,
ControlSource {
    static final long serialVersionUID = 1L;

    public void generateBarcode(String barCode, boolean showName, OutputStream output, BarcodeStrategy strategy) {
        Contract.enforce(barCode != null && barCode.length() > 0, "barCode");
        Contract.enforce(output != null, "output");
        Contract.enforce(strategy != null, "strategy");
        JBarcodeBean jBarcodeBean = new JBarcodeBean();
        jBarcodeBean.setCode(barCode);
        jBarcodeBean.setShowText(showName);
        jBarcodeBean.setCodeType(StrategyAdapter.adapt(strategy));
        try {
            jBarcodeBean.gifEncode(output);
            return;
        }
        catch (IOException ex) {
            throw new ControlException("IO Exception while rendering barcode image", (Throwable)ex);
        }
    }
}

