/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.iterator;

import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator {
    private static final Debug debug = Debug.getInstance(class$com$bea$wlw$netui$util$iterator$ArrayIterator == null ? (class$com$bea$wlw$netui$util$iterator$ArrayIterator = ArrayIterator.class$("com.bea.wlw.netui.util.iterator.ArrayIterator")) : class$com$bea$wlw$netui$util$iterator$ArrayIterator);
    private Object array;
    private int totalElements;
    private int currentElement;
    static /* synthetic */ Class class$com$bea$wlw$netui$util$iterator$ArrayIterator;

    public ArrayIterator(Object array) {
        if (array != null) {
            if (!array.getClass().isArray()) {
                throw new IllegalStateException(Bundle.getErrorString("ArrayIterator_notAnArray"));
            }
            this.array = array;
            this.totalElements = Array.getLength(array);
        }
    }

    public boolean hasNext() {
        if (this.array == null) {
            return false;
        }
        return this.currentElement < this.totalElements;
    }

    public Object next() {
        if (ArrayIterator.debug.ON) {
            debug.out("Current element: " + this.currentElement);
            debug.out("Total elements: " + this.totalElements);
        }
        if (this.currentElement >= this.totalElements) {
            throw new NoSuchElementException(Bundle.getErrorString("IteratorFactory_Iterator_noSuchElement"));
        }
        Object nextElement = null;
        try {
            nextElement = Array.get(this.array, this.currentElement);
        }
        catch (Exception e) {
            if (ArrayIterator.debug.ON) {
                debug.out("Caught exception: " + e.getClass().getName());
            }
            throw new NoSuchElementException(Bundle.getErrorString("ArrayIterator_arrayError", new Object[]{this.array.getClass().getName()}));
        }
        ++this.currentElement;
        return nextElement;
    }

    public void remove() {
        throw new UnsupportedOperationException(Bundle.getErrorString("IteratorFactory_Iterator_removeUnsupported", new Object[]{this.getClass().getName()}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

