/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.util.debug;

import com.bea.wlw.netui.util.debug.DebugUtil;
import com.bea.wlw.netui.util.debug.PrintDebugImpl;
import com.bea.wlw.netui.util.debug.SilentDebugImpl;
import java.util.HashMap;

public abstract class Debug {
    public final boolean ON;
    private static final Debug SILENT_DEBUG_INSTANCE = new SilentDebugImpl();
    private static Debug CONSOLE_DEBUG_INSTANCE = null;
    private static Debug LOGGER_DEBUG_INSTANCE = null;
    private static final boolean USE_PACKAGE_NAMES = DebugUtil.getPropertyAsBoolean("usePackageNames", false);
    private static final HashMap instanceMap = new HashMap();
    static /* synthetic */ Class class$com$bea$wlw$netui$util$debug$Debug;

    protected Debug(boolean isOn) {
        this.ON = isOn;
    }

    public final boolean isOn() {
        return this.ON;
    }

    public abstract void out(String var1);

    public abstract void out(Object var1);

    public abstract void out(String var1, Object var2);

    public abstract void out(Throwable var1);

    public abstract void out(String var1, Throwable var2);

    public final void outIfOn(String message) {
        if (this.ON) {
            this.out(message);
        }
    }

    public final void outIfOn(Object obj) {
        if (this.ON) {
            this.out(obj);
        }
    }

    public final void outIfOn(String message, Object obj) {
        if (this.ON) {
            this.out(message, obj);
        }
    }

    public final void outIfOn(Throwable throwable) {
        if (this.ON) {
            this.out(throwable);
        }
    }

    public final void outIfOn(String message, Throwable throwable) {
        if (this.ON) {
            this.out(message, throwable);
        }
    }

    public abstract void here();

    public static Debug getInstance(Class theClass) {
        return Debug.getInstance(theClass.getName());
    }

    public static Debug getInstance(String theName) {
        Debug instance = Debug.getInstanceForName(theName);
        if (instance != null) {
            return instance;
        }
        if (!USE_PACKAGE_NAMES) {
            return SILENT_DEBUG_INSTANCE;
        }
        String pkgName = Debug.packageName(theName);
        if (pkgName != null) {
            instance = (Debug)instanceMap.get(pkgName);
            if (instance != null) {
                return instance;
            }
            instance = Debug.getInstance(pkgName);
        } else {
            instance = SILENT_DEBUG_INSTANCE;
        }
        instanceMap.put(pkgName, instance);
        return instance;
    }

    private static String packageName(String theName) {
        int dot = theName.lastIndexOf(46);
        if (dot > 0) {
            return theName.substring(0, dot);
        }
        return null;
    }

    private static Debug getInstanceForName(String theName) {
        String property = DebugUtil.getProperty(theName);
        if (property == null) {
            return null;
        }
        if ("log".equalsIgnoreCase(property)) {
            return Debug.getLoggerDebug();
        }
        if (DebugUtil.getPropertyAsBoolean(theName, true)) {
            return Debug.getConsoleDebug();
        }
        return SILENT_DEBUG_INSTANCE;
    }

    private static synchronized Debug getConsoleDebug() {
        if (CONSOLE_DEBUG_INSTANCE == null) {
            CONSOLE_DEBUG_INSTANCE = new PrintDebugImpl(System.err);
        }
        return CONSOLE_DEBUG_INSTANCE;
    }

    private static synchronized Debug getLoggerDebug() {
        return Debug.getConsoleDebug();
    }

    public static void main(String[] args) {
        Debug debug = Debug.getInstance(class$com$bea$wlw$netui$util$debug$Debug == null ? (class$com$bea$wlw$netui$util$debug$Debug = Debug.class$("com.bea.wlw.netui.util.debug.Debug")) : class$com$bea$wlw$netui$util$debug$Debug);
        System.err.println(" Debug is on? " + debug.isOn());
        debug.out("Hello from main", debug);
        System.err.println();
        debug.here();
        System.err.println();
        int level = 0;
        if (args.length != 0) {
            level = Integer.parseInt(args[0]);
        }
        if (level != 0) {
            System.err.println("=========== " + level);
            Debug.main(new String[]{String.valueOf(--level)});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

