/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.exceptions;

import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.exceptions.CustomErrorException;
import company.tap.commondependencies.exceptions.ExistsException;
import company.tap.commondependencies.exceptions.FailedException;
import company.tap.commondependencies.exceptions.InActiveIdException;
import company.tap.commondependencies.exceptions.InvalidApiKeyException;
import company.tap.commondependencies.exceptions.InvalidDataException;
import company.tap.commondependencies.exceptions.InvalidIdException;
import company.tap.commondependencies.exceptions.InvalidSessionException;
import company.tap.commondependencies.exceptions.InvalidTokenException;
import company.tap.commondependencies.exceptions.NotFoundException;
import company.tap.commondependencies.exceptions.RequiredFieldsException;
import company.tap.commondependencies.exceptions.UnauthorizedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.client.HttpClientErrorException;

@ControllerAdvice
public class CustomExceptionHandler {
    private final Logger loggerObj = LogManager.getLogger(this.getClass());
    @Autowired
    private IErrorServices errorServices;

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<Object> handleRuntimeException(Exception ex) {
        ex.printStackTrace();
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Internal_server_error.getCode(), Errors.Internal_server_error.toString(), "Internal server error", HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleGenericException(Exception ex) {
        ex.printStackTrace();
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Internal_server_error.getCode(), Errors.Internal_server_error.toString(), "Something went wrong", HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpClientErrorException.class})
    public ResponseEntity<Object> handleHttpClientErrorException(HttpClientErrorException e) {
        this.loggerObj.error((Object)e);
        this.loggerObj.error((Object)e);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return new ResponseEntity((Object)e.getResponseBodyAsByteArray(), (MultiValueMap)httpHeaders, e.getStatusCode());
    }

    @ExceptionHandler(value={RequiredFieldsException.class})
    public ResponseEntity<Object> handleRequiredFieldsException(RequiredFieldsException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Required_fields_missing.getCode(), Errors.Required_fields_missing.toString(), ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidDataException.class})
    public ResponseEntity<Object> handleInvalidDataException(InvalidDataException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidIdException.class})
    public ResponseEntity<Object> handleInvalidIdException(InvalidIdException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Invalid_Id.getCode(), Errors.Invalid_Id.toString(), ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InActiveIdException.class})
    public ResponseEntity<Object> handleInActiveIdException(InActiveIdException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.InActive_Id.getCode(), Errors.InActive_Id.toString(), ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ExistsException.class})
    public ResponseEntity<Object> handleExistsException(ExistsException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Exists.getCode(), Errors.Exists.toString(), ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<Object> handleNotFoundException(NotFoundException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Not_Found.getCode(), Errors.Not_Found.toString(), ex.getMessage(), HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidApiKeyException.class})
    public ResponseEntity<Object> handleInvalidApiKeyException(InvalidApiKeyException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(), ex.getMessage(), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={InvalidSessionException.class})
    public ResponseEntity<Object> handleInvalidSessionException(InvalidSessionException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Invalid_session.getCode(), Errors.Invalid_session.toString(), ex.getMessage(), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={InvalidTokenException.class})
    public ResponseEntity<Object> handleInvalidTokenException(InvalidTokenException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Invalid_token.getCode(), Errors.Invalid_token.toString(), ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ResponseEntity<Object> handleUnauthorizedException(UnauthorizedException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Api_key_unauthorised.getCode(), Errors.Api_key_unauthorised.toString(), ex.getMessage(), HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={CustomErrorException.class})
    public ResponseEntity<Object> handleCustomErrorException(CustomErrorException ex) {
        ex.printStackTrace();
        this.loggerObj.error(ex.getMessage());
        return this.errorServices.Error(ex.getErrors().getCode(), ex.getErrors().toString(), ex.getMessage(), ex.getHttpStatus());
    }

    @ExceptionHandler(value={FailedException.class})
    public ResponseEntity<Object> handleFailedException(FailedException ex) {
        this.loggerObj.error((Object)ex);
        return this.errorServices.Error(Errors.Failed.getCode(), Errors.Failed.toString(), ex.getMessage(), HttpStatus.SERVICE_UNAVAILABLE);
    }
}

