/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.PaymentMethods;

import company.tap.commondependencies.ApiModels.ErrorSource;
import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.PaymentMethods.IPaymentMethodService;
import company.tap.commondependencies.PaymentMethods.PaymentMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
class PaymentMethodService
implements IPaymentMethodService {
    final IErrorServices _errorServices;

    public PaymentMethodService(IErrorServices _errorServices) {
        this._errorServices = _errorServices;
    }

    @Override
    public List<PaymentMethod> GetPaymentMethodList() {
        ArrayList<PaymentMethod> paymentMethodList = new ArrayList<PaymentMethod>();
        paymentMethodList.add(new PaymentMethod("KNET", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("VISA", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("MASTERCARD", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("DINERS_CLUB", "CARD", "Diners Club"));
        paymentMethodList.add(new PaymentMethod("JCB", "CARD", "Japan Credit Bureau"));
        paymentMethodList.add(new PaymentMethod("UNION_PAY", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("BENEFIT", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("MADA", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("SADAD_ACCOUNT", "WALLET", ""));
        paymentMethodList.add(new PaymentMethod("AMEX", "CARD", "American Express"));
        paymentMethodList.add(new PaymentMethod("NAPS", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("FAWRY", "CASH", ""));
        paymentMethodList.add(new PaymentMethod("DISCOVER", "CARD", "Discover"));
        paymentMethodList.add(new PaymentMethod("ENROUTE", "", ""));
        paymentMethodList.add(new PaymentMethod("TPAY", "WALLET", ""));
        paymentMethodList.add(new PaymentMethod("OMANNET", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("STC_PAY", "WALLET", ""));
        paymentMethodList.add(new PaymentMethod("BCO", "WALLET", ""));
        paymentMethodList.add(new PaymentMethod("APPLE_PAY", "WALLET", "Apple Pay"));
        paymentMethodList.add(new PaymentMethod("QPAY", "CARD", ""));
        paymentMethodList.add(new PaymentMethod("CASH", "CASH", ""));
        paymentMethodList.add(new PaymentMethod("CHEQUE", "CHEQUE", ""));
        paymentMethodList.add(new PaymentMethod("BANK_TRANSFER", "BANK_TRANSFER", ""));
        paymentMethodList.add(new PaymentMethod("TABBY", "", ""));
        paymentMethodList.add(new PaymentMethod("BENEFITPAY", "WALLET", ""));
        paymentMethodList.add(new PaymentMethod("CHINA_UNIONPAY", "CARD", "China UnionPay"));
        paymentMethodList.add(new PaymentMethod("OTHER", "CARD", "The scheme of the card used in the transaction could not be identified"));
        paymentMethodList.add(new PaymentMethod("RUPAY", "CARD", "RuPay"));
        paymentMethodList.add(new PaymentMethod("UATP", "CARD", "Universal Air Travel Plan"));
        paymentMethodList.add(new PaymentMethod("AMEX_EXPRESS_CHECKOUT", "WALLET", "Amex Express Checkout wallet provider"));
        paymentMethodList.add(new PaymentMethod("ANDROID_PAY", "WALLET", "Android Pay mobile wallet provider"));
        paymentMethodList.add(new PaymentMethod("CHASE_PAY", "WALLET", "Chase Pay wallet provider"));
        paymentMethodList.add(new PaymentMethod("GOOGLE_PAY", "WALLET", "Google Pay mobile wallet provider"));
        paymentMethodList.add(new PaymentMethod("MASTERPASS_ONLINE", "WALLET", "MasterPass Online wallet provider"));
        paymentMethodList.add(new PaymentMethod("SAMSUNG_PAY", "WALLET", "Samsung Pay mobile wallet provider"));
        paymentMethodList.add(new PaymentMethod("VISA_CHECKOUT", "WALLET", "Visa Checkout wallet provider"));
        return paymentMethodList;
    }

    @Override
    public List<String> GetThreeDSecure() {
        ArrayList<String> ThreeDSecur = new ArrayList<String>();
        ThreeDSecur.add("AMEX_SAFE_KEY");
        ThreeDSecur.add("J_SECURE");
        ThreeDSecur.add("PROTECT_BUY");
        ThreeDSecur.add("SECURE_CODE");
        ThreeDSecur.add("VERIFIED_BY_VISA");
        return ThreeDSecur;
    }

    @Override
    public List<String> GetTransactionSources() {
        ArrayList<String> TransactionSources = new ArrayList<String>();
        TransactionSources.add("CALL_CENTRE");
        TransactionSources.add("CARD_PRESENT");
        TransactionSources.add("INTERNET");
        TransactionSources.add("MAIL_ORDER");
        TransactionSources.add("MERCHANT");
        TransactionSources.add("MOTO");
        TransactionSources.add("PAYER_PRESENT");
        TransactionSources.add("SERVICE_PROVIDER");
        TransactionSources.add("TELEPHONE_ORDER");
        TransactionSources.add("VOICE_RESPONSE");
        return TransactionSources;
    }

    @Override
    public List<String> GetPaymentMethods() {
        ArrayList<String> list = new ArrayList<String>();
        for (PaymentMethod p : this.GetPaymentMethodList()) {
            list.add(p.getName());
        }
        return list;
    }

    @Override
    public List<String> GetPaymentMethods(String type) {
        return this.GetPaymentMethodList().stream().filter(f -> f.getType().equalsIgnoreCase(type)).map(PaymentMethod::getName).collect(Collectors.toList());
    }

    @Override
    public ResponseEntity<Object> ValidatePaymentMethods(List<String> paymentMethods) {
        ErrorSource errorSource = new ErrorSource();
        ArrayList<String> list = new ArrayList<String>();
        for (String p : paymentMethods) {
            if (!this.GetPaymentMethodList().stream().noneMatch(m -> m.getName().equalsIgnoreCase(p))) continue;
            list.add(p);
        }
        if (list.size() == 0) {
            return null;
        }
        errorSource.invalid_data = list;
        return this._errorServices.Errors(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Invalid Payment method", errorSource, HttpStatus.BAD_REQUEST);
    }
}

