/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Mada.StandardCodes;

public enum FunctionCode {
    OriginalAuthorizationAmountAccurate(100, "Original authorization \u2013 amount accurate"),
    OriginalAuthorizationAmountEstimated(101, "Original authorization \u2013 amount estimated"),
    NotificationAuthorizationOrPreAuthorization(181, "Notification of an authorization or pre-authorization"),
    NotificationPreAuthorizationInitialCompletion(182, "Notification of a pre-authorization initial completion"),
    NotificationPreAuthorizationExpiryExtension(183, "Notification of a pre-authorization expiry extension"),
    DiscoverMerchantInitiatedTransactions(185, "Merchant initiated transactions"),
    OriginalFinancialRequestOrAdvice(200, "Original financial request/advice"),
    ApprovedAuthorizationAmountAccurate(201, "Previously approved authorization amount accurate"),
    ApprovedAuthorizationAmountEstimated(202, "Previously approved authorization amount estimated"),
    FullReversal(400, "Full reversal, transaction did not complete as approved"),
    PartialReversal(401, "Partial reversal, transaction did not complete for full amount"),
    UnableParseMessage(650, "Unable to parse message"),
    MAC_Error(691, "MAC Error"),
    RoutingAdvice(670, "mada Payment Gateway eCommerce compliance routing advice (internal to\nmada switch)"),
    SignOn(801, "System condition/sign-on"),
    SignOff(802, "System condition/sign-off"),
    KeyChange(811, "System security/key change"),
    EchoTest(831, "System audit control/echotest");

    private int code;
    private String description;

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private FunctionCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static FunctionCode get(int code) {
        for (FunctionCode e : FunctionCode.values()) {
            if (e.code != code) continue;
            return e;
        }
        return null;
    }
}

