/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Mada.StandardCodes;

public enum ActionCode {
    Approved("000", "Approve", "Approved"),
    HonourIdentification("001", "Approve", "Honour with identification"),
    ApprovedVIP("003", "Approve", "Approved (VIP)"),
    DoNotHonour("100", "Decline", "Do not honour"),
    ExpiredCard("101", "Decline", "Expired card"),
    CardAcceptorContactAcquirer("103", "Decline", "Card acceptor contact acquirer"),
    RestrictedCard("104", "Decline", "Restricted card"),
    CardAcceptor("105", "Decline", "Card acceptor call acquirer\u2018s security department"),
    ReferCardIssuer("107", "Decline", "Refer to card issuer"),
    ReferCardIssuerSC("108", "Decline", "Refer to card issuer\u2018s special conditions"),
    AmountInvalid("110", "Decline", "The specified amount is invalid or exceeds the\nmaximum unitary amount for the given mada\ntransaction service"),
    InvalidCardNumber("111", "Decline", "Invalid card number"),
    NotSufficientFunds("116", "Decline", "Not sufficient funds"),
    NoCardRecord("118", "Decline", "No card record"),
    TransactionNotPermittedCardholder("119", "Decline", "Transaction not permitted to cardholder"),
    ExceedsDailyLimit("121", "Decline", "Exceeds Daily limit for the given mada transaction service"),
    SecurityViolation("122", "Decline", "Security violation"),
    ExceedsFrequencyLimit("123", "Decline", "Exceeds frequency limit i.e. number of transactions, for\nthe given mada transaction service"),
    SuspectedCounterfeitCard("129", "Decline", "Suspected counterfeit card"),
    TransactionNotPermittedMerchant("164", "Decline", "Transaction not permitted for this Merchant Category\nCode (MCC)."),
    CaptureNotAllowed("165", "Decline", "Excessive pre-authorization Capture not allowed.\nThe excessive Capture attempt violates the mada\nbusiness rules in terms of the total amount being\ncaptured or the allowed transaction channels or\npresentment mode."),
    ExtensionNotAllowed("166", "Decline", "More than one pre-authorization extension is not allowed"),
    IssuerNoCertified("167", "Decline", "Issuer not certified for this transaction or service or Issuer\ndoes not support this service"),
    IncorrectCVV("184", "Decline", "Incorrect CVV (Visa 82)"),
    OriginalTransactionRefund("187", "Declined", "Original transaction for refund, preauthorization Capture,\npreauthorization void or preauthorization extension not\nfound based on original transaction data elements."),
    AgreementIDNotPresent("189", "Decline", "Agreement ID is not present in the initial 3DS\nauthenticated agreed payment transaction or the\nAgreement ID in a subsequent COF agreed payment\ntransaction is not present or does not match the\nAgreement ID in the initial 3DS transaction."),
    InvalidRecurringAmountType("191", "Decline", "The recurring payment amount type is invalid."),
    InvalidRecurringAmount("192", "Decline", "The recurring amount value is invalid."),
    RecurringLimitExceeded("193", "Decline", "The total number of allowed recurring payments have been exceeded."),
    BankAccountDoesntMatch("197", "Decline", "The bank account used in the original transaction does\nnot match the bank account being used in the Refund,\nPreauthorization Capture, Preauthorization"),
    AmountMisMatch("198", "Decline", "The refund or preauthorization void transaction amount or\ncumulative amount exceeds the original transaction\namount."),
    AmountLimitExceeded("199", "Decline", "The refund, pre-authorization Capture or preauthorization\nvoid transaction period exceeds the maximum time limit\nallowed by the mada business rules."),
    Accepted("400", "Approve", "Accepted"),
    OriginalTransactionNotFound("480", "Decline", "Original transaction not found"),
    OriginalTransactionDeclined("481", "Decline", "Original transaction was found but declined"),
    Accepted600("600", "Approve", "Accepted"),
    UnableParseMessage("690", "Decline", "Unable to parse message"),
    Accepted800("800", "Approve", "Accepted"),
    ProblemSignatureVerification("884", "Decline", "Problem in signature verification"),
    ProblemKeysFormat("886", "Decline", "Problem with keys format"),
    UnknownError("888", "Decline", "Unknown error"),
    InvalidDate("892", "Decline", "Transmission Date and Time Identical to Earlier Request"),
    InvalidTransaction("902", "Decline", "Invalid transaction"),
    ReEnterTransaction("903", "Decline", "Re-enter transaction"),
    FormatError("904", "Decline", "Format error"),
    CutOverProcess("906", "Decline", "Cutover in process"),
    CardIssuerOrSwitchInoperative("906", "Decline", "Card issuer or switch inoperative"),
    TransactionDestinationNotFound("908", "Decline", "Transaction destination cannot be found for routing"),
    SystemMalfunction("909", "Decline", "System malfunction"),
    CardIssuerSignedOff("910", "Decline", "Card issuer signed off"),
    CardIssuerTimedOut("911", "Decline", "Card issuer timed out"),
    CardIssuerUnavailable("912", "Decline", "Card issuer unavailable"),
    DuplicateTransmission("913", "Decline", "Duplicate transmission"),
    OriginalTransactionUnTraceable("914", "Decline", "Not able to trace back to original transaction"),
    ReconciliationError("915", "Decline", "Reconciliation cutover or checkpoint error"),
    MACIncorrect("916", "Decline", "MAC incorrect (permissible in 1644)"),
    MACKeySync("917", "Decline", "MAC key sync"),
    SecurityError("920", "Decline", "Security software/hardware error \u2013 try again"),
    MessageNumberOutOfSequence("922", "Decline", "Message number out of sequence"),
    RequestInProgress("923", "Decline", "Request in progress"),
    DestinationUnavailable("941", "Decline", "Destination Unavailable");

    private String code;
    private String action;
    private String description;

    private ActionCode(String code, String action, String description) {
        this.code = code;
        this.action = action;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public static ActionCode get(String code) {
        for (ActionCode e : ActionCode.values()) {
            if (!e.code.equalsIgnoreCase(code)) continue;
            return e;
        }
        return null;
    }
}

