/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.ISO8583.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StringUtil {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String fromByteArray(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String asciiFromByteArray(byte[] data) {
        return StringUtil.hexToAscii(StringUtil.fromByteArray(data));
    }

    public static String asciiToHex(String asciiStr) {
        char[] chars = asciiStr.toCharArray();
        StringBuilder hex = new StringBuilder();
        for (char ch : chars) {
            hex.append(Integer.toHexString(ch));
        }
        return hex.toString();
    }

    public static String hexToAscii(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static byte[] asciiToHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        byte[] res = new byte[hexChars.length];
        for (int i = 0; i < hexChars.length; ++i) {
            res[i] = (byte)hexChars[i];
        }
        Arrays.fill(hexChars, '\u0000');
        hexChars = null;
        return res;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = ((String)s).length();
        boolean padd = false;
        if (len % 2 != 0) {
            s = "0" + (String)s;
            ++len;
            padd = true;
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(((String)s).charAt(i), 16) << 4) + Character.digit(((String)s).charAt(i + 1), 16));
        }
        return data;
    }

    public static String fromByteBuffer(ByteBuffer readBuffer) {
        return StringUtil.fromByteArray(Arrays.copyOfRange(readBuffer.array(), 0, readBuffer.position()));
    }

    public static String intToHexString(int value) {
        Object hs = Integer.toHexString(value);
        if (((String)hs).length() % 2 != 0) {
            hs = "0" + (String)hs;
        }
        hs = ((String)hs).toUpperCase();
        return hs;
    }

    public static byte[] asciiToByteArray(byte[] bytes) {
        return StringUtil.hexStringToByteArray(StringUtil.hexToAscii(StringUtil.fromByteArray(bytes)));
    }

    public static String toHexString(String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            sb.append(StringUtil.toHexString(str.charAt(i)));
        }
        return sb.toString();
    }

    public static String toHexString(char ch) {
        Object hex = Integer.toHexString(ch);
        while (((String)hex).length() < 4) {
            hex = "0" + (String)hex;
        }
        hex = "\\u" + (String)hex;
        return hex;
    }

    public static String maskString(String strText, int start, int end, char maskChar) {
        int maskLength;
        if (strText == null || strText.equals("")) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end > strText.length()) {
            end = strText.length();
        }
        if ((maskLength = (end = strText.length() - end) - start) == 0) {
            return strText;
        }
        return strText.substring(0, start) + String.valueOf(maskChar).repeat(Math.max(0, maskLength)) + strText.substring(start + maskLength);
    }
}

