/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.ISO8583.utils;

import java.util.ArrayList;
import java.util.BitSet;

public class FixedBitSet
extends BitSet {
    private final int nbits;

    public FixedBitSet(int nbits) {
        super(nbits);
        this.nbits = nbits;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.nbits);
        for (int i = 0; i < this.nbits; ++i) {
            buffer.append(this.get(i) ? (char)'1' : '0');
        }
        return buffer.toString();
    }

    public FixedBitSet fromHexString(String value) {
        int offset = 0;
        for (int i = 0; i < value.length(); ++i) {
            String item = value.substring(i, i + 1);
            byte bitem = (byte)Integer.parseInt(item, 16);
            if ((bitem & 8) > 0) {
                this.set(offset);
            }
            if ((bitem & 4) > 0) {
                this.set(offset + 1);
            }
            if ((bitem & 2) > 0) {
                this.set(offset + 2);
            }
            if ((bitem & 1) > 0) {
                this.set(offset + 3);
            }
            offset += 4;
        }
        return this;
    }

    public String toHexString() {
        StringBuilder buffer = new StringBuilder(this.nbits);
        String bStr = this.toString();
        for (int c = 0; c < this.nbits; c += 4) {
            int decimal = Integer.parseInt(bStr.substring(c, c + 4), 2);
            String hexStr = Integer.toString(decimal, 16);
            buffer.append(hexStr);
        }
        return buffer.toString();
    }

    public ArrayList<Integer> getIndexes() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int indx = -1;
        int size = this.size();
        while (indx < size && (indx = this.nextSetBit(indx + 1)) != -1) {
            list.add(indx + 1);
        }
        return list;
    }
}

