/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.ISO8583.utils;

import java.util.Arrays;

public final class ByteArray {
    private static int frameSize = 1024;
    private int size;
    private byte[] data;
    private int position = 0;

    public ByteArray() {
        this.init();
    }

    private void init() {
        this.size = frameSize;
        this.data = new byte[this.size];
        this.position = 0;
    }

    public ByteArray append(byte[] value) {
        if (value.length + this.position > this.size) {
            this.expandBuffer();
        }
        System.arraycopy(value, 0, this.data, this.position, value.length);
        this.position += value.length;
        return this;
    }

    public ByteArray append(byte value) {
        this.append(new byte[]{value});
        return this;
    }

    public ByteArray prepend(byte[] value) {
        int vlen = value.length;
        int newSize = (int)(Math.ceil((this.size + vlen) / frameSize) * (double)frameSize);
        byte[] dest = new byte[newSize];
        System.arraycopy(value, 0, dest, 0, vlen);
        System.arraycopy(this.data, 0, dest, vlen, this.position);
        this.data = dest;
        this.position = vlen + this.position;
        this.size = newSize;
        dest = null;
        return this;
    }

    public ByteArray prepend(byte value) {
        this.prepend(new byte[]{value});
        return this;
    }

    private void expandBuffer() {
        int newSize = this.size + frameSize;
        byte[] dest = new byte[this.size];
        System.arraycopy(this.data, 0, dest, 0, this.size);
        this.data = dest;
        this.size = newSize;
        dest = null;
    }

    public int position() {
        return this.position;
    }

    public int limit() {
        return this.size;
    }

    public byte[] array() {
        return Arrays.copyOfRange(this.data, 0, this.position);
    }

    public ByteArray compact() {
        this.data = Arrays.copyOfRange(this.data, 0, this.position);
        this.size = this.position;
        return this;
    }

    public String toString() {
        return new String(this.array());
    }

    public ByteArray clear() {
        Arrays.fill(this.data, (byte)0);
        this.init();
        return this;
    }

    public ByteArray replace(byte[] value) {
        this.init();
        this.append(value);
        return this;
    }
}

