/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.ISO8583.models;

import com.google.common.base.Strings;
import company.tap.commondependencies.ISO8583.enums.fields;
import company.tap.commondependencies.ISO8583.exceptions.ISOException;
import company.tap.commondependencies.ISO8583.utils.FixedBitSet;
import company.tap.commondependencies.ISO8583.utils.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ISOMessage {
    private static final Logger log = LogManager.getLogger(ISOMessage.class);
    private TreeMap<Integer, byte[]> dataElements = new TreeMap();
    private StringBuilder deForLogging = null;
    private boolean isNil = true;
    private String message;
    private String mti;
    private byte[] msg;
    private byte[] header;
    private byte[] body;
    private byte[] primaryBitmap;
    private byte[] secondaryBitmap;
    private int msgClass;
    private int msgFunction;
    private int msgOrigin;
    private int len = 0;
    private boolean parsingComplete;

    public static ISOMessage NullObject() {
        return new ISOMessage();
    }

    public boolean isNil() {
        return this.isNil;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getBody() {
        return this.body;
    }

    public byte[] getPrimaryBitmap() {
        return this.primaryBitmap;
    }

    public int length() {
        return this.len;
    }

    public byte[] getField(int fieldNo) {
        if (!this.dataElements.containsKey(fieldNo)) {
            return new byte[0];
        }
        return this.dataElements.get(fieldNo);
    }

    public byte[] getField(fields field) {
        return this.dataElements.get(field.getNo());
    }

    public String getStringField(int fieldNo) {
        return this.getStringField(fields.valueOf(fieldNo));
    }

    public String getStringField(fields field) {
        return new String(this.getField(field.getNo()), StandardCharsets.ISO_8859_1);
    }

    public ISOMessage setMessage(byte[] message, boolean headerAvailable) throws ISOException {
        this.isNil = false;
        this.msg = message;
        this.len = this.msg.length;
        this.deForLogging = new StringBuilder();
        int headerOffset = 0;
        if (headerAvailable) {
            headerOffset = 12;
        }
        try {
            this.header = Arrays.copyOfRange(this.msg, 0, headerOffset);
            this.body = Arrays.copyOfRange(this.msg, headerOffset, this.msg.length);
            this.primaryBitmap = Arrays.copyOfRange(this.body, 4, 20);
            this.secondaryBitmap = Arrays.copyOfRange(this.body, 20, 36);
            this.parseHeader();
            this.parseBody();
            this.logMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ISOException(e.getMessage(), e.getCause());
        }
        return this;
    }

    public ISOMessage setMessage(byte[] message) throws ISOException {
        return this.setMessage(message, true);
    }

    private void parseHeader() {
        if (this.body.length > 2) {
            this.mti = new String(Arrays.copyOfRange(this.body, 0, 4));
            this.msgClass = Integer.parseInt(this.mti.substring(1, 2));
            this.msgFunction = Integer.parseInt(this.mti.substring(2, 3));
            this.msgOrigin = Integer.parseInt(this.mti.substring(3, 4));
        }
    }

    private void parseBody() {
        int parsingBit = 0;
        try {
            FixedBitSet pb = new FixedBitSet(128);
            pb.fromHexString(new String(this.primaryBitmap) + new String(this.secondaryBitmap));
            int offset = 20;
            for (int o : pb.getIndexes()) {
                fields field = fields.valueOf(o);
                parsingBit = o;
                if (field.isFixed()) {
                    int len = field.getLength();
                    this.addElement(field, Arrays.copyOfRange(this.body, offset, offset + len));
                    offset += len;
                    continue;
                }
                int formatLength = 1;
                switch (field.getFormat()) {
                    case "LL": {
                        formatLength = 2;
                        break;
                    }
                    case "LLL": {
                        formatLength = 3;
                    }
                }
                int flen = Integer.valueOf(new String(Arrays.copyOfRange(this.body, offset, offset + formatLength)));
                this.addElement(field, Arrays.copyOfRange(this.body, offset += formatLength, offset + flen));
                offset += flen;
            }
            this.setParsingComplete(true);
        }
        catch (Exception ex) {
            log.error("Exception occurred while parsing bit no: " + parsingBit, (Throwable)ex);
            this.setParsingComplete(false);
        }
    }

    private void addElement(fields field, byte[] data) {
        this.deForLogging.append(Strings.padEnd((String)("   DE-" + field.getNo()), (int)8, (char)' '));
        this.deForLogging.append(" : ");
        String str = new String(data, StandardCharsets.ISO_8859_1);
        if (field.getNo() == 2) {
            String maskedPan = StringUtil.maskString(str, 6, str.length() - 4, 'x');
            this.deForLogging.append(maskedPan);
        } else if (field.getNo() == 96) {
            this.deForLogging.append("*[").append(StringUtil.fromByteArray(data)).append("]");
        } else {
            this.deForLogging.append(str);
        }
        this.deForLogging.append("\n");
        this.dataElements.put(field.getNo(), data);
    }

    private void logMessage() {
        String primaryBitMap = new String(this.primaryBitmap);
        String secondaryBitMap = new String(this.secondaryBitmap);
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("line.separator"));
        sb.append(this.isRequestMTI() ? "<OUT>" : "<IN>").append("\n");
        sb.append("   [Length] : ").append(this.len).append("\n");
        sb.append("   [Header] : ").append(new String(this.header, StandardCharsets.ISO_8859_1)).append("\n");
        sb.append(Strings.padEnd((String)"   [MTI]", (int)12, (char)' ')).append(": ").append(this.mti).append("\n");
        sb.append(Strings.padEnd((String)"   Primary bitmap ", (int)20, (char)' ')).append(": ").append(primaryBitMap).append("\n");
        sb.append(Strings.padEnd((String)"   Secondary bitmap ", (int)20, (char)' ')).append(": ").append(secondaryBitMap).append("\n");
        sb.append((CharSequence)this.deForLogging);
        sb.append('0' == this.mti.charAt(2) ? "</OUT>" : "</IN>");
        log.info((CharSequence)sb);
    }

    private boolean isRequestMTI() {
        char direction = this.mti.charAt(2);
        return '0' == direction || '2' == direction || '4' == direction;
    }

    public Set<Map.Entry<Integer, byte[]>> getEntrySet() {
        return this.dataElements.entrySet();
    }

    public boolean fieldExits(fields field) {
        return this.fieldExits(field.getNo());
    }

    public boolean fieldExits(int no) {
        return this.dataElements.containsKey(no);
    }

    public String getMti() {
        return this.mti;
    }

    public int getMsgClass() {
        return this.msgClass;
    }

    public int getMsgFunction() {
        return this.msgFunction;
    }

    public int getMsgOrigin() {
        return this.msgOrigin;
    }

    public boolean isParsingComplete() {
        return this.parsingComplete;
    }

    public void setParsingComplete(boolean parsingComplete) {
        this.parsingComplete = parsingComplete;
    }

    public String toString() {
        return Strings.padStart((String)String.valueOf(this.msg.length), (int)4, (char)'0') + new String(this.msg, StandardCharsets.ISO_8859_1);
    }

    public String fieldsToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\r\n");
        for (Map.Entry<Integer, byte[]> item : this.dataElements.entrySet()) {
            stringBuilder.append(fields.valueOf(item.getKey()).name()).append(" : ").append(new String(item.getValue())).append("\r\n");
        }
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    public void clear() {
        Arrays.fill(this.header, (byte)0);
        Arrays.fill(this.body, (byte)0);
        Arrays.fill(this.primaryBitmap, (byte)0);
        this.message = null;
        this.header = null;
        this.body = null;
        this.primaryBitmap = null;
    }

    public String toHexString() {
        return Strings.padStart((String)String.valueOf(this.msg.length), (int)4, (char)'0') + String.valueOf(Hex.encodeHex((byte[])this.msg));
    }

    public TreeMap<Integer, byte[]> getDataElements() {
        return this.dataElements;
    }

    public StringBuilder getDeForLogging() {
        return this.deForLogging;
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getMsg() {
        return this.msg;
    }

    public byte[] getSecondaryBitmap() {
        return this.secondaryBitmap;
    }

    public int getLen() {
        return this.len;
    }

    public void setDataElements(TreeMap<Integer, byte[]> dataElements) {
        this.dataElements = dataElements;
    }

    public void setDeForLogging(StringBuilder deForLogging) {
        this.deForLogging = deForLogging;
    }

    public void setNil(boolean isNil) {
        this.isNil = isNil;
    }

    public void setMti(String mti) {
        this.mti = mti;
    }

    public void setMsg(byte[] msg) {
        this.msg = msg;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setPrimaryBitmap(byte[] primaryBitmap) {
        this.primaryBitmap = primaryBitmap;
    }

    public void setSecondaryBitmap(byte[] secondaryBitmap) {
        this.secondaryBitmap = secondaryBitmap;
    }

    public void setMsgClass(int msgClass) {
        this.msgClass = msgClass;
    }

    public void setMsgFunction(int msgFunction) {
        this.msgFunction = msgFunction;
    }

    public void setMsgOrigin(int msgOrigin) {
        this.msgOrigin = msgOrigin;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ISOMessage)) {
            return false;
        }
        ISOMessage other = (ISOMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNil() != other.isNil()) {
            return false;
        }
        if (this.getMsgClass() != other.getMsgClass()) {
            return false;
        }
        if (this.getMsgFunction() != other.getMsgFunction()) {
            return false;
        }
        if (this.getMsgOrigin() != other.getMsgOrigin()) {
            return false;
        }
        if (this.getLen() != other.getLen()) {
            return false;
        }
        if (this.isParsingComplete() != other.isParsingComplete()) {
            return false;
        }
        TreeMap<Integer, byte[]> this$dataElements = this.getDataElements();
        TreeMap<Integer, byte[]> other$dataElements = other.getDataElements();
        if (this$dataElements == null ? other$dataElements != null : !((Object)this$dataElements).equals(other$dataElements)) {
            return false;
        }
        StringBuilder this$deForLogging = this.getDeForLogging();
        StringBuilder other$deForLogging = other.getDeForLogging();
        if (this$deForLogging == null ? other$deForLogging != null : !this$deForLogging.equals(other$deForLogging)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$mti = this.getMti();
        String other$mti = other.getMti();
        if (this$mti == null ? other$mti != null : !this$mti.equals(other$mti)) {
            return false;
        }
        if (!Arrays.equals(this.getMsg(), other.getMsg())) {
            return false;
        }
        if (!Arrays.equals(this.getHeader(), other.getHeader())) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Arrays.equals(this.getPrimaryBitmap(), other.getPrimaryBitmap())) {
            return false;
        }
        return Arrays.equals(this.getSecondaryBitmap(), other.getSecondaryBitmap());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ISOMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNil() ? 79 : 97);
        result = result * 59 + this.getMsgClass();
        result = result * 59 + this.getMsgFunction();
        result = result * 59 + this.getMsgOrigin();
        result = result * 59 + this.getLen();
        result = result * 59 + (this.isParsingComplete() ? 79 : 97);
        TreeMap<Integer, byte[]> $dataElements = this.getDataElements();
        result = result * 59 + ($dataElements == null ? 43 : ((Object)$dataElements).hashCode());
        StringBuilder $deForLogging = this.getDeForLogging();
        result = result * 59 + ($deForLogging == null ? 43 : $deForLogging.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $mti = this.getMti();
        result = result * 59 + ($mti == null ? 43 : $mti.hashCode());
        result = result * 59 + Arrays.hashCode(this.getMsg());
        result = result * 59 + Arrays.hashCode(this.getHeader());
        result = result * 59 + Arrays.hashCode(this.getBody());
        result = result * 59 + Arrays.hashCode(this.getPrimaryBitmap());
        result = result * 59 + Arrays.hashCode(this.getSecondaryBitmap());
        return result;
    }
}

