/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.ISO8583.builders;

import company.tap.commondependencies.ISO8583.builders.GeneralMessageClassBuilder;
import company.tap.commondependencies.ISO8583.enums.Version;
import company.tap.commondependencies.ISO8583.exceptions.ISOException;
import company.tap.commondependencies.ISO8583.interfaces.MessageClass;
import company.tap.commondependencies.ISO8583.interfaces.MessagePacker;
import company.tap.commondependencies.ISO8583.interfaces.UnpackMessage;
import company.tap.commondependencies.ISO8583.interfaces.UnpackMethods;
import company.tap.commondependencies.ISO8583.models.ISOMessage;
import java.nio.charset.StandardCharsets;

public class ISOMessageBuilder {
    public static MessageClass Packer(Version version) {
        return new Builder(version.getCode());
    }

    public static UnpackMessage Unpacker() {
        return new UnpackBuilder();
    }

    private static class Builder
    implements MessageClass {
        private final String version;

        public Builder(String version) {
            this.version = version;
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> authorization() {
            return new GeneralMessageClassBuilder(this.version, "1");
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> financial() {
            return new GeneralMessageClassBuilder(this.version, "2");
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> fileAction() {
            return new GeneralMessageClassBuilder(this.version, "3");
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> reversal() {
            return new GeneralMessageClassBuilder(this.version, "4");
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> reconciliation() {
            return new GeneralMessageClassBuilder(this.version, "5");
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> administrative() {
            return new GeneralMessageClassBuilder(this.version, "6");
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> feeCollection() {
            return new GeneralMessageClassBuilder(this.version, "7");
        }

        @Override
        public MessagePacker<GeneralMessageClassBuilder> networkManagement() {
            return new GeneralMessageClassBuilder(this.version, "8");
        }
    }

    public static class UnpackBuilder
    implements UnpackMessage,
    UnpackMethods {
        private byte[] message;

        @Override
        public UnpackMethods setMessage(byte[] message) {
            this.message = message;
            return this;
        }

        @Override
        public UnpackMethods setMessage(String message) {
            message = message.substring(4);
            this.setMessage(message.getBytes(StandardCharsets.ISO_8859_1));
            return this;
        }

        @Override
        public ISOMessage build() throws ISOException {
            ISOMessage finalMessage = new ISOMessage();
            finalMessage.setMessage(this.message);
            return finalMessage;
        }

        @Override
        public UnpackMethods setMessage(String message, boolean lengthAvailable) {
            if (lengthAvailable) {
                message = message.substring(4);
            }
            return this;
        }
    }
}

