/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Helpers;

import company.tap.commondependencies.Helpers.IHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Date;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
class Helper
implements IHelper {
    @Autowired
    JavaMailSender javaMailSender;
    private final String LOCALHOST_IPV4 = "127.0.0.1";
    private final String LOCALHOST_IPV6 = "0:0:0:0:0:0:0:1";

    Helper() {
    }

    @Override
    public String maskString(String strText, int start, int end, char maskChar) throws Exception {
        int maskLength;
        if (strText == null || strText.equals("")) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end > strText.length()) {
            end = strText.length();
        }
        if ((maskLength = (end = strText.length() - end) - start) == 0) {
            return strText;
        }
        return strText.substring(0, start) + String.valueOf(maskChar).repeat(Math.max(0, maskLength)) + strText.substring(start + maskLength);
    }

    @Override
    public String GenerateFingerprint(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hashInBytes = md.digest(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b : hashInBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    @Override
    public String getClientIp(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (StringUtils.isEmpty((Object)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((Object)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((StringUtils.isEmpty((Object)ipAddress) || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                ipAddress = inetAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((Object)ipAddress) && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    @Override
    public Date GetExpiryDate(int minutes) {
        long t = new Date().getTime();
        return new Date(t + (long)(minutes * 60000));
    }

    @Override
    public boolean sendMail(String To, String body, String subject) {
        try {
            MimeMessage message = this.javaMailSender.createMimeMessage();
            MimeMessageHelper msg = new MimeMessageHelper(message, true);
            msg.setFrom("reporting_no_reply@tap.company");
            msg.setTo(To);
            msg.setSubject(subject);
            msg.setText(body, true);
            this.javaMailSender.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

