/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Headers;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import company.tap.commondependencies.ApiModels.ApiHeaders;
import company.tap.commondependencies.ApiModels.Session;
import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Headers.IHeaderService;
import company.tap.commondependencies.Helpers.ObjMapper;
import company.tap.commondependencies.Helpers.RestAPI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
class HeaderService
implements IHeaderService {
    private static final Logger log = LogManager.getLogger(HeaderService.class);
    final IErrorServices _errorServices;

    public HeaderService(IErrorServices _errorServices) {
        this._errorServices = _errorServices;
    }

    @Override
    public ApiHeaders GetHeaderData(HttpHeaders request) {
        try {
            return this.GetHeaderData(request, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ApiHeaders GetHeaderData(HttpHeaders request, boolean operator) {
        try {
            String channelId;
            log.info((Object)request);
            ApiHeaders headers = new ApiHeaders();
            String auth = request.getFirst("Authorization");
            if (auth == null) {
                return null;
            }
            String[] au = (auth = auth.replace("'", "")).split(" ");
            headers.authorization = au.length >= 2 ? au[1] : auth;
            String langCode = request.getFirst("lang_code");
            langCode = langCode != null ? langCode.replace("'", "") : "EN";
            headers.lang_code = langCode;
            String liveMode = request.getFirst("livemode");
            if (liveMode == null) {
                return null;
            }
            liveMode = liveMode.replace("'", "");
            headers.live_mode = liveMode.equals("true");
            String merchantId = request.getFirst("merchant_id");
            if (merchantId == null) {
                return null;
            }
            headers.merchant_id = merchantId = merchantId.replace("'", "");
            String sessionToken = request.getFirst("session_token");
            if (sessionToken == null) {
                return null;
            }
            headers.session_token = sessionToken = sessionToken.replace("'", "");
            String permissions = request.getFirst("permissions");
            if (permissions != null) {
                permissions = permissions.replace("'", "\"");
                log.info(permissions);
                if (permissions.contains("[")) {
                    headers.permissions = (String[])ObjMapper.getInstance().readValue(permissions, String[].class);
                }
                headers.permission = permissions;
            }
            if ((channelId = request.getFirst("channel_id")) != null) {
                channelId = channelId.replace("'", "");
            }
            headers.channel_id = channelId;
            String networkId = request.getFirst("network_id");
            if (networkId != null) {
                networkId = networkId.replace("'", "");
            }
            headers.network_id = networkId;
            String terminalId = request.getFirst("terminal_id");
            if (terminalId != null) {
                terminalId = terminalId.replace("'", "");
            }
            headers.terminal_id = terminalId;
            String customer_checked = request.getFirst("customer_checked");
            headers.customer_checked = customer_checked != null && customer_checked.equals("true");
            if (operator) {
                String businessId;
                String operatorId = request.getFirst("operatorId");
                if (operatorId == null) {
                    return null;
                }
                headers.operatorId = operatorId;
                headers.businessId = businessId = request.getFirst("businessId");
                String segmentId = request.getFirst("segmentId");
                headers.segmentId = segmentId != null && segmentId.isBlank() ? null : segmentId;
            }
            return headers;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    ApiHeaders GetSessionHeaderData(String Session2, String JWTSecretKey) {
        byte[] byteSecret = JWTSecretKey.getBytes(StandardCharsets.US_ASCII);
        try {
            new ApiHeaders();
            Algorithm algorithm = Algorithm.HMAC256((byte[])byteSecret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).acceptLeeway(1L).build();
            DecodedJWT jwt = verifier.verify(Session2);
            byte[] bs = Base64.getDecoder().decode(jwt.getPayload());
            String Ses = new String(bs);
            return (ApiHeaders)ObjMapper.getInstance().readValue(Ses, ApiHeaders.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ResponseEntity<Object> ValidateHeaders(HttpHeaders httpHeaders, boolean tap, String JWTSecretKey) {
        ApiHeaders headers = this.GetHeaderData(httpHeaders);
        if (headers != null) {
            ApiHeaders sessionHead = this.GetSessionHeaderData(headers.session_token, JWTSecretKey);
            return this.getObjectResponseEntity(tap, headers, sessionHead);
        }
        return this._errorServices.Error(Errors.Headers_values_missing.getCode(), Errors.Headers_values_missing.toString(), "Header values are missing", HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<Object> getObjectResponseEntity(boolean tap, ApiHeaders headers, ApiHeaders sessionHead) {
        if (sessionHead == null) {
            return this._errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(), "Invalid session token", HttpStatus.UNAUTHORIZED);
        }
        if (!sessionHead.api_key.equals(headers.authorization)) {
            return this._errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(), "Api key doesnt match with session token", HttpStatus.UNAUTHORIZED);
        }
        if (!sessionHead.merchant_id.equals(headers.merchant_id)) {
            return this._errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(), "Api key doesnt match with merchant id", HttpStatus.UNAUTHORIZED);
        }
        if (tap && !sessionHead.merchant_id.equals("1300")) {
            return this._errorServices.Error(Errors.Invalid_API_Key.getCode(), Errors.Invalid_API_Key.toString(), "Api key is not authorized", HttpStatus.UNAUTHORIZED);
        }
        return null;
    }

    @Override
    public ResponseEntity<Object> ValidateHeaders(HttpHeaders httpHeaders, boolean tap) {
        ApiHeaders headers = this.GetHeaderData(httpHeaders);
        if (headers != null) {
            ApiHeaders sessionHead = this.GetSessionHeaderData(headers.session_token, "vaKvjbBUSNgehrmMJsNJVBcKwVLHKKzb");
            return this.getObjectResponseEntity(tap, headers, sessionHead);
        }
        return this._errorServices.Error(Errors.Headers_values_missing.getCode(), Errors.Headers_values_missing.toString(), "Header values are missing", HttpStatus.BAD_REQUEST);
    }

    @Override
    public ResponseEntity<Object> ValidateHeaders(HttpHeaders httpHeaders, boolean tap, boolean operator) {
        ApiHeaders headers = this.GetHeaderData(httpHeaders, true);
        if (headers != null) {
            ApiHeaders sessionHead = this.GetSessionHeaderData(headers.session_token, "vaKvjbBUSNgehrmMJsNJVBcKwVLHKKzb");
            return this.getObjectResponseEntity(tap, headers, sessionHead);
        }
        return this._errorServices.Error(Errors.Headers_values_missing.getCode(), Errors.Headers_values_missing.toString(), "Header values are missing", HttpStatus.BAD_REQUEST);
    }

    private Session getLoginSession(String apiKey) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setAccept(Arrays.asList(MediaType.APPLICATION_FORM_URLENCODED));
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"key", (Object)apiKey);
            HttpEntity entityToken = new HttpEntity((Object)body, (MultiValueMap)headersCA);
            return (Session)RestAPI.getInstance().exchange("https://api.tap.company/v2/gologin/session", HttpMethod.POST, entityToken, Session.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public HttpHeaders getSessionHeaders(String apiKey) {
        Session session = this.getLoginSession(apiKey);
        if (session != null && session.status.equals("success")) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            httpHeaders.set("merchant_id", session.data.merchant_id);
            httpHeaders.set("live_mode", String.valueOf(session.data.live_mode));
            httpHeaders.set("session_token", session.data.session_token);
            httpHeaders.set("Authorization", apiKey);
            return httpHeaders;
        }
        return null;
    }
}

