/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Currency;

import company.tap.commondependencies.ApiModels.Name;
import company.tap.commondependencies.Country.Country;
import company.tap.commondependencies.Country.ICountryServices;
import company.tap.commondependencies.Currency.Code;
import company.tap.commondependencies.Currency.Currency;
import company.tap.commondependencies.Currency.ICurrencyServices;
import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
class CurrencyServices
implements ICurrencyServices {
    final IErrorServices _errorServices;
    final ICountryServices _countryServices;
    private final String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();

    public CurrencyServices(IErrorServices _errorServices, ICountryServices _countryServices) {
        this._errorServices = _errorServices;
        this._countryServices = _countryServices;
    }

    private Currency getCurrency(String Code2) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
            return (Currency)RestAPI.getInstance().exchange(this.CommonApi + "currency/iso/" + Code2, HttpMethod.GET, entityToken, Currency.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Currency getCurrencyByCountryIso2(String CountryCode) {
        return this.getCurrency(CountryCode);
    }

    @Override
    public Currency getCurrencyByCurrencyCode(String CurrencyCode) {
        return this.getCurrency(CurrencyCode);
    }

    @Override
    public Currency getCurrencyById(String CurrencyId) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
            return (Currency)RestAPI.getInstance().exchange(this.CommonApi + "currency/" + CurrencyId, HttpMethod.GET, entityToken, Currency.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ResponseEntity<Object> validateCurrencyCodeByCountry(String currencyCode, String countryCode) {
        Currency currency = this.getCurrency(currencyCode);
        if (currency == null) {
            return this._errorServices.Error(Errors.Not_Found.getCode(), Errors.Not_Found.toString(), "Invalid ISO CurrencyCode", HttpStatus.NOT_FOUND);
        }
        Country country = this._countryServices.getCountryByCountryIso(countryCode);
        if (country == null) {
            return this._errorServices.Error(Errors.Not_Found.getCode(), Errors.Not_Found.toString(), "Invalid ISO Country Code", HttpStatus.NOT_FOUND);
        }
        ArrayList<String> currencies = new ArrayList<String>();
        switch (country.getIso2()) {
            case "KW": {
                currencies.add("KWD");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "AE": {
                currencies.add("AED");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "SA": {
                currencies.add("SAR");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "BH": {
                currencies.add("BHD");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "OM": {
                currencies.add("OMR");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "LB": 
            case "JO": {
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "EG": {
                currencies.add("USD");
                currencies.add("EGP");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            default: {
                currencies.add("USD");
                currencies.add("EUR");
                currencies.add("GBP");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
        }
        return null;
    }

    private JSONArray getCurrencies() {
        block9: {
            JSONArray jSONArray;
            JSONParser jsonParser = new JSONParser();
            ClassPathResource resource = new ClassPathResource("Currency.json");
            InputStreamReader reader = new InputStreamReader(resource.getInputStream());
            try {
                Object obj = jsonParser.parse((Reader)reader);
                jSONArray = (JSONArray)obj;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    break block9;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block9;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return jSONArray;
        }
        return null;
    }

    @Override
    public Currency getCurrencyByIdLocal(String id) {
        try {
            JSONArray countries = this.getCurrencies();
            if (countries == null) {
                return null;
            }
            JSONObject currency = (JSONObject)countries.stream().filter(jsonValue -> ((JSONObject)jsonValue).get((Object)"currencyId").equals(id)).findFirst().get();
            return this.prepareCurrencyResponse(currency);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Currency getCurrencyByCodeLocal(String code) {
        try {
            JSONArray countries = this.getCurrencies();
            if (countries == null) {
                return null;
            }
            JSONObject currency = (JSONObject)countries.stream().filter(jsonValue -> ((JSONObject)jsonValue).get((Object)"english").equals(code)).findFirst().get();
            return this.prepareCurrencyResponse(currency);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private Currency prepareCurrencyResponse(JSONObject jsonObject) {
        Currency currency = new Currency();
        currency.decimals = Integer.parseInt(jsonObject.get((Object)"decimals").toString());
        currency.currencyId = jsonObject.get((Object)"currencyId").toString();
        Code code = new Code();
        code.english = jsonObject.get((Object)"english").toString();
        code.textId = jsonObject.get((Object)"textId").toString();
        currency.code = code;
        JSONObject nameJson = (JSONObject)jsonObject.get((Object)"name");
        Name name = new Name();
        name.textId = nameJson.get((Object)"textId").toString();
        name.english = nameJson.get((Object)"english").toString();
        currency.name = name;
        currency.created = Long.parseLong(jsonObject.get((Object)"created").toString());
        currency.country = jsonObject.get((Object)"country").toString();
        currency.symbol = jsonObject.get((Object)"symbol").toString();
        return currency;
    }
}

