/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Country;

import company.tap.commondependencies.ApiModels.Name;
import company.tap.commondependencies.Country.Country;
import company.tap.commondependencies.Country.ICountryServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
class CountryServices
implements ICountryServices {
    private final String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();

    CountryServices() {
    }

    @Override
    public Country getCountryByCountryIso(String CountryCode) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
            return (Country)RestAPI.getInstance().exchange(this.CommonApi + "country/iso/" + CountryCode, HttpMethod.GET, entityToken, Country.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Country getCountryByCountryId(String CountryId) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
            return (Country)RestAPI.getInstance().exchange(this.CommonApi + "country/" + CountryId, HttpMethod.GET, entityToken, Country.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    private JSONArray getCountries() {
        block9: {
            JSONArray jSONArray;
            JSONParser jsonParser = new JSONParser();
            ClassPathResource resource = new ClassPathResource("Countries.json");
            InputStreamReader reader = new InputStreamReader(resource.getInputStream());
            try {
                Object obj = jsonParser.parse((Reader)reader);
                jSONArray = (JSONArray)obj;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    break block9;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block9;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return jSONArray;
        }
        return null;
    }

    @Override
    public Country getCountryByCountryIsoLocal(String code) {
        try {
            JSONArray countries = this.getCountries();
            if (countries == null) {
                return null;
            }
            JSONObject country = code.length() == 2 ? (JSONObject)countries.stream().filter(jsonValue -> ((JSONObject)jsonValue).get((Object)"iso2").equals(code.toUpperCase())).findFirst().get() : (JSONObject)countries.stream().filter(jsonValue -> ((JSONObject)jsonValue).get((Object)"iso3").equals(code.toUpperCase())).findFirst().get();
            return this.prepareResponseObject(country);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Country getCountryByCountryIdLocal(String CountryId) {
        try {
            JSONArray countries = this.getCountries();
            if (countries == null) {
                return null;
            }
            JSONObject country = (JSONObject)countries.stream().filter(jsonValue -> ((JSONObject)jsonValue).get((Object)"countryId").equals(CountryId)).findFirst().get();
            return this.prepareResponseObject(country);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private Country prepareResponseObject(JSONObject jsonObject) {
        Country country = new Country();
        country.countryId = jsonObject.get((Object)"countryId").toString();
        country.capital = jsonObject.get((Object)"capital").toString();
        country.continent = jsonObject.get((Object)"continent").toString();
        country.geoNameId = jsonObject.get((Object)"geoNameId").toString();
        country.idd_prefix = jsonObject.get((Object)"idd_prefix").toString();
        country.iso2 = jsonObject.get((Object)"iso2").toString();
        country.iso3 = jsonObject.get((Object)"iso3").toString();
        country.numeric = jsonObject.get((Object)"numeric").toString();
        JSONObject name = (JSONObject)jsonObject.get((Object)"name");
        Name countryName = new Name();
        countryName.arabic = name.get((Object)"arabic").toString();
        countryName.english = name.get((Object)"english").toString();
        countryName.chinese = name.get((Object)"chinese").toString();
        countryName.russian = name.get((Object)"russian").toString();
        countryName.spanish = name.get((Object)"spanish").toString();
        countryName.french = name.get((Object)"french").toString();
        country.name = countryName;
        country.created = Long.parseLong(jsonObject.get((Object)"created").toString());
        return country;
    }

    @Override
    public Country getCountryByPrefixIdLocal(int countryPhoneCode) {
        try {
            JSONArray countries = this.getCountries();
            if (countries == null) {
                return null;
            }
            JSONObject country = (JSONObject)countries.stream().filter(jsonValue -> Integer.parseInt(((JSONObject)jsonValue).get((Object)"idd_prefix").toString()) == countryPhoneCode).findFirst().get();
            return this.prepareResponseObject(country);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

