/*
 * Copyright (c) 2021. Tap Payments
 * Author: Charan Dommara
 * Created On: 16 6 2021
 */

package company.tap.commondependencies.exceptions;

import company.tap.commondependencies.Errors.Errors;
import org.springframework.http.HttpStatus;

public class CustomErrorException extends RuntimeException{

    private final Errors errors;

    private final HttpStatus httpStatus;

    public CustomErrorException(String message, Errors errors, HttpStatus httpStatus) {
        super(message);
        this.errors = errors;
        this.httpStatus = httpStatus;
    }

    public Errors getErrors() {
        return errors;
    }

    public HttpStatus getHttpStatus() {
        return httpStatus;
    }

}
