/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Mada.StandardCodes;

public enum CityCodes {
    Riyadh(101, "Riyadh"),
    Derieyyah(102, "Derieyyah"),
    Oyaynah(103, "Oyaynah"),
    Rumah(104, "Rumah"),
    Ghoraimla(105, "Ghoraimla"),
    Thadiq(106, "Thadiq"),
    Majmaah(107, "Majmaah"),
    HoutatSodair(108, "Houtat Sodair"),
    Artaweyyah(109, "Artaweyyah"),
    Tumair(110, "Tumair"),
    Ghat(111, "Ghat"),
    Zulfy(112, "Zulfy"),
    Shagra(113, "Shagra"),
    Oshaiger(114, "Oshaiger"),
    Marat(115, "Marat"),
    Durma(116, "Durma"),
    Muzahmeyah(117, "Muzahmeyah"),
    Haier(118, "Haier"),
    Kharj(119, "Kharj"),
    Delam(120, "Delam"),
    HoutatBaniTamim(121, "HoutatBani-Tamim"),
    Hariq(122, "Hariq"),
    Aflaj(123, "Aflaj"),
    Sulayyel(124, "Sulayyel"),
    WadiAddawaser(125, "WadiAddawaser"),
    Dawadmi(126, "Dawadmi"),
    Sajer(127, "Sajer"),
    Rafayea(128, "Rafayea"),
    Bjadeyyah(129, "Bjadeyyah"),
    Quaieyyah(130, "Quaieyyah"),
    Afif(131, "Afif"),
    Rouaidah(132, "Rouaidah"),
    Qassab(133, "Qassab"),
    Erkah(134, "Erkah"),
    Makkah(201, "Makkah"),
    Bahrah(202, "Bahrah"),
    Jaddah(203, "Jaddah"),
    Rabegh(204, "Rabegh"),
    Kamel(205, "Kamel"),
    Jomoum(206, "Jomoum"),
    Taif(207, "Taif"),
    Geya(208, "Geya"),
    Turbah(209, "Turbah"),
    Khormah(210, "Khormah"),
    Ranyah(211, "Ranyah"),
    Laith(212, "Laith"),
    Qunfothah(213, "Qunfothah"),
    ArdeyyahAshamalyyah(214, "Ardeyyah Ashamalyyah"),
    Mowaih(215, "Mowaih"),
    Dhulam(216, "Dhulam"),
    Kouz(217, "Kouz"),
    BaniSaad(218, "Bani Saad"),
    Maisan(219, "Maisan"),
    Dammam(301, "Dammam"),
    Khobar(302, "Khobar"),
    Thogbah(303, "Thogbah"),
    Dhahran(304, "Dhahran"),
    Bgaig(305, "Bgaig"),
    AinDar(306, "Ain Dar"),
    Salwa(307, "Salwa"),
    Adleyah(308, "Adleyah"),
    Qatif(309, "Qatif"),
    Taroot(310, "Taroot"),
    Sehat(311, "Sehat"),
    Safwa(312, "Safwa"),
    RasTanourah(313, "Ras Tanourah"),
    Jubail(314, "Jubail"),
    Neairyyah(315, "Neairyyah"),
    OlayaVillage(316, "Olaya Village"),
    RasMeshab(317, "Ras Meshab"),
    Khafjy(318, "Khafjy"),
    Rogey(319, "Rogey"),
    HafrAlbatin(320, "Hafr Albatin"),
    Kaysomah(321, "Kaysomah"),
    UmAlhamam(322, "Um-Alhamam"),
    Hafouf(323, "Hafouf"),
    Mubarraz(324, "Mubarraz"),
    Jaffr(325, "Jaffr"),
    Omran(326, "Omran"),
    Holilah(327, "Holilah"),
    Oyoun(328, "Oyoun"),
    Garah(329, "Garah"),
    Buraidah(401, "Buraidah"),
    Asyah(402, "Asyah"),
    Bukairiyah(403, "Bukairiyah"),
    Khabra(404, "Khabra"),
    RiyadhAlkabra(405, "RiyadhAlkabra"),
    Badaie(406, "Badaie"),
    Shmasyyah(407, "Shmasyyah"),
    Daryyah(408, "Daryyah"),
    Oanisah(409, "Oanisah"),
    OqlatAssokoor(410, "OqlatAssokoor"),
    Methnab(411, "Methnab"),
    Rass(412, "Rass"),
    OyounAljwa(413, "OyounAljwa"),
    Mulaida(414, "Mulaida"),
    Dekhnah(415, "Dekhnah"),
    Alfawarah(416, "Alfawarah"),
    Hail(501, "Hail"),
    Bagaa(502, "Baga’a"),
    TurbahHail(503, "Turbah-Hail"),
    Jebah(504, "Jebah"),
    Haiet(505, "Haiet"),
    Roudah(506, "Roudah"),
    Shamly(507, "Shamly"),
    Tabouk(601, "Tabouk"),
    Taima(602, "Taima"),
    Beda(603, "Beda"),
    Dheba(604, "Dheba"),
    Wajh(605, "Wajh"),
    Umloj(606, "Umloj"),
    Skaka(607, "Skaka"),
    Gara(608, "Gara"),
    DomatAljandal(609, "Domat Aljandal"),
    Tabarjal(610, "Tabarjal"),
    Arar(611, "Arar"),
    JadeedatArar(612, "JadeedatArar"),
    Toraif(613, "Toraif"),
    Owayqlyyah(614, "Owayqlyyah"),
    Rafha(615, "Rafha"),
    Gorayyat(616, "Gorayyat"),
    Hadiethah(617, "Hadiethah"),
    HalatAmmar(618, "HalatAmmar"),
    Haql(619, "Haql"),
    Durrah(620, "Durrah"),
    Madina(701, "Madina"),
    Khaibar(702, "Khaibar"),
    Ola(703, "Ola"),
    Yetmah(704, "Yetmah"),
    Honakeyyah(705, "Honakeyyah"),
    MahdAthahab(706, "Mahd Athahab"),
    Badr(707, "Badr"),
    Uanbu(708, "Uanbu"),
    RasBuraidy(709, "Ras-Buraidy"),
    YanbuAlnakhel(710, "Yanbu Alnakhel"),
    Abah(801, "Abah"),
    KhameesMushait(802, "Khamees Mushait"),
    AhadRufaidah(803, "Ahad Rufaidah"),
    SaratObaidah(804, "Sarat  Obaidah"),
    Harjah(805, "Harjah"),
    GhahranAljanoub(806, "Ghahran Aljanoub"),
    Tathleeth(807, "Tathleeth"),
    Bieshah(808, "Bieshah"),
    SabtAlalaya(809, "Sabt Alalaya"),
    Ballasmar(810, "Ballasmar"),
    Tanoumah(811, "Tanoumah"),
    Nomas(812, "Nomas"),
    Sarh(813, "Sarh"),
    Bashaier(814, "Bashaier"),
    Mahail(815, "Mahail"),
    MujardahBaniShehr(816, "Mujardah Bani-Shehr"),
    Shaabain(817, "Shaabain"),
    Bareg(818, "Bareg"),
    Ballahmar(819, "Ballahmar"),
    Baha(820, "Baha"),
    Mandag(821, "Mandag"),
    RobouQuraish(822, "Robou Quraish"),
    Baljorashy(823, "Baljorashy"),
    Aqiq(824, "Aqiq"),
    Mukhwah(825, "Mukhwah"),
    Qalwah(826, "Qalwah"),
    Jisan(827, "Jisan"),
    AboAraish(828, "Abo Araish"),
    Dhamad(829, "Dhamad"),
    AhadAlMasarha(830, "Ahad Al-Masarha"),
    Samta(831, "Samta"),
    Twal(832, "Twal"),
    Farasan(833, "Farasan"),
    Sabya(834, "Sabya"),
    Biesh(835, "Biesh"),
    Darb(836, "Darb"),
    Shuqaiq(837, "Shuqaiq"),
    Faifa(838, "Faifa"),
    Najran(839, "Najran"),
    Ariesh(840, "Ariesh"),
    Sharorah(841, "Sharorah");
    private int code;
    private String cityName;

    public int getCode() {
        return code;
    }

    public String getCityName() {
        return cityName;
    }

    CityCodes(int code, String cityName) {
        this.code = code;
        this.cityName = cityName;
    }

    public static CityCodes get(int code) {
        for (CityCodes e : CityCodes.values()) {
            if (e.code == code) return e;
        }
        return null;
    }
}
