/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ISO8583.interfaces;

import company.tap.commondependencies.ISO8583.enums.fields;
import company.tap.commondependencies.ISO8583.exceptions.ISOException;
import company.tap.commondependencies.ISO8583.models.ISOMessage;

import java.util.Map;

public interface DataElement<T> {
    ISOMessage build() throws ISOException;

    DataElement<T> setField(int no, String value) throws ISOException;

    DataElement<T> setField(fields field, String value) throws ISOException;

    DataElement<T> setField(int no, byte[] value) throws ISOException;

    DataElement<T> setField(fields field, byte[] value) throws ISOException;

    DataElement<T> setHeader(String header);

    DataElement<T> setFields(Map<Integer, String> DataElements) throws ISOException;
}
