package company.tap.commondependencies.Helpers;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ObjMapper extends ObjectMapper {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4137500612219963914L;
	// singleton instance declaration
	private static ObjMapper shared;

	// making constructor private so that no other class could use the default
	// constructor
	private ObjMapper() {
	}

	// the method which gives access to the only instance of ApiClientReqLib, is
	// thread safe
	public static synchronized ObjMapper getInstance() {
		if (shared == null) {
			shared = new ObjMapper();
			shared.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
			shared.setSerializationInclusion(Include.NON_NULL);
		}
		return shared;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}
