package company.tap.commondependencies.Generators;

import java.io.StringWriter;
import java.security.*;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.springframework.stereotype.Service;

@Service
class Generator implements IGenerator {

	private String getAlphaNumericString(int length) {

		// chose a Character random from this String
		String AlphaNumericString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvxyz";

		// create StringBuffer size of AlphaNumericString
		return getRandomString(length, AlphaNumericString);
	}

	private String getRandomString(int length, String alphaNumericString) {
		StringBuilder sb = new StringBuilder(4);

		for (int i = 0; i < length; i++) {

			// generate a random number between
			// 0 to AlphaNumericString variable length
			int index = (int) (alphaNumericString.length() * Math.random());

			// add Character one by one in end of sb
			sb.append(alphaNumericString.charAt(index));
		}

		return sb.toString();
	}

	public String GetId(String type) {

		Calendar calendar = Calendar.getInstance();
		return type + "_" + getAlphaNumericString(4) + calendar.get(Calendar.SECOND)
				+ String.valueOf(calendar.get(Calendar.YEAR)).substring(2)
				+ calendar.get(Calendar.HOUR_OF_DAY) + calendar.get(Calendar.MINUTE)
				+ getAlphaNumericString(4) + calendar.get(Calendar.DATE)
				+ getAlphaNumericString(2) + calendar.get(Calendar.MONTH)
				+ getAlphaNumericString(1) + calendar.get(Calendar.MILLISECOND);
	}


	public String GetRandomNumber(int length) {

		// chose a Character random from this String
		String AlphaNumericString = "1234567890";

		// create StringBuffer size of AlphaNumericString
		return getRandomString(length, AlphaNumericString);
	}

	public String GetIdByLength(String type,int length) {

		return type + "_" + getAlphaNumericString(length);
	}

	public Map<String, String> GetRSAKeys() throws Exception {

		KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");

		keyGen.initialize(2048, new SecureRandom());
		KeyPair keypair = keyGen.generateKeyPair();
		PublicKey publicKey = keypair.getPublic();
		PrivateKey privateKey = keypair.getPrivate();
		PemObject pemObjectPrivateKey = new PemObject("RSA PRIVATE KEY", privateKey.getEncoded());
		StringWriter prvKey = new StringWriter();
		PEMWriter pemPrivateKey = new PEMWriter(prvKey);
		pemPrivateKey.writeObject(pemObjectPrivateKey);
		pemPrivateKey.close();
		prvKey.close();
		PemObject pemObjectPublicKey = new PemObject("PUBLIC KEY", publicKey.getEncoded());
		StringWriter pubKey = new StringWriter();
		PEMWriter pemPublicKey = new PEMWriter(pubKey);
		pemPublicKey.writeObject(pemObjectPublicKey);
		pemPublicKey.close();
		pubKey.close();
		Map<String, String> keys = new HashMap<>();
		keys.put("private", prvKey.toString());
		keys.put("public", pubKey.toString());
		return keys;
	}

}
