package company.tap.commondependencies.Currency;

import company.tap.commondependencies.ApiModels.Name;
import company.tap.commondependencies.Country.Country;
import company.tap.commondependencies.Country.ICountryServices;
import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.*;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Service
class CurrencyServices implements ICurrencyServices {

    final
    IErrorServices _errorServices;

    final
    ICountryServices _countryServices;

    private final String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();

    public CurrencyServices(IErrorServices _errorServices, ICountryServices _countryServices) {
        this._errorServices = _errorServices;
        this._countryServices = _countryServices;
    }

    private Currency getCurrency(String Code) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
            return RestAPI.getInstance()
                    .exchange(CommonApi + "currency/iso/" + Code, HttpMethod.GET, entityToken, Currency.class)
                    .getBody();
        } catch (Exception e) {
            return null;
        }
    }

    public Currency getCurrencyByCountryIso2(String CountryCode) {
        return getCurrency(CountryCode);
    }

    public Currency getCurrencyByCurrencyCode(String CurrencyCode) {
        return getCurrency(CurrencyCode);
    }

    public Currency getCurrencyById(String CurrencyId) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
            return RestAPI.getInstance()
                    .exchange(CommonApi + "currency/" + CurrencyId, HttpMethod.GET, entityToken, Currency.class)
                    .getBody();

        } catch (Exception e) {
            return null;
        }
    }

    public ResponseEntity<Object> validateCurrencyCodeByCountry(String currencyCode, String countryCode) {
        Currency currency = getCurrency(currencyCode);
        if (currency == null)
            return _errorServices.Error(Errors.Not_Found.getCode(), Errors.Not_Found.toString(),
                    "Invalid ISO CurrencyCode", HttpStatus.NOT_FOUND);
        Country country = _countryServices.getCountryByCountryIso(countryCode);
        if (country == null)
            return _errorServices.Error(Errors.Not_Found.getCode(), Errors.Not_Found.toString(),
                    "Invalid ISO Country Code", HttpStatus.NOT_FOUND);
        List<String> currencies = new ArrayList<>();
        switch (country.getIso2()) {
            case "KW":
                currencies.add("KWD");
                currencies.add("USD");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
            case "AE":
                currencies.add("AED");
                currencies.add("USD");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
            case "SA":
                currencies.add("SAR");
                currencies.add("USD");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
            case "BH":
                currencies.add("BHD");
                currencies.add("USD");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
            case "OM":
                currencies.add("OMR");
                currencies.add("USD");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
            case "LB":
            case "JO":
                currencies.add("USD");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
            case "EG":
                currencies.add("USD");
                currencies.add("EGP");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
            default:
                currencies.add("USD");
                currencies.add("EUR");
                currencies.add("GBP");
                if (!currencies.contains(currency.getCode().getEnglish())) {
                    return _errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(),
                            "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
                }
                break;
        }
        return null;
    }

    private JSONArray getCurrencies() {
        //JSON parser object to parse read file
        JSONParser jsonParser = new JSONParser();
        Resource resource = new ClassPathResource("Currency.json");
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream())) {
            //Read JSON file
            Object obj = jsonParser.parse(reader);
            return (JSONArray) obj;
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Currency getCurrencyByIdLocal(String id) {
        try {
            JSONArray countries = getCurrencies();
            if (countries == null)
                return null;
            JSONObject currency =
                    (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("currencyId").equals(
                            id)).findFirst().get();
            return prepareCurrencyResponse(currency);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Currency getCurrencyByCodeLocal(String code) {
        try {
            JSONArray countries = getCurrencies();
            if (countries == null)
                return null;
            JSONObject currency =
                    (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("english").equals(
                            code)).findFirst().get();
            return prepareCurrencyResponse(currency);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    private Currency prepareCurrencyResponse(JSONObject jsonObject) {
        Currency currency = new Currency();
        currency.decimals = Integer.parseInt(jsonObject.get("decimals").toString());
        currency.currencyId = jsonObject.get("currencyId").toString();
        Code code = new Code();
        code.english = jsonObject.get("english").toString();
        code.textId = jsonObject.get("textId").toString();
        currency.code = code;
        JSONObject nameJson = (JSONObject) jsonObject.get("name");
        Name name = new Name();
        name.textId = nameJson.get("textId").toString();
        name.english = nameJson.get("english").toString();
        currency.name = name;
        currency.created = Long.parseLong(jsonObject.get("created").toString());
        currency.country = jsonObject.get("country").toString();
        currency.symbol = jsonObject.get("symbol").toString();
        return currency;
    }

}
