/*
 * Copyright (c) 2021. Tap Payments
 * Author: Charan Dommara
 * Created On: 27 5 2021
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper=false)
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiWalletBalance extends ApiBaseModel {
    @JsonProperty("wallet_id")
    public String walletId;
    public String currency;
    public Total authorized;
    public Total voided;
    public Total captured;
    public Total settled;
    @JsonProperty("net_amount")
    public double netAmount;
    @JsonProperty("net_available_amount")
    public double netAvailableAmount;
    public Total rewards;
    @JsonProperty("net_rewards_amount")
    public double netRewardsAmount;
    @JsonProperty("total_amount")
    public double totalAmount;

    @Data
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Total{
        @JsonProperty("total_debit")
        public double totalDebit;
        @JsonProperty("total_credit")
        public double totalCredit;
    }

}
