package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiOrder extends ApiBaseModel {
    public String currency;
    public Double amount;
    public ApiCustomer customer;
    public List<ApiItem> items;
    public List<ApiTax> tax;
    public ApiShipment shipping;
    public Charge charge;
    public Map<String, String> metadata;
    public Reference reference;
    public ApiProduct.Business business;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Charge {
        public String id;
        public String status;
        public String source;
        public String created;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Reference {
        public String invoice;
        public String order;
        public List<ApiDocuments> documents;
        public String id;
    }


}


