package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiItem {
    public String id;
    public ApiProduct product;
    public ApiText name;
    public ApiText description;
    public String image;
    public String currency;
    public Double amount;
    public Integer quantity;
    public Discount discount;
    public String merchant_id;
    @JsonProperty("item_code")
    public String itemCode;
    @JsonProperty("account_code")
    public String accountCode;
    public ApiProduct.ProdReference reference;
    public Map<String, String> metadata;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Discount {
        public String type;
        public Double value;
    }
}

