package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiEntity extends ApiBaseModel {
	
	@NotNull
	public ApiText legal_name;
	@JsonProperty("is_licensed")
	public boolean is_licensed;
	public String license_number;
	public ApiLicense license;
	@JsonProperty("not_for_profit")
	public boolean not_for_profit;
	@NotNull
	public String country;
	public String currency_code;
	@JsonProperty("taxable")
	public boolean taxable;
	@JsonProperty("tax_number")
	public String taxNumber;
	public String settlement_by;
	public ApiSettlement settlement; //Added on 27OCT
	public List<ApiDocuments> documents;
	public List<ApiWallet> wallets;
	public List<ApiBranch> branches;
	public ApiBankAccount bank_account; //Added on 07OCT as goSell create account requires iban
	public ApiOperator operator; // Added to return default operator
	public List<ApiBankAccount> bank_accounts;
	@JsonProperty("billing_address")
	public ApiAddress billingAddress;
  }
