package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.HashMap;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id","status","created","object","live_mode","api_version","feature_version","title","first_name",
		"middle_name","last_name","email","phone","description","currency","nationality","metadata"})
public class ApiCustomer extends ApiBaseModel {
	@JsonProperty("first_name")
	public String firstName;
	@JsonProperty("middle_name")
	public String middleName;
	@JsonProperty("last_name")
	public String lastName;
	@JsonProperty("email")
	public String email;
	@JsonProperty("phone")
	public ApiPhone phone;
	@JsonProperty("description")
	public String description;
	@JsonProperty("currency")
	public String currency;
	@JsonProperty("title")
	public String title;
	@JsonProperty("nationality")
	public String nationality;
	@JsonProperty("business_id")
	public String businessId;
	@JsonProperty("business_entity_id")
	public String entityId;
	@JsonProperty("metadata")
	public HashMap<String, String> metaData;
	@JsonProperty("identification")
	public List<ApiDocuments> apiDocuments;


}
