/*
 * Decompiled with CFR 0.152.
 */
package code316.gui;

import code316.beans.BeanProperty;
import code316.gui.EasyTableModel;
import code316.gui.ModelDescription;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;

public class BeanTableModel
extends AbstractTableModel
implements EasyTableModel {
    private final List beans = new ArrayList();
    private ModelDescription modelDescription;
    private boolean allowDuplicates;
    private Map methods = new HashMap();
    private Map propertyNames = new HashMap();
    private Map methodNames = new HashMap();

    public BeanTableModel(ModelDescription model) {
        this.modelDescription = model;
    }

    public List getBeans() {
        return new ArrayList(this.beans);
    }

    public Collection getAll() {
        return new ArrayList(this.beans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object bean) {
        List list = this.beans;
        synchronized (list) {
            this.insert(this.beans.size(), bean);
        }
    }

    public void addAll(Collection beans) {
        Iterator tor = beans.iterator();
        while (tor.hasNext()) {
            this.add(tor.next());
        }
    }

    public void add(List beans) {
        this.addAll(beans);
    }

    public Object get(int index) {
        if (index >= this.beans.size()) {
            return null;
        }
        return this.beans.get(index);
    }

    public void setData(Collection beans) {
        this.clear();
        this.addAll(beans);
    }

    public void clear() {
        int size = this.beans.size();
        this.beans.clear();
        this.fireTableRowsDeleted(0, 0);
    }

    public int indexOf(Object o) {
        return this.beans.indexOf(o);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String defaultValue = "could not get property";
        try {
            String propertyString = this.modelDescription.getPropertyNames()[columnIndex];
            String[] names = (String[])this.propertyNames.get(propertyString);
            if (names == null) {
                names = BeanTableModel.parsePropertyNames(this.modelDescription.getPropertyNames()[columnIndex]);
                this.propertyNames.put(propertyString, names);
            }
            Object callee = this.beans.get(rowIndex);
            Object result = null;
            int i = 0;
            while (i < names.length) {
                String propertyName = names[i];
                Method m = this.findMethod(propertyName, callee);
                result = m.invoke(callee, null);
                callee = result;
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            defaultValue = defaultValue + ": " + e;
            return defaultValue;
        }
    }

    private Method findMethod(String propertyName, Object bean) throws NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("bean is null");
        }
        String methodId = bean.getClass() + ":" + propertyName;
        String methodName = (String)this.methodNames.get(methodId);
        if (methodName == null && propertyName.endsWith("()")) {
            String newName = propertyName.substring(0, propertyName.length() - 2);
            Method m = bean.getClass().getMethod(newName, null);
            this.methodNames.put(methodId, newName);
            this.methods.put(methodId, m);
            return m;
        }
        if (methodName == null) {
            methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            this.methodNames.put(methodId, methodName);
        }
        Method m = (Method)this.methods.get(methodId);
        try {
            if (m == null) {
                m = bean.getClass().getMethod(methodName, null);
                this.methods.put(methodId, m);
            }
        }
        catch (NoSuchMethodException e) {
            methodName = "is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            this.methodNames.put(methodId, methodName);
            m = bean.getClass().getMethod(methodName, null);
            this.methods.put(methodId, m);
        }
        return m;
    }

    public int getColumnCount() {
        return this.modelDescription.getColumnCount();
    }

    public int getRowCount() {
        return this.beans.size();
    }

    public String getColumnName(int columnIndex) {
        try {
            return this.modelDescription.getColumnNames()[columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("unknown property index: " + columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(Object bean) {
        List list = this.beans;
        synchronized (list) {
            int index = this.beans.indexOf(bean);
            if (index >= 0) {
                this.beans.remove(index);
                this.fireTableRowsDeleted(index - 1, index - 1);
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        try {
            return this.modelDescription.getClasses()[columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("unknown column index: " + columnIndex);
        }
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Object bean = this.get(rowIndex);
        BeanProperty bp = this.modelDescription.getFields()[columnIndex];
        try {
            bp.getSetter().invoke(bean, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int index, Object o) {
        List list = this.beans;
        synchronized (list) {
            if (!this.allowDuplicates && this.beans.contains(o)) {
                return;
            }
            this.beans.add(index, o);
        }
        this.fireTableRowsInserted(index, index);
    }

    static String[] parsePropertyNames(String propertyName) {
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(propertyName, ".");
        while (st.hasMoreTokens()) {
            names.add(st.nextToken());
        }
        return names.toArray(new String[0]);
    }
}

