/*
 * Decompiled with CFR 0.152.
 */
package code316.event;

import code316.event.Propagator;
import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MessagePump {
    private Method[] methods;
    private Propagator[] propagators;
    private Class listenerType;
    private List listeners = new LinkedList();

    public MessagePump(Class listenerType) {
        this.methods = listenerType.getMethods();
        this.listenerType = listenerType;
    }

    public boolean removeListener(Object listener) {
        return this.listeners.remove(listener);
    }

    public void addListener(Object listener) {
        if (!Beans.isInstanceOf(listener, this.listenerType)) {
            throw new IllegalArgumentException("wrong type for listener.  expected: " + this.listenerType + " received: " + listener.getClass());
        }
        this.listeners.add(listener);
    }

    public void pump(String methodName) {
        this.pump(methodName, null);
    }

    public void pump(String methodName, Object arg) {
        block7: {
            try {
                Method m = MessagePump.getMethod(methodName, this.methods);
                if (m != null) {
                    Iterator tor = Collections.unmodifiableList(this.listeners).iterator();
                    while (tor.hasNext()) {
                        if (arg != null) {
                            m.invoke((Object)methodName, arg);
                            continue;
                        }
                        m.invoke((Object)methodName, null);
                    }
                    break block7;
                }
                throw new IllegalStateException("unknown method: " + methodName);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void pump(String methodName, Object[] args) {
    }

    private static Method getMethod(String name, Method[] methods) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }
}

