/*
 * Decompiled with CFR 0.152.
 */
package code316.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Category
extends OutputStream {
    private static PrintStream commonOut;
    private static int id;
    public static final int DEBUG = 50;
    public static final int INFO = 40;
    public static final int WARN = 30;
    public static final int ERROR = 20;
    public static final int FATAL = 10;
    private int instanceId = id++;
    private int logLevel = 50;
    private boolean capturing = false;
    private PrintStream out = null;
    private StringBuffer captured;
    private String name = "";
    private String prefix = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("ddMMMyyyy kk:mm:ss");

    public Category(Class _class) {
        this(_class.getName());
    }

    public Category(String name) {
        this.setName(name);
    }

    public Category() {
        this("NONAME");
    }

    public Category(int logLevel) {
        this("NONAME");
        this.setLogLevel(logLevel);
    }

    public Category(final OutputStream os, String name) {
        this.out = new PrintStream(os);
        if (commonOut == null) {
            commonOut = this.out;
        }
        this.setName(name);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Category getInstance(Class _class) {
        return new Category(_class);
    }

    private static int getLevelForName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("invalid value for name: " + name);
        }
        if (name.equals("DEBUG")) {
            return 50;
        }
        if (name.equals("INFO")) {
            return 40;
        }
        if (name.equals("ERROR")) {
            return 20;
        }
        if (name.equals("FATAL")) {
            return 10;
        }
        if (name.equals("WARN")) {
            return 30;
        }
        throw new IllegalStateException("unknown level name: " + name);
    }

    public static void main(String[] args) {
        int level = Category.getLevelForName(args[0]);
        Category log = new Category("TT");
        log.setLogLevel(level);
        System.out.println("loglevel set to:" + level);
        log.debug("DEBUG MESSAGE");
        log.info("INFO MESSAGE");
        log.fatal("FATAL MESSAGE");
        log.error("ERROR MESSAGE");
        log.warn("WARN MESSAGE");
    }

    public void debug(Object o) {
        if (this.logLevel < 50) {
            return;
        }
        this.outImpl(o, 50);
    }

    public void debug(Object o, Throwable t) {
        if (this.logLevel < 50) {
            return;
        }
        this.outImpl(o, 50);
        this.outImpl(t, 50);
    }

    private void errorImpl(Object o) {
        if (this.logLevel < 20) {
            return;
        }
        this.outImpl(o, 20);
    }

    public void error(Object o) {
        this.errorImpl(o);
    }

    public void error(Object o, Throwable t) {
        this.errorImpl(o);
        this.errorImpl(t);
    }

    public void info(Object o) {
        if (this.logLevel < 40) {
            return;
        }
        this.outImpl(o, 40);
    }

    public void info(Object o, Throwable t) {
        if (this.logLevel < 40) {
            return;
        }
        this.info(o);
        this.info(t);
    }

    public void warn(Object o) {
        if (this.logLevel < 30) {
            return;
        }
        this.outImpl(o, 30);
    }

    public void warn(Object o, Throwable t) {
        this.warn(o);
        this.warn(t);
    }

    public void fatal(Object o) {
        if (this.logLevel < 10) {
            return;
        }
        this.outImpl(o, 10);
    }

    public void fatal(Object o, Throwable t) {
        this.errorImpl(o);
        this.errorImpl(t);
    }

    private String getTimeStamp() {
        return this.formatter.format(new Date());
    }

    private String getLevelPrefix(int level) {
        switch (level) {
            case 50: {
                return "DEBUG] ";
            }
            case 40: {
                return "INFO] ";
            }
            case 20: {
                return "ERROR] ";
            }
            case 30: {
                return "WARN] ";
            }
            case 10: {
                return "FATAL] ";
            }
        }
        return "FAULT] ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outImpl(Object o, int level) {
        String value = String.valueOf(o);
        String entry = "[" + this.getTimeStamp() + "-" + Thread.currentThread().getName() + ":" + this.prefix + this.getLevelPrefix(level) + value;
        if (o instanceof Throwable) {
            ((Throwable)o).printStackTrace();
        }
        if (commonOut != null) {
            PrintStream printStream = commonOut;
            synchronized (printStream) {
                commonOut.println(entry);
                if (o instanceof Properties) {
                    ((Properties)o).list(commonOut);
                }
                if (o instanceof Throwable) {
                    ((Throwable)o).printStackTrace(commonOut);
                }
                commonOut.flush();
            }
            if (this.out != null && this.out != commonOut) {
                this.out.println(entry);
                if (o instanceof Properties) {
                    ((Properties)o).list(this.out);
                }
                if (o instanceof Throwable) {
                    ((Throwable)o).printStackTrace(this.out);
                }
                this.out.flush();
            }
        }
        System.out.println(entry);
        if (this.capturing) {
            this.captured.append(entry + "\n");
        }
    }

    public String getCaptured(boolean reset) {
        String capturedContent = this.getCaptured();
        if (reset && this.captured != null) {
            this.captured.setLength(0);
        }
        return capturedContent;
    }

    public String getCaptured() {
        if (this.captured != null) {
            return this.captured.toString();
        }
        return null;
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public void setCapturing(boolean capturing) {
        this.capturing = capturing;
        if (this.capturing && this.captured == null) {
            this.captured = new StringBuffer();
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
        String shortName = name;
        int pos = shortName.lastIndexOf(46);
        if (pos != -1 && pos < shortName.length() - 1) {
            shortName = shortName.substring(pos + 1);
        }
        this.prefix = shortName + "(" + this.instanceId + ")-";
    }

    public static String getStackTrace() {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter(sout);
        Exception e = new Exception();
        e.printStackTrace(out);
        out.close();
        String breakAt = "at ";
        int pos = sout.toString().indexOf(breakAt);
        return sout.toString().substring(pos + breakAt.length());
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.info(new String(b, off, len));
    }

    public void write(byte[] b) throws IOException {
        this.info(new String(b));
    }

    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer);
    }

    static {
        id = 1;
    }
}

