/*
 * Decompiled with CFR 0.152.
 */
package code316.classloading;

import code316.classloading.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassLoaderX
extends ClassLoader {
    private static int id = 1;
    private static List loaders = Collections.synchronizedList(new ArrayList());
    private static ClassLoaderX root;
    private List sources = new ArrayList();
    private boolean archivesLoaded;
    private Hashtable loaded = new Hashtable();
    private String name = "";
    private int myId = id++;
    private Logger log;

    public ClassLoaderX(String name) {
        this.log = new Logger(name);
        this.log.debug("created loader (default parent): " + name);
        this.log.debug("adding self (root) to loaders");
    }

    public ClassLoaderX(ClassLoader parent, String name) {
        super(parent);
        this.log = new Logger(name);
        this.log.debug("created loader: " + name);
        if (parent instanceof ClassLoaderX) {
            this.log.debug("parent is ClassLoaderX");
        }
        this.log.debug("adding self to loaders");
    }

    public Class findClass(String name) {
        this.log.debug("find class called");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.log.debug("thread loader: " + cl);
        if (!(this.getParent() instanceof ClassLoaderX) && cl instanceof ClassLoaderX && cl != this) {
            this.log.debug("cascading load to thread loader");
            ClassLoaderX l = (ClassLoaderX)cl;
            return l.findClass(name);
        }
        return this.findClassDirect(name);
    }

    public List which(String name) {
        ArrayList found = new ArrayList();
        Iterator tor = this.sources.iterator();
        while (tor.hasNext()) {
            Object source = tor.next();
            InputStream in = null;
            try {
                in = this.getInputStream(source, name);
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (in == null) continue;
            if (found == null) {
                found = new ArrayList();
            }
            found.add(source);
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return found;
    }

    protected Class findClassDirect(String name) {
        String classFileName = this.getClassFileName(name);
        if (this.loaded.containsKey(classFileName)) {
            this.log.debug("using cached class");
            return (Class)this.loaded.get(name);
        }
        byte[] buffer = this.loadBytes(classFileName);
        if (buffer == null) {
            this.log.debug("class not found, will try parent loader");
            if (root != this || this.getParent() == null) {
                throw new IllegalStateException("no parent to load class from: " + name);
            }
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                this.log.error("parent couldn't load class");
                throw new NoClassDefFoundError("could not load class: " + name);
            }
        }
        this.log.debug("calling define class: " + name);
        Class<?> _class = this.defineClass(name, buffer, 0, buffer.length);
        this.log.debug("parent defined class: " + name);
        this.loaded.put(classFileName, _class);
        ClassLoader cl = _class.getClassLoader();
        if (cl != this) {
            this.log.debug("why aren't we the loader!!!");
        }
        return _class;
    }

    public void clearCache() {
        this.loaded.clear();
    }

    private byte[] loadBytes(String name) {
        this.log.debug("loading resource: " + name);
        try {
            Iterator tor = this.sources.iterator();
            while (tor.hasNext()) {
                Object source = tor.next();
                InputStream in = this.getInputStream(source, name);
                if (in == null) continue;
                return this.getBytesFromStream(in);
            }
        }
        catch (IOException e) {
            this.log.debug(e);
        }
        return null;
    }

    private byte[] getBytesFromStream(InputStream source) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean bytesRead = false;
        byte[] buffer = new byte[4096];
        int read = -1;
        while ((read = source.read(buffer)) != -1) {
            this.log.debug("read: " + read);
            out.write(buffer, 0, read);
        }
        source.close();
        return out.toByteArray();
    }

    private String getClassFileName(String className) {
        if (className == null) {
            throw new IllegalArgumentException("invalid value for className: " + className);
        }
        this.log.debug("getting class name for: " + className);
        if (className.endsWith(".class")) {
            int lastDot = className.lastIndexOf(46);
            className = className.substring(0, lastDot);
        }
        char[] buffer = className.toCharArray();
        char[] newBuffer = new char[buffer.length];
        int i = 0;
        while (i < buffer.length) {
            int ch = buffer[i];
            newBuffer[i] = ch == 46 ? 47 : ch;
            ++i;
        }
        this.log.debug("built classname: " + new String(newBuffer) + ".class");
        return new String(newBuffer) + ".class";
    }

    public static void main(String[] args) {
    }

    private static List getChildren(File path) throws FileNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("invalid value for path: " + path);
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory");
        }
        ArrayList<File> children = new ArrayList<File>();
        File[] files = path.listFiles();
        int i = 0;
        while (i < files.length) {
            children.add(files[i]);
            ++i;
        }
        return children;
    }

    public void addClassSource(String source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("invalid value for element: " + source);
        }
        if (source.toLowerCase().endsWith(".jar") || source.toLowerCase().endsWith(".zip")) {
            try {
                JarFile jar = new JarFile(new File(source));
                this.log.debug("adding source as jar: " + source);
                this.sources.add(jar);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (!source.endsWith(File.separator)) {
                source = source + File.separator;
            }
            this.log.debug("adding source as path: " + source);
            File path = new File(source);
            if (!path.exists() || !path.isDirectory()) {
                throw new IOException(path + " does not exist or is not a directory");
            }
            this.sources.add(path);
        }
    }

    public InputStream getResourceAsStream(String name) {
        byte[] bytes = this.loadBytes(name);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public byte[] getResourceBytes(String name) {
        return this.loadBytes(name);
    }

    private InputStream getInputStream(Object source, String name) throws IOException {
        if (source instanceof JarFile) {
            return this.getInputStream((JarFile)source, name);
        }
        if (source instanceof File) {
            return this.getInputStream((File)source, name);
        }
        throw new IllegalStateException("don't know how to load from source: " + source);
    }

    private InputStream getInputStream(JarFile source, String name) throws IOException {
        this.log.debug("looking for archive entry: " + name);
        if (name.indexOf("jtds") != -1) {
            Enumeration<JarEntry> e = source.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                this.log.debug("entry: " + entry.getName());
            }
        }
        if (source.getEntry(name) == null) {
            return null;
        }
        this.log.debug("found resource in: " + source.getName());
        return source.getInputStream(source.getEntry(name));
    }

    private InputStream getInputStream(File source, String name) throws IOException {
        File file = new File(source + File.separator + name);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

