/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.util;

import coconut.aio.AioFuture;
import coconut.core.Callback;
import coconut.core.Colored;
import coconut.core.Offerable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AioFutureTask<V, T>
implements Runnable,
AioFuture<V, T>,
Callable<V> {
    private final Sync sync;
    private final Executor e;
    private final Offerable<? super T> o;
    private volatile Offerable<? super T> newOfferable;
    private volatile Callback<V> callback;
    private volatile Executor newExecutor;

    public AioFutureTask(Executor e, Offerable<? super T> o) {
        this.e = e;
        this.o = o;
        this.sync = new Sync(this);
    }

    @Override
    public V call() throws Exception {
        throw new IllegalStateException("Call not allowed");
    }

    public boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    public boolean isDone() {
        return this.sync.innerIsDone();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.innerCancel(mayInterruptIfRunning);
    }

    public V get() throws InterruptedException, ExecutionException {
        return this.sync.innerGet();
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.sync.innerGet(unit.toNanos(timeout));
    }

    public V getIO() throws IOException {
        try {
            return this.get();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Unknown exception", cause);
        }
    }

    public V getIO(long timeout, TimeUnit unit) throws IOException, TimeoutException {
        try {
            return this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Unknown exception", cause);
        }
    }

    public void setDest(Offerable<? super T> offerable) {
        this.newOfferable = offerable;
        this.sync.checkState();
    }

    public void setCallback(Executor executor, Callback<V> callback) {
        this.newExecutor = executor;
        this.callback = callback;
        this.sync.checkState();
    }

    public void setCallback(Callback<V> callback) {
        if (this.e == null) {
            throw new IllegalStateException("No default executor specified");
        }
        this.callback = callback;
        this.sync.checkState();
    }

    protected void doneSet(final Object v) {
        Callback<V> c;
        Offerable<? super T> offer;
        if (this.o != null) {
            this.o.offer((Object)this);
        }
        if ((offer = this.newOfferable) != null) {
            offer.offer((Object)this);
            this.newOfferable = null;
        }
        if ((c = this.callback) != null) {
            Executor exec = this.newExecutor;
            Runnable r = new Runnable(){

                public void run() {
                    c.completed(v);
                }
            };
            if (exec != null) {
                exec.execute(r);
            } else {
                this.e.execute(r);
            }
            this.callback = null;
        }
    }

    protected abstract void deliverFailure(Offerable<? super T> var1, Throwable var2);

    protected abstract int getColor();

    protected void doneException(final Throwable t) {
        Callback<V> c;
        Offerable<? super T> offer;
        if (this.o != null) {
            this.deliverFailure(this.o, t);
        }
        if ((offer = this.newOfferable) != null) {
            this.deliverFailure(offer, t);
            this.newOfferable = null;
        }
        if ((c = this.callback) != null) {
            Executor exec = this.newExecutor;
            ColoredRunnable r = new ColoredRunnable(){

                public void run() {
                    c.failed(t);
                }

                public int getColor() {
                    return this.getColor();
                }
            };
            if (exec != null) {
                exec.execute(r);
            } else {
                this.e.execute(r);
            }
            this.callback = null;
        }
    }

    protected void set(V v) {
        this.sync.innerSet(v);
    }

    protected void setException(Throwable t) {
        this.sync.innerSetException(t);
    }

    @Override
    public void run() {
        this.sync.innerRun();
    }

    private static interface ColoredRunnable
    extends Colored,
    Runnable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int RUNNING = 1;
        private static final int RAN = 2;
        private static final int CANCELLED = 4;
        private final Callable<V> callable;
        private V result;
        private Throwable exception;
        private volatile Thread runner;
        private final Lock lock = new ReentrantLock();

        Sync(Callable<V> callable) {
            this.callable = callable;
        }

        private boolean ranOrCancelled(int state) {
            return (state & 6) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            this.runner = null;
            return true;
        }

        boolean innerIsCancelled() {
            return this.getState() == 4;
        }

        boolean innerIsDone() {
            return this.ranOrCancelled(this.getState()) && this.runner == null;
        }

        V innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        V innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkState() {
            int s = this.getState();
            if (this.ranOrCancelled(s)) {
                this.lock.lock();
                try {
                    if (this.innerIsCancelled()) {
                        AioFutureTask.this.doneException(new InterruptedIOException("operation was cancelled"));
                    } else if (this.exception != null) {
                        AioFutureTask.this.doneException(this.exception);
                    } else {
                        AioFutureTask.this.doneSet(this.result);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        void innerSet(V v) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.result = v;
            this.releaseShared(0);
            AioFutureTask.this.doneSet(v);
        }

        void innerSetException(Throwable t) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.exception = t;
            this.result = null;
            this.releaseShared(0);
            this.checkState();
        }

        boolean innerCancel(boolean mayInterruptIfRunning) {
            Thread r;
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 4));
            if (mayInterruptIfRunning && (r = this.runner) != null) {
                r.interrupt();
            }
            this.releaseShared(0);
            this.checkState();
            return true;
        }

        void innerRun() {
            if (!this.compareAndSetState(0, 1)) {
                return;
            }
            try {
                this.runner = Thread.currentThread();
                this.innerSet(this.callable.call());
            }
            catch (Throwable ex) {
                this.innerSetException(ex);
            }
        }

        boolean innerRunAndReset() {
            if (!this.compareAndSetState(0, 1)) {
                return false;
            }
            try {
                this.runner = Thread.currentThread();
                this.callable.call();
                this.runner = null;
                return this.compareAndSetState(1, 0);
            }
            catch (Throwable ex) {
                this.innerSetException(ex);
                return false;
            }
        }
    }
}

