/*
 * Decompiled with CFR 0.152.
 */
package coconut.aio.impl.nio;

import coconut.aio.AioFuture;
import coconut.aio.AsyncSocket;
import coconut.aio.ReadHandler;
import coconut.aio.impl.BaseSocket;
import coconut.aio.impl.BaseSocketGroup;
import coconut.aio.impl.nio.DefaultAioSelector;
import coconut.aio.impl.nio.NioAioProvider;
import coconut.aio.impl.util.AioFutureTask;
import coconut.aio.impl.util.ByteBufferUtil;
import coconut.aio.monitor.SocketMonitor;
import coconut.core.EventHandler;
import coconut.core.Offerable;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NioSocket
extends BaseSocket {
    private final DefaultAioSelector netHandler;
    public final SocketChannel channel;
    private final AtomicInteger writeState = new AtomicInteger();
    private static final int WRITE_NOOP = 0;
    private static final int WRITE_USER_THREAD = 1;
    private static final int WRITE_SELECTOR_THREAD = 2;
    private static final int WRITE_FILE_TRANSFER = 3;
    private final Queue<Writeable> writes = new ConcurrentLinkedQueue<Writeable>();
    private volatile Writeable currentWrite;
    private Callable cancelWrite;
    private int numberOfEmptyWriteSelects;
    private int writeAttempts;
    private final Lock readLock = new ReentrantLock();
    private Callable cancelRead;

    NioSocket(DefaultAioSelector handler, NioAioProvider provider, long id, SocketChannel channel, SocketMonitor monitor, Offerable<? super AsyncSocket.Event> destination, Executor executor) {
        super(id, monitor, provider, destination, executor);
        this.netHandler = handler;
        this.channel = channel;
    }

    public Socket socket() {
        return this.channel.socket();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    @Override
    protected boolean tryQuickConnect(BaseSocket.ConnectedEvent c) throws IOException {
        return this.channel.connect(c.getSocketAddress());
    }

    @Override
    protected void asynchronousConnect(final BaseSocket.ConnectedEvent c) {
        this.netHandler.socketRegisterConnectCommand(new Runnable(){

            public void run() {
                try {
                    NioSocket.this.netHandler.socketStartConnecting(NioSocket.this, NioSocket.this.channel, new EventHandler(){

                        public void handle(Object key) {
                            try {
                                if (!NioSocket.this.channel.finishConnect()) {
                                    throw new IllegalStateException("Bug in the NIO implementation");
                                }
                                ((SelectionKey)key).cancel();
                                c.set(NioSocket.this);
                            }
                            catch (RuntimeException e) {
                                c.setException(e);
                                NioSocket.this.connectClose(e);
                            }
                            catch (IOException e) {
                                c.setException(e);
                                NioSocket.this.connectClose(e);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    c.setException(e);
                    NioSocket.this.connectClose(e);
                }
                catch (IOException e) {
                    c.setException(e);
                    NioSocket.this.connectClose(e);
                }
            }
        });
    }

    public AioFuture<Long, AsyncSocket.Event> writeAsync(ByteBuffer[] buffer, int offset, int length) {
        this.checkBufferLimit(ByteBufferUtil.calcSize(buffer));
        WrittenEvent future = new WrittenEvent(this, buffer, offset, length);
        this.writes.add(future);
        this.tryAndWriteSocketEvents();
        return future;
    }

    public List<AsyncSocket.Written> getOutstandingWrites() {
        ArrayList w = new ArrayList(this.writes.size());
        ArrayList<AsyncSocket.Written> l = new ArrayList<AsyncSocket.Written>(w.size());
        Writeable current = this.currentWrite;
        if (!w.contains(current) && current instanceof AsyncSocket.Written) {
            l.add((AsyncSocket.Written)current);
        }
        for (Writeable wr : w) {
            if (!(wr instanceof AsyncSocket.Written)) continue;
            l.add((AsyncSocket.Written)wr);
        }
        return l;
    }

    @Override
    protected void outerClose(Throwable e) {
        this.connectClose(e);
    }

    private void readClose(Throwable e) {
        this.connectClose(e);
    }

    private void writeClose(Throwable e) {
        this.connectClose(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReader(final ReadHandler<AsyncSocket> handler) {
        this.readLock.lock();
        try {
            this.setBaseReader(handler);
        }
        finally {
            this.readLock.unlock();
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EventHandler h = new EventHandler(){

                    public void handle(Object ignore) {
                        NioSocket.this.readAvailable();
                    }
                };
                NioSocket.this.readLock.lock();
                try {
                    NioSocket.this.cancelRead = NioSocket.this.netHandler.socketStartReading(NioSocket.this, NioSocket.this.channel, h);
                }
                catch (IOException e) {
                    try {
                        handler.handle((Object)NioSocket.this);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    NioSocket.this.readClose(e);
                }
                finally {
                    NioSocket.this.readLock.unlock();
                }
            }
        };
        this.netHandler.socketRegisterReadCommand(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAvailable() {
        boolean gotLock = this.readLock.tryLock();
        if (gotLock) {
            try {
                ReadHandler<AsyncSocket> r = this.getReader();
                if (r != null) {
                    try {
                        r.handle((Object)this);
                    }
                    catch (IOException e) {
                        this.readClose(e);
                    }
                    catch (RuntimeException e) {
                        this.readClose(e);
                    }
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] srcs, int offset, int length) {
        this.readLock.lock();
        try {
            SocketMonitor m = this.getMonitor();
            if (m != null) {
                try {
                    m.preRead((AsyncSocket)this, srcs, offset, length);
                }
                catch (RuntimeException e) {
                    this.readClose(e);
                }
            }
            long read = this.channel.read(srcs, offset, length);
            if (m != null) {
                try {
                    m.postRead((AsyncSocket)this, read, srcs, offset, length, null);
                }
                catch (RuntimeException e) {
                    this.readClose(e);
                }
            }
            if (read > 0L) {
                this.bytesRead.addAndGet(read);
                this.mProvider.socketReadFinished(read);
                BaseSocketGroup grp = this.getGroup();
                if (grp != null) {
                    this.addNumberOfBytesRead(grp, read);
                }
            }
            if (read == -1L) {
                if (this.cancelRead != null) {
                    this.cancelRead.call();
                }
                this.readClose(new IOException("read returned -1"));
            }
            long l = read;
            return l;
        }
        catch (Exception e) {
            this.readClose(e);
            long l = -1L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long read(ByteBuffer[] srcs) {
        return this.read(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer src) {
        this.readLock.lock();
        try {
            SocketMonitor m = this.getMonitor();
            if (m != null) {
                try {
                    m.preRead((AsyncSocket)this, new ByteBuffer[]{src}, 0, 1);
                }
                catch (RuntimeException e) {
                    this.readClose(e);
                }
            }
            int read = this.channel.read(src);
            if (m != null) {
                try {
                    m.postRead((AsyncSocket)this, (long)read, new ByteBuffer[]{src}, 0, 1, null);
                }
                catch (RuntimeException e) {
                    this.readClose(e);
                }
            }
            if (read > 0) {
                this.bytesRead.addAndGet(read);
                this.mProvider.socketReadFinished(read);
                BaseSocketGroup grp = this.getGroup();
                if (grp != null) {
                    this.addNumberOfBytesRead(grp, read);
                }
            }
            if (read == -1) {
                if (this.cancelRead != null) {
                    this.cancelRead.call();
                }
                this.readClose(new IOException("read returned -1"));
            }
            int n = read;
            return n;
        }
        catch (Exception e) {
            this.readClose(e);
            int n = -1;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected void closeCommandRun(AsyncSocket.Closed task) throws IOException {
        this.channel.close();
    }

    @Override
    protected void tryAndWriteSocketEvents() {
        if (this.isConnected() && this.writeState.compareAndSet(0, 1)) {
            this.handleWrite();
        }
    }

    private void handleWrite() {
        int state = this.writeState.get();
        while (true) {
            if (this.currentWrite == null) {
                this.currentWrite = this.writes.poll();
            }
            if (this.currentWrite == null) {
                this.writeState.set(0);
                if (this.writes.peek() != null && this.writeState.compareAndSet(0, state)) continue;
                if (state == 2) {
                    try {
                        if (this.cancelWrite != null) {
                            this.cancelWrite.call();
                            this.cancelWrite = null;
                        }
                    }
                    catch (Exception e) {
                        this.writeClose(e);
                    }
                }
                return;
            }
            if (!this.currentWrite.runAndContinue(state)) break;
        }
    }

    TransferFromFileEvent createTransferFrom(CountDownLatch latch) {
        TransferFromFileEvent rffe = new TransferFromFileEvent(latch);
        this.writes.add(rffe);
        this.tryAndWriteSocketEvents();
        return rffe;
    }

    private class TransferFromFileEvent
    implements Writeable,
    Runnable {
        private final CountDownLatch latch;

        private TransferFromFileEvent(CountDownLatch latch) {
            this.latch = latch;
        }

        public void run() {
            NioSocket.this.writeState.set(1);
            NioSocket.this.currentWrite = null;
            NioSocket.this.handleWrite();
        }

        public boolean runAndContinue(int state) {
            NioSocket.this.writeState.set(3);
            this.latch.countDown();
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrittenEvent
    extends BaseNioEvent<Long>
    implements AsyncSocket.Written,
    EventHandler,
    Writeable {
        private final ByteBuffer[] srcs;
        private final int offset;
        private final int length;
        private volatile long bytesWritten;

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public ByteBuffer[] getSrcs() {
            return this.srcs;
        }

        public void handle(Object o) {
            NioSocket.this.handleWrite();
        }

        @Override
        public void run() {
            NioSocket.this.writeState.set(2);
            NioSocket.this.handleWrite();
        }

        @Override
        public boolean runAndContinue(int state) {
            int result = this.tryWrite();
            if (result == -1) {
                NioSocket.this.currentWrite = null;
                return true;
            }
            if (result == 0) {
                if (state == 1) {
                    NioSocket.this.netHandler.socketRegisterWriteCommand(this);
                } else if (NioSocket.this.cancelWrite == null) {
                    try {
                        NioSocket.this.cancelWrite = NioSocket.this.netHandler.socketStartWriting(NioSocket.this, NioSocket.this.channel, this);
                    }
                    catch (IOException ioe) {
                        NioSocket.this.writeClose(ioe);
                    }
                }
            }
            return false;
        }

        private int tryWrite() {
            long bytes;
            SocketMonitor m = NioSocket.this.getMonitor();
            if (m != null) {
                m.preWrite((AsyncSocket)NioSocket.this, this.getSrcs(), this.getOffset(), this.getLength());
            }
            try {
                bytes = this.getSrcs().length == 1 ? (long)NioSocket.this.channel.write(this.getSrcs()[0]) : NioSocket.this.channel.write(this.getSrcs(), this.getOffset(), this.getLength());
            }
            catch (Exception e) {
                if (m != null) {
                    m.postWrite((AsyncSocket)NioSocket.this, 0L, this.getSrcs(), this.getOffset(), this.getLength(), NioSocket.this.writeAttempts, (Throwable)e);
                }
                this.setException(e);
                NioSocket.this.writeAttempts = 0;
                return 1;
            }
            if (m != null) {
                m.postWrite((AsyncSocket)NioSocket.this, bytes, this.getSrcs(), this.getOffset(), this.getLength(), NioSocket.this.writeAttempts, null);
            }
            if (bytes > 0L) {
                this.bytesWritten += bytes;
                NioSocket.this.writeFinished(this);
            }
            if (!this.hasRemaining()) {
                NioSocket.this.writeAttempts++;
                return 0;
            }
            NioSocket.this.writeAttempts = 0;
            this.set(new Long(this.bytesWritten));
            return -1;
        }

        boolean hasRemaining() {
            for (int i = 0; i < this.length; ++i) {
                if (!this.srcs[i + this.offset].hasRemaining()) continue;
                return false;
            }
            return true;
        }

        WrittenEvent(AsyncSocket socket, ByteBuffer[] srcs, int offset, int length) {
            super(socket);
            this.srcs = srcs;
            this.offset = offset;
            this.length = length;
        }

        WrittenEvent(AsyncSocket socket, ByteBuffer src) {
            this(socket, new ByteBuffer[]{src}, 0, 1);
        }
    }

    private static interface Writeable {
        public boolean runAndContinue(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseNioEvent<V>
    extends AioFutureTask<V, AsyncSocket.Event>
    implements AsyncSocket.Event,
    AioFuture<V, AsyncSocket.Event> {
        private final AsyncSocket socket;

        public BaseNioEvent(AsyncSocket socket) {
            super(socket.getDefaultExecutor(), socket.getDefaultDestination());
            this.socket = socket;
        }

        public AsyncSocket async() {
            return this.socket;
        }

        @Override
        public int getColor() {
            return this.socket.getColor();
        }

        public void setDestination(Offerable<? super AsyncSocket.Event> dest) {
            super.setDest(dest);
        }

        @Override
        protected void deliverFailure(Offerable<? super AsyncSocket.Event> dest, final Throwable t) {
            AsyncSocket.ErroneousEvent error = new AsyncSocket.ErroneousEvent(){

                public Throwable getCause() {
                    return t;
                }

                public int getColor() {
                    return BaseNioEvent.this.socket.getColor();
                }

                public String getMessage() {
                    return t.getMessage();
                }

                public AsyncSocket.Event getEvent() {
                    return BaseNioEvent.this;
                }

                public AsyncSocket async() {
                    return BaseNioEvent.this.socket;
                }
            };
            dest.offer((Object)error);
        }
    }
}

